/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.bivariate_header;

import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.worksheets.cards.BivariateCard;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.GroupingHelpers;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.eda.worksheets.models.BinningMode;
import com.dataiku.dip.eda.worksheets.models.Variable;
import java.util.ArrayList;
import java.util.List;

public class BivariateBoxPlotCard
extends BivariateCard {
    public static final String TYPE = "bivariate_box_plot";
    public int maxValues = 5;
    public boolean groupOthers = true;
    BinningMode binningMode = BinningMode.AUTO;
    public double[] customBinningBoundaries = new double[0];

    private Variable getAxisVariable() {
        if (this.xColumn.isCategorical() && this.yColumn.isCategorical()) {
            throw new RuntimeException("Box plot cannot be computed on two categorical variables");
        }
        if (this.xColumn.isContinuous() && !this.yColumn.isContinuous()) {
            return this.yColumn;
        }
        return this.xColumn;
    }

    private Variable getAggregatedVariable() {
        return this.getAxisVariable() == this.xColumn ? this.yColumn : this.xColumn;
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<GroupedComputation, GroupedComputation.GroupedComputationResult>(){

            @Override
            public GroupedComputation getComputationPlan() {
                Grouping grouping = GroupingHelpers.handleCustomizableVariableGrouping(BivariateBoxPlotCard.this.getAxisVariable(), BivariateBoxPlotCard.this.binningMode, BivariateBoxPlotCard.this.maxValues, BivariateBoxPlotCard.this.groupOthers, BivariateBoxPlotCard.this.customBinningBoundaries, true);
                return new GroupedComputation(BoxPlotFragment.getComputationPlan(BivariateBoxPlotCard.this.getAggregatedVariable().name), grouping);
            }

            @Override
            protected CardResult buildFromAvailableResult(GroupedComputation.GroupedComputationResult result, ComputationResultDataStreamer dataStreamer) {
                List<Filter> axisVals = result.groups.listFilters();
                ArrayList<BoxPlotFragment> boxPlots = new ArrayList<BoxPlotFragment>();
                for (ComputationResult cr : result.results) {
                    boxPlots.add(BoxPlotFragment.build(cr));
                }
                return new BivariateBoxPlotCardResult(boxPlots, axisVals, BivariateBoxPlotCard.this.getAxisVariable(), BivariateBoxPlotCard.this.getAggregatedVariable());
            }
        };
    }

    public static class BivariateBoxPlotCardResult
    extends CardResult {
        public List<BoxPlotFragment> boxPlots;
        public List<Filter> axisVals;
        public Variable axisVariable;
        public Variable aggregatedVariable;

        public BivariateBoxPlotCardResult(List<BoxPlotFragment> boxPlots, List<Filter> axisVals, Variable axisVariable, Variable aggregatedVariable) {
            this.boxPlots = boxPlots;
            this.axisVals = axisVals;
            this.axisVariable = axisVariable;
            this.aggregatedVariable = aggregatedVariable;
        }

        private BivariateBoxPlotCardResult() {
        }
    }
}

