/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.bivariate_header;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.bivariate.FitCurve;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.multivariate.FetchValues;
import com.dataiku.dip.eda.compute.curves.PolynomialCurve;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.filtering.NotFilter;
import com.dataiku.dip.eda.compute.grouping.CrossGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.dataiku.dip.eda.compute.grouping.SubsampledGrouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.BivariateCard;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithColorBy;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithHighlight;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.GroupingHelpers;
import com.dataiku.dip.eda.worksheets.models.SplitBySpec;
import com.dataiku.dip.utils.ImmutableValueObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class ScatterPlotCard
extends BivariateCard
implements CardWithHighlight,
CardWithColorBy {
    public static final String TYPE = "scatter_plot";
    public int symbolSize = 4;
    public int maxNumberOfPoints = 100000;
    boolean showTrend;
    @Nullable
    Filter highlightFilter;
    @Nullable
    SplitBySpec colorBy;

    @Override
    public void setHighlightFilter(Filter filter) {
        this.highlightFilter = filter;
    }

    @Override
    public void setColorBy(SplitBySpec colorBy) {
        this.colorBy = colorBy;
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<GroupedComputation, GroupedComputation.GroupedComputationResult>(){

            @Override
            public GroupedComputation getComputationPlan() {
                Grouping highlightGrouping = ScatterPlotCard.this.highlightFilter == null ? SubsetGrouping.all() : new UnionGrouping(new SubsetGrouping(ScatterPlotCard.this.highlightFilter), new SubsetGrouping(new NotFilter(ScatterPlotCard.this.highlightFilter)));
                Grouping colorByGrouping = ScatterPlotCard.this.colorBy == null ? SubsetGrouping.all() : ScatterPlotCard.this.colorBy.asGrouping();
                ArrayList<Computation> subComputations = new ArrayList<Computation>();
                FetchValues fetchValues = new FetchValues(Arrays.asList(ScatterPlotCard.this.xColumn.name, ScatterPlotCard.this.yColumn.name));
                subComputations.add(fetchValues);
                if (ScatterPlotCard.this.showTrend) {
                    FitCurve fitCurve = new FitCurve(ScatterPlotCard.this.xColumn.name, ScatterPlotCard.this.yColumn.name, new PolynomialCurve(1));
                    subComputations.add(fitCurve);
                }
                return new GroupedComputation(new GroupedComputation(new GroupedComputation(new MultiComputation(subComputations), new CrossGrouping(highlightGrouping, colorByGrouping)), new SubsampledGrouping(ScatterPlotCard.this.maxNumberOfPoints)), GroupingHelpers.groupOverNotMissingNumericalColumns(ScatterPlotCard.this.xColumn, ScatterPlotCard.this.yColumn));
            }

            @Override
            protected CardResult buildFromAvailableResult(GroupedComputation.GroupedComputationResult result, ComputationResultDataStreamer dataStreamer) {
                ComputationResult topLevelSubsetResult = result.results.get(0);
                if (!topLevelSubsetResult.isAvailable()) {
                    return 1.buildFromUnavailableResult(topLevelSubsetResult.getFirstUnavailableResult());
                }
                ComputationResult subsampleResult = topLevelSubsetResult.asGrouped().results.get(0);
                if (!subsampleResult.isAvailable()) {
                    return 1.buildFromUnavailableResult(subsampleResult.getFirstUnavailableResult());
                }
                GroupedComputation.GroupedComputationResult subsampleGroupResult = subsampleResult.asGrouped();
                GroupingResult highlightGroups = subsampleGroupResult.groups.asCross().groups.get(0);
                GroupingResult colorByGroups = subsampleGroupResult.groups.asCross().groups.get(1);
                ScatterPlotCardResult cardResult = new ScatterPlotCardResult();
                cardResult.groups.addAll(colorByGroups.listFilters());
                for (int highlightIndex = 0; highlightIndex < highlightGroups.size(); ++highlightIndex) {
                    for (int groupIndex = 0; groupIndex < colorByGroups.size(); ++groupIndex) {
                        ComputationResult secondResult;
                        int computationIndex = highlightIndex * colorByGroups.size() + groupIndex;
                        ComputationResult computationResult = subsampleGroupResult.results.get(computationIndex);
                        if (!computationResult.isAvailable()) {
                            return 1.buildFromUnavailableResult(computationResult.getFirstUnavailableResult());
                        }
                        ComputationResult firstResult = computationResult.asMulti().get(0);
                        if (!firstResult.isAvailable()) {
                            return 1.buildFromUnavailableResult(firstResult.getFirstUnavailableResult());
                        }
                        ScatterPlotSeries series = new ScatterPlotSeries();
                        series.groupIndex = groupIndex;
                        series.isHighlighted = highlightGroups.size() > 1 && highlightIndex == 0;
                        FetchValues.FetchValuesResult fetchValuesResult = firstResult.as(FetchValues.FetchValuesResult.class);
                        series.xSeries = fetchValuesResult.series.get(0);
                        series.ySeries = fetchValuesResult.series.get(1);
                        if (ScatterPlotCard.this.showTrend && (secondResult = computationResult.asMulti().get(1)).isAvailable()) {
                            FitCurve.FitCurveResult fitCurveResult = secondResult.as(FitCurve.FitCurveResult.class);
                            series.trend = (PolynomialCurve.ParametrizedPolynomialCurve)fitCurveResult.parametrized;
                        }
                        cardResult.series.add(series);
                    }
                }
                return cardResult;
            }
        };
    }

    public static class ScatterPlotCardResult
    extends CardResult {
        List<Filter> groups = new ArrayList<Filter>();
        public List<ScatterPlotSeries> series = new ArrayList<ScatterPlotSeries>();

        private ScatterPlotCardResult() {
        }
    }

    public static class ScatterPlotSeries
    extends ImmutableValueObject {
        public boolean isHighlighted;
        public int groupIndex;
        public double[] xSeries;
        public double[] ySeries;
        @Nullable
        public PolynomialCurve.ParametrizedPolynomialCurve trend;
    }
}

