/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.fragments;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.Count;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.filtering.AllFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.CrossGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.common.GroupingHelpers;
import com.dataiku.dip.eda.worksheets.models.BinningMode;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public class BivariateFrequencyTableFragment
extends ImmutableValueObject {
    public List<Filter> xValues;
    public List<Filter> yValues;
    public long total;
    public long[] counts;
    public double[] expectedCounts;
    public long[] xCounts;
    public long[] yCounts;

    public static Computation getFrequencyTablePlan(Variable x, Variable y, BinningMode xBinningMode, BinningMode yBinningMode, @Nullable Integer maxValuesX, @Nullable Integer maxValuesY, boolean groupWithOthersX, boolean groupWithOthersY, double[] xCustomBinningBoundaries, double[] yCustomBinningBoundaries) {
        Grouping xGrouping = GroupingHelpers.handleCustomizableVariableGrouping(x, xBinningMode, maxValuesX, groupWithOthersX, xCustomBinningBoundaries, true);
        Grouping yGrouping = GroupingHelpers.handleCustomizableVariableGrouping(y, yBinningMode, maxValuesY, groupWithOthersY, yCustomBinningBoundaries, true);
        return new GroupedComputation(new Count(), new CrossGrouping(new UnionGrouping(new SubsetGrouping(new AllFilter()), xGrouping), new UnionGrouping(new SubsetGrouping(new AllFilter()), yGrouping)));
    }

    public static BivariateFrequencyTableFragment buildFrequencyTable(ComputationResult genericResult) {
        GroupedComputation.GroupedComputationResult result = genericResult.asGrouped();
        List<Filter> xFilters = result.asGrouped().groups.asCross().groups.get(0).listFilters();
        List<Filter> yFilters = result.asGrouped().groups.asCross().groups.get(1).listFilters();
        List<Filter> xValues = xFilters.subList(1, xFilters.size());
        List<Filter> yValues = yFilters.subList(1, yFilters.size());
        int nbXValues = xValues.size();
        int nbYValues = yValues.size();
        int nbTotalCells = nbXValues * nbYValues;
        long totalCount = result.results.get((int)0).as(Count.CountResult.class).count;
        long[] counts = new long[nbTotalCells];
        for (int i = 0; i < nbXValues; ++i) {
            for (int j = 0; j < nbYValues; ++j) {
                counts[i * nbYValues + j] = result.results.get((int)((i + 1) * (nbYValues + 1) + j + 1)).as(Count.CountResult.class).count;
            }
        }
        long[] xCounts = new long[nbXValues];
        long[] yCounts = new long[nbYValues];
        for (int i = 0; i < nbXValues; ++i) {
            xCounts[i] = result.results.get((int)((i + 1) * (nbYValues + 1))).as(Count.CountResult.class).count;
        }
        for (int j = 0; j < nbYValues; ++j) {
            yCounts[j] = result.results.get((int)(j + 1)).as(Count.CountResult.class).count;
        }
        double[] expectedCounts = new double[nbTotalCells];
        if (totalCount > 0L) {
            for (int i = 0; i < nbXValues; ++i) {
                for (int j = 0; j < nbYValues; ++j) {
                    expectedCounts[i * nbYValues + j] = (double)(xCounts[i] * yCounts[j]) / (double)totalCount;
                }
            }
        }
        BivariateFrequencyTableFragment tableData = new BivariateFrequencyTableFragment();
        tableData.xValues = xValues;
        tableData.yValues = yValues;
        tableData.total = totalCount;
        tableData.counts = counts;
        tableData.expectedCounts = expectedCounts;
        tableData.xCounts = xCounts;
        tableData.yCounts = yCounts;
        return tableData;
    }
}

