/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.worksheets.cards.ACFPlotCard;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.Fit2DDistributionCard;
import com.dataiku.dip.eda.worksheets.cards.ParallelCoordinatesPlotCard;
import com.dataiku.dip.eda.worksheets.cards.ScatterPlot3DCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.ScatterPlotCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractHeaderCard;
import com.dataiku.dip.utils.JSON;
import java.util.stream.Collectors;

public class CardMiniaturizer {
    public Card minify(Card card) {
        if (card instanceof AbstractHeaderCard) {
            return this.minifyHeaderCard((AbstractHeaderCard)card);
        }
        if (card instanceof Fit2DDistributionCard) {
            return this.minifyKDE2D((Fit2DDistributionCard)card);
        }
        if (card instanceof ScatterPlot3DCard) {
            return this.minifyScatter3D((ScatterPlot3DCard)card);
        }
        if (card instanceof ScatterPlotCard) {
            return this.minifyScatter2D((ScatterPlotCard)card);
        }
        if (card instanceof ParallelCoordinatesPlotCard) {
            return this.minifyPCP((ParallelCoordinatesPlotCard)card);
        }
        if (card instanceof ACFPlotCard) {
            return this.minifyACF((ACFPlotCard)card);
        }
        return card;
    }

    private Card minifyACF(ACFPlotCard card) {
        ACFPlotCard copy = (ACFPlotCard)JSON.deepCopy((Object)card);
        copy.showSummary = false;
        return copy;
    }

    private Card minifyHeaderCard(AbstractHeaderCard card) {
        AbstractHeaderCard copy = (AbstractHeaderCard)((Object)JSON.deepCopy((Object)((Object)card)));
        copy.xColumns = copy.splitBy == null ? copy.xColumns.stream().limit(5L).collect(Collectors.toList()) : copy.xColumns.stream().limit(2L).collect(Collectors.toList());
        return copy;
    }

    private Card minifyKDE2D(Fit2DDistributionCard card) {
        Fit2DDistributionCard copy = (Fit2DDistributionCard)((Object)JSON.deepCopy((Object)((Object)card)));
        copy.xResolution = Math.min(copy.xResolution, 100);
        copy.yResolution = Math.min(copy.yResolution, 50);
        return copy;
    }

    private Card minifyScatter3D(ScatterPlot3DCard card) {
        ScatterPlot3DCard copy = (ScatterPlot3DCard)JSON.deepCopy((Object)card);
        copy.maxNumberOfPoints = Math.min(400, copy.maxNumberOfPoints);
        copy.symbolSize = 8;
        return copy;
    }

    private Card minifyScatter2D(ScatterPlotCard card) {
        ScatterPlotCard copy = (ScatterPlotCard)JSON.deepCopy((Object)card);
        copy.maxNumberOfPoints = Math.min(200, copy.maxNumberOfPoints);
        copy.symbolSize = 8;
        return copy;
    }

    private Card minifyPCP(ParallelCoordinatesPlotCard card) {
        ParallelCoordinatesPlotCard copy = (ParallelCoordinatesPlotCard)JSON.deepCopy((Object)card);
        copy.maxNumberOfPoints = Math.min(200, copy.maxNumberOfPoints);
        return copy;
    }
}

