/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.engine;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.IPubSubService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketBasedLocalFolderService {
    @Autowired
    private IPubSubService pubSubService;
    private final File baseFolder = DKUApp.getFile((String[])new String[]{"tmp", "ticket-folders"});
    private final Map<APITicketService.Ticket, File> ticketFolders = Collections.synchronizedMap(new HashMap());
    private final ScheduledExecutorService periodicExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("TicketFolderCleaner").build());
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.engine.ticketFolders");

    @PostConstruct
    public void schedulePeriodicCleanup() throws IOException {
        if (DKUFileUtils.exists((File)this.baseFolder, (String[])new String[0])) {
            FilesystemACLUtils.removeACLRestrictiveMask(this.baseFolder);
            DKUFileUtils.deleteDirectory((File)this.baseFolder);
        }
        DKUFileUtils.mkdirs711((File)this.baseFolder);
        this.pubSubService.subscribe("backend-api-ticket-expired", evt -> this.reclaimFolder(evt.getTicket(), false));
        int cleanupPeriod = DKUApp.getParams().getIntParam("dku.engine.ticketFolders.cleanupPeriodInMinutes", Integer.valueOf(5));
        logger.infoV("Scheduling periodic cleanup of unused ticket folders every %d minutes, starting in %d minutes", new Object[]{cleanupPeriod, cleanupPeriod});
        this.periodicExecutor.scheduleWithFixedDelay(this::reclaimFolders, cleanupPeriod, cleanupPeriod, TimeUnit.MINUTES);
    }

    @PreDestroy
    public void shutdownExecutor() {
        this.periodicExecutor.shutdownNow();
    }

    private static String ticketLockName(APITicketService.Ticket ticket) {
        return String.format("dku.ticket-folder.%s", ticket.getId());
    }

    private static File keepFileFor(File folder) {
        return DKUApp.getFile((File)folder, (String[])new String[]{"keep.txt"});
    }

    private File newTicketFolder() {
        String name = "ticket-folder_" + SecretKeyGenerator.generate((int)16);
        return DKUApp.getFile((File)this.baseFolder, (String[])new String[]{name});
    }

    public String getTicketFolder(APITicketService.Ticket ticket, String projectKey) throws IOException, DKUSecurityException, InterruptedException {
        String lockName = TicketBasedLocalFolderService.ticketLockName(ticket);
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            File folder = this.ticketFolders.computeIfAbsent(ticket, t -> this.newTicketFolder());
            if (DKUFileUtils.exists((File)folder, (String[])new String[0])) {
                FileUtils.touch((File)TicketBasedLocalFolderService.keepFileFor(folder));
            } else {
                logger.info((Object)String.format("Initialize ticket folder %s", folder.getAbsolutePath()));
                DKUFileUtils.mkdirs700((File)folder);
                FileUtils.touch((File)TicketBasedLocalFolderService.keepFileFor(folder));
                AuthCtx authCtx = ticket.getViaAuthCtx();
                FilesystemACLUtils.grantFSFullACLs(authCtx, projectKey, folder);
            }
            String string = folder.getAbsolutePath();
            return string;
        }
    }

    private void reclaimFolder(APITicketService.Ticket ticket, boolean unlessRecentlyTouched) {
        String lockName = TicketBasedLocalFolderService.ticketLockName(ticket);
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            File folder = this.ticketFolders.get(ticket);
            if (folder == null) {
                return;
            }
            if (unlessRecentlyTouched && TicketBasedLocalFolderService.wasRecentlyTouched(folder)) {
                return;
            }
            TicketBasedLocalFolderService.deleteFolder(folder);
            this.ticketFolders.remove(ticket);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Cannot reclaim ticket folder for ticket: %s", ticket.getId()), (Throwable)e);
        }
    }

    private void reclaimFolders() {
        try {
            this.reclaimUntouchedFolders();
            this.reclaimUntrackedFolders();
        }
        catch (Exception e) {
            logger.error((Object)"Cannot reclaim ticket folders", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reclaimUntouchedFolders() {
        HashSet<APITicketService.Ticket> tickets;
        Map<APITicketService.Ticket, File> map = this.ticketFolders;
        synchronized (map) {
            tickets = new HashSet<APITicketService.Ticket>(this.ticketFolders.keySet());
        }
        for (APITicketService.Ticket ticket : tickets) {
            this.reclaimFolder(ticket, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reclaimUntrackedFolders() {
        HashSet<File> trackedFolders;
        File[] folders = this.baseFolder.listFiles();
        if (folders == null) {
            return;
        }
        Map<APITicketService.Ticket, File> map = this.ticketFolders;
        synchronized (map) {
            trackedFolders = new HashSet<File>(this.ticketFolders.values());
        }
        Set trackedPaths = trackedFolders.stream().map(File::getAbsolutePath).collect(Collectors.toSet());
        for (File folder : folders) {
            if (trackedPaths.contains(folder.getAbsolutePath())) continue;
            if (folder.isDirectory()) {
                logger.info((Object)String.format("Deleting untracked folder: %s", folder.getAbsolutePath()));
                TicketBasedLocalFolderService.deleteFolder(folder);
                continue;
            }
            logger.warn((Object)String.format("Deleting unexpected untracked file in ticket folder: %s", folder.getAbsolutePath()));
            try {
                DKUFileUtils.delete((File)folder);
            }
            catch (IOException e) {
                logger.error((Object)String.format("Cannot delete file: %s", folder.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private static boolean wasRecentlyTouched(File folder) {
        File keepFile = TicketBasedLocalFolderService.keepFileFor(folder);
        BasicFileAttributes attrs = DKUFileUtils.getAttributesNoFollowLinksOrNull((File)keepFile);
        if (attrs == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        long lastModified = attrs.lastModifiedTime().toMillis();
        long delay = DKUApp.getParams().getLongParam("dku.engine.ticketFolders.reclaimAfterDelayInSeconds", 60L);
        return now - lastModified < (delay = Math.max(delay, 60L)) * 1000L;
    }

    private static void deleteFolder(File folder) {
        try {
            if (DKUFileUtils.exists((File)folder, (String[])new String[0])) {
                FilesystemACLUtils.removeACLRestrictiveMask(folder);
                DKUFileUtils.deleteDirectory((File)folder);
                logger.info((Object)String.format("Reclaimed ticket folder: %s", folder.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Cannot reclaim ticket folder: %s", folder.getAbsolutePath()), (Throwable)e);
        }
    }
}

