/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.export.ExportFutureThreadBase;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportUtils;
import com.dataiku.dip.export.hooks.FileExportPostprocessingHookHandler;
import com.dataiku.dip.export.input.ExportDataset;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.input.TableColoring;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.backend.ExportStateChangedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.File;
import org.apache.log4j.Logger;

public class LocalExportFutureThread
extends ExportFutureThreadBase {
    private static final Logger logger = Logger.getLogger((String)"dku.export.thread.local");
    private final ExportService.LocalExportJob job;
    private boolean logExportReady = true;

    public LocalExportFutureThread(AuthCtx user, ExportService.LocalExportJob job) {
        super(user, job.input, job.status.exportId);
        this.job = job;
        logger.info((Object)("Start LocalExportThread user=" + user.getIdentifier()));
    }

    public static FuturePayload buildFuturePayload(ExportInput input, String exportId) {
        return ExportFutureThreadBase.buildFuturePayload(input, exportId);
    }

    @Override
    public FuturePayload getPayload() {
        return this.futurePayload;
    }

    @Override
    public double getDangerosity() {
        return 0.0;
    }

    public void setLogExportReady(boolean value) {
        this.logExportReady = value;
    }

    public void postRunCleanup() {
        long fileSize;
        if (!this.logExportReady) {
            return;
        }
        if (this.job.status.targetFile != null) {
            File f = new File(this.job.status.targetFile);
            if (!f.isFile()) {
                logger.warn((Object)String.format("Export file '%s' is missing", this.job.status.exportId));
                return;
            }
            fileSize = f.length();
        } else {
            fileSize = -1L;
        }
        ((AuditTrailService)SpringUtils.getBean(AuditTrailService.class)).generic("export-ready").with("exportId", this.job.status.exportId).with("exportMethod", this.job.status.exportMethod.name()).with("fileSize", (Number)fileSize).emit();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExportFutureThreadBase.ExportResult compute() throws Exception {
        ExportFutureThreadBase.ExportResult exportResult;
        logger.info((Object)("Started export thread [" + this.job.status.exportId + "]"));
        InputThread inputThread = null;
        OutputThread outputThread = null;
        try {
            inputThread = new InputThread();
            outputThread = new OutputThread();
            inputThread.start();
            outputThread.start();
            this.job.status.state = JobState.RUNNING;
            this.job.status.startDate = System.currentTimeMillis();
            this.job.status.inputDescription = this.job.input.describe();
            this.saveStatus(this.job.status);
            long delayMs = 800L;
            do {
                Thread.sleep(delayMs);
                delayMs = (long)Math.min((double)delayMs * 1.1, 15000.0);
                this.state.propagateFailureIfAny();
            } while (!this.state.isExportFinished());
            this.job.status.state = JobState.DONE;
            this.job.status.endDate = System.currentTimeMillis();
            this.job.status.writtenRecords = this.state.getNbRecords();
            this.job.status.totalRecords = this.state.getInputSize();
            this.job.status.writtenBytes = this.job.output.getWrittenBytes();
            if (this.job.status.targetFile != null) {
                FileExportPostprocessingHookHandler.onPostDataExportToFile(this.getOwner(), new File(this.job.status.targetFile), this.job.input);
            }
            exportResult = this.getResultOK();
        }
        catch (InterruptedException e) {
            try {
                Thread.currentThread().interrupt();
                this.job.status.state = JobState.ABORTED;
                this.job.status.endDate = System.currentTimeMillis();
                logger.warn((Object)"Export aborted", (Throwable)e);
                throw e;
                catch (CustomPythonKernelException e2) {
                    this.job.status.state = JobState.FAILED;
                    this.job.status.endDate = System.currentTimeMillis();
                    this.job.status.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e2);
                    this.job.status.logTail = e2.logTail;
                    logger.error((Object)"Export failed", (Throwable)e2);
                    throw e2;
                }
                catch (Exception e3) {
                    this.job.status.state = JobState.FAILED;
                    this.job.status.endDate = System.currentTimeMillis();
                    this.job.status.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e3);
                    logger.error((Object)"Export failed", (Throwable)e3);
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                this.terminateSlaveThreads(inputThread, outputThread);
                this.saveStatus(this.job.status);
                ((PubSubService)((Object)SpringUtils.getBean(PubSubService.class))).publish(new ExportStateChangedEvent(this.job.status));
                logger.info((Object)("End of export thread [" + this.job.status.exportId + "] status=" + String.valueOf((Object)this.job.status.state)));
                ((APITicketService)SpringUtils.getBean(APITicketService.class)).expireTicket(this.job.ticket);
                throw throwable;
            }
        }
        this.terminateSlaveThreads(inputThread, outputThread);
        this.saveStatus(this.job.status);
        ((PubSubService)((Object)SpringUtils.getBean(PubSubService.class))).publish(new ExportStateChangedEvent(this.job.status));
        logger.info((Object)("End of export thread [" + this.job.status.exportId + "] status=" + String.valueOf((Object)this.job.status.state)));
        ((APITicketService)SpringUtils.getBean(APITicketService.class)).expireTicket(this.job.ticket);
        return exportResult;
    }

    public ExportService.LocalExportJob getJob() {
        return this.job;
    }

    public boolean waitForSource() throws InterruptedException {
        do {
            Thread.sleep(100L);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("wFS state=" + String.valueOf((Object)this.job.status.state) + " iii=" + this.state.isInputInitializedAndStarted()));
            }
            if (this.job.status.state == JobState.RUNNING) continue;
            logger.warn((Object)("Job status is not RUNNING anymore but " + String.valueOf((Object)this.job.status.state) + " with msg:" + this.job.status.errorMessage));
            return false;
        } while (!this.state.isInputInitializedAndStarted());
        return true;
    }

    private class InputThread
    extends Thread {
        private InputThread() {
        }

        @Override
        public void run() {
            try {
                try {
                    LocalExportFutureThread.this.job.input.initialize(LocalExportFutureThread.this.job, LocalExportFutureThread.this.job.status.params.selection, LocalExportFutureThread.this.state.cf);
                    LocalExportFutureThread.this.state.setInputInitialized(LocalExportFutureThread.this.job.input.getInputSize());
                    LocalExportFutureThread.this.state.setSchema(LocalExportFutureThread.this.job.input.getSchema());
                    LocalExportFutureThread.this.job.input.stream(LocalExportFutureThread.this.state.getOutputStream());
                    if (!LocalExportFutureThread.this.state.monitoredOutputStream.isLastRowEmitted()) {
                        throw new Exception("lastRowEmitted() has not been called by the ExportInput");
                    }
                    LocalExportFutureThread.this.state.setInputFinished();
                }
                finally {
                    LocalExportFutureThread.this.job.input.close();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LocalExportFutureThread.this.state.setOutputFailed(new Exception("Export input thread has been interrupted"));
            }
            catch (Exception e) {
                LocalExportFutureThread.this.state.setInputFailed(e);
            }
        }
    }

    private class OutputThread
    extends Thread {
        private OutputThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    LocalExportFutureThread.this.job.output.checkFeasability(LocalExportFutureThread.this.job);
                    Schema schema = LocalExportFutureThread.this.state.waitForSchema();
                    TableColoring coloring = ExportUtils.computeColoring(LocalExportFutureThread.this.job.input);
                    MemTable table = null;
                    if (coloring != null && LocalExportFutureThread.this.job.input instanceof ExportDataset) {
                        SerializedShakerScript.TableColoring tableColoring;
                        SerializedDataset serializedDataset = ((ExportDataset)LocalExportFutureThread.this.job.input).dataset;
                        Dataset dataset = Dataset.fromSerialized(serializedDataset);
                        SerializedShakerScript script = new SerializedShakerScript();
                        script.contextProjectKey = script.getProjectKey(dataset);
                        if (coloring.scheme == ColoringDefinition.TableColoringScheme.ALL_COLUMNS_VALUES || coloring.scheme == ColoringDefinition.TableColoringScheme.MEANING_AND_STATUS) {
                            if (coloring.coloringGroups != null && coloring.coloringGroups.size() > 0) {
                                coloring.scheme = ColoringDefinition.TableColoringScheme.COLORING_GROUPS;
                            } else if (coloring.individualColumnsRules != null && coloring.individualColumnsRules.size() > 0) {
                                coloring.scheme = ColoringDefinition.TableColoringScheme.INDIVIDUAL_COLUMNS_RULES;
                            }
                        }
                        script.coloring = tableColoring = ExportUtils.convertColoring(coloring);
                        script.origin = SerializedShakerScript.ShakerOrigin.DATASET_EXPLORE;
                        DSSAuthCtx user = ((ExportDataset)LocalExportFutureThread.this.job.input).authCtx;
                        MemScriptRunner.TableWithReport tableWithReport = ((DataService)SpringUtils.getBean(DataService.class)).get_NOTRANSACTION(dataset, script, null, null, false, (AuthCtx)user);
                        if (tableWithReport != null && tableWithReport.table != null) {
                            table = tableWithReport.table;
                        }
                    }
                    LocalExportFutureThread.this.job.output.setExportContext(new ExportOutput.ExportContext(table, coloring, LocalExportFutureThread.this.warningsContext));
                    LocalExportFutureThread.this.job.output.initialize(LocalExportFutureThread.this.job, schema, LocalExportFutureThread.this.state.cf);
                    LocalExportFutureThread.this.job.output.stream(LocalExportFutureThread.this.state.getInputStream());
                    LocalExportFutureThread.this.state.setOutputFinished();
                }
                finally {
                    LocalExportFutureThread.this.job.output.close();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LocalExportFutureThread.this.state.setOutputFailed(new Exception("Export output thread has been interrupted"));
            }
            catch (Exception e) {
                LocalExportFutureThread.this.state.setOutputFailed(e);
            }
        }
    }
}

