/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.expressions;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.refine.grel.ControlFunctionRegistry;
import com.google.refine.udaf.UdafControlFunctionRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExpressionFixingService {
    @Autowired
    private VariablesService variablesService;

    public String fixExpression(String expression, String fixName, String projectKey, ColumnFactory cf) {
        return this.fixExpression(expression, fixName, projectKey, cf, UdafControlFunctionRegistry.getInstance());
    }

    public String fixExpression(String expression, String fixName, String projectKey, ColumnFactory cf, ControlFunctionRegistry functionRegistry) {
        if (cf == null) {
            return expression;
        }
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        Expression expr = new Expression(expression, functionRegistry);
        expr.setColumnFactory(cf);
        expr.setVariablesContext(vc);
        expr.fixup(fixName);
        return expr.getString();
    }
}

