/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.databricks;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.externalinfras.ExternalInfraEndpoint;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.databricks.DatabricksHTTPClient;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksExperiment;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModel;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModelVersion;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServedEntity;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServedEntityHead;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpoint;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointDetailedConfig;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointDetails;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointState;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksWorkloadSize;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksWorkloadType;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksWorkspaceDirectoryObject;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksEndpoint;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksModelVersion;
import com.dataiku.dip.externalinfras.databricks.http.get.DatabricksExperimentMetadataResponse;
import com.dataiku.dip.externalinfras.databricks.http.patch.DatabricksUpdateServingEndpointTagsRequest;
import com.dataiku.dip.externalinfras.databricks.http.post.DatabricksInvokeServingEndpointRequest;
import com.dataiku.dip.externalml.mlflow.DatabricksUtilsKernelCachingService;
import com.dataiku.dip.externalml.mlflow.DatabricksUtilsKernelProtocol;
import com.dataiku.dip.externalml.mlflow.DatabricksUtilsRunner;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.RateLimiterRegistry;
import com.dataiku.dip.utils.BackOffStrategy;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.RateLimiter;
import com.dataiku.dss.shadelib.org.apache.http.HttpRequestInterceptor;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.BackOff;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DatabricksUtils {
    private static final int DEFAULT_MODEL_REGISTRATION_TIMEOUT_S = 300;
    private static final int DEFAULT_ENDPOINT_READINESS_MIN_WAIT_S = 30;
    private static final int DEFAULT_ENDPOINT_READINESS_MAX_WAIT_S = 60;
    private static final int DEFAULT_ENDPOINT_READINESS_TIMEOUT_S = 1800;
    private static final String DEFAULT_MODEL_REGISTRATION_TIMEOUT_CONFIG_KEY = "dku.deployer.deployment.databricks.utils.modelRegistrationTimeoutS";
    private static final String DEFAULT_ENDPOINT_READINESS_MIN_WAIT_CONFIG_KEY = "dku.deployer.deployment.databricks.utils.endpointReadinessMinWaitS";
    private static final String DEFAULT_ENDPOINT_READINESS_MAX_WAIT_CONFIG_KEY = "dku.deployer.deployment.databricks.utils.endpointReadinessMaxWaitS";
    private static final String DEFAULT_ENDPOINT_READINESS_TIMEOUT_CONFIG_KEY = "dku.deployer.deployment.databricks.utils.endpointReadinessTimeoutS";
    public static final double DEFAULT_RATE_LIMIT = 10.0;
    public static final String RATE_LIMITER_NAME = "databricksHTTPClient";
    private static final BackOffStrategy MODEL_REGISTRATION_BACKOFF_STRATEGY;
    private static final BackOffStrategy SERVING_ENDPOINT_READINESS_BACKOFF_STRATEGY;
    private static final DKULogger logger;

    public static RateLimiter getDatabricksRateLimiter() {
        return RateLimiterRegistry.forName(RATE_LIMITER_NAME, 10.0);
    }

    public static void checkRate(String action) {
        double waited = DatabricksUtils.getDatabricksRateLimiter().acquire();
        if (waited > 0.0) {
            logger.infoV("Waited %.3f seconds for %s (rate-limited by %s)", new Object[]{waited, action, RATE_LIMITER_NAME});
        }
    }

    public static HttpRequestInterceptor getRateLimitingHttpInterceptor() {
        return (httpRequest, httpContext) -> DatabricksUtils.checkRate(httpRequest.getRequestLine().getUri());
    }

    private static DatabricksWorkspaceDirectoryObject getWorkspaceObject(@Nonnull AuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout, @Nonnull String objectPath) throws DKUSecurityException, IOException, URISyntaxException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)connectionName), (Object)"The connection name cannot be null.");
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnection(user, connectionName);
        DatabricksHTTPClient client = connection.getClient(user, connectTimeout, socketTimeout);
        return client.getWorkspaceObject(objectPath);
    }

    private static List<DatabricksWorkspaceDirectoryObject> listWorkspaceObjects(@Nonnull AuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout, @Nonnull String parentDirectoryPath) throws DKUSecurityException, IOException, URISyntaxException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)connectionName), (Object)"The connection name cannot be null.");
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnection(user, connectionName);
        DatabricksHTTPClient client = connection.getClient(user, connectTimeout, socketTimeout);
        return client.listWorkspaceObjects(parentDirectoryPath);
    }

    private static List<DatabricksWorkspaceDirectoryObject> listWorkspaceObjects(@Nonnull AuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout, @Nonnull String parentDirectoryPath, DatabricksWorkspaceDirectoryObject.Type type) throws DKUSecurityException, IOException, URISyntaxException {
        return DatabricksUtils.listWorkspaceObjects(user, connectionName, connectTimeout, socketTimeout, parentDirectoryPath).stream().filter(o -> o.objectType == type).collect(Collectors.toList());
    }

    public static List<DatabricksWorkspaceDirectoryObject> listWorkspaceDirectories(@Nonnull AuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout, @Nonnull String parentDirectoryPath) throws DKUSecurityException, IOException, URISyntaxException {
        return DatabricksUtils.listWorkspaceObjects(user, connectionName, connectTimeout, socketTimeout, parentDirectoryPath, DatabricksWorkspaceDirectoryObject.Type.DIRECTORY);
    }

    public static List<DatabricksServingEndpoint> listEndpoints(@Nonnull AuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout) throws DKUSecurityException, IOException, URISyntaxException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)connectionName), (Object)"The connection name cannot be null.");
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnection(user, connectionName);
        DatabricksHTTPClient client = connection.getClient(user, connectTimeout, socketTimeout);
        return client.listServingEndpoints();
    }

    public static List<ExternalInfraEndpoint> listExternalEndpoints(@Nonnull AuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout) throws DKUSecurityException, IOException, URISyntaxException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)connectionName), (Object)"The connection name cannot be null.");
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnection(user, connectionName);
        DatabricksHTTPClient client = connection.getClient(user, connectTimeout, socketTimeout);
        return client.listServingEndpoints().stream().filter(databricksServingEndpoint -> databricksServingEndpoint.getServedModelType() == DatabricksServedEntityHead.DatabricksServedModelType.CLASSICAL_MODEL).map(databricksServingEndpoint -> new ExternalInfraEndpoint(databricksServingEndpoint.id, databricksServingEndpoint.name, databricksServingEndpoint.id, (DeploymentHealth)((Object)((Object)DatabricksUtils.getEndpointHealth((DatabricksServingEndpointState)databricksServingEndpoint.state).first)), (InfoMessage.InfoMessages)DatabricksUtils.getEndpointHealth((DatabricksServingEndpointState)databricksServingEndpoint.state).second, DatabricksUtils.getEndpointResourceLink(databricksServingEndpoint.name, connection.params.getHostBaseURL()))).collect(Collectors.toList());
    }

    public static DatabricksServingEndpointDetails createEndpoint(@Nonnull AuthCtx user, @Nonnull DatabricksModelDeploymentConnection connection, int connectionTimeout, int socketTimeout, @Nonnull DatabricksModelVersion modelVersion, @Nonnull DatabricksEndpoint endpoint) throws DKUSecurityException, IOException, URISyntaxException {
        DatabricksHTTPClient client = connection.getClient(user, connectionTimeout, socketTimeout);
        DatabricksServedEntity servedEntity = new DatabricksServedEntity(modelVersion.name, modelVersion.version, endpoint.config.servedEntitySettings.workloadType, endpoint.config.servedEntitySettings.workloadSize, endpoint.config.servedEntitySettings.isScaleToZeroEnabled, endpoint.config.environmentVars);
        return client.createServingEndpoint(endpoint.name, servedEntity, endpoint.config.getTagsList());
    }

    public static DatabricksServingEndpointDetails updateEndpoint(@Nonnull AuthCtx user, @Nonnull DatabricksModelDeploymentConnection connection, int connectionTimeout, int socketTimeout, @Nonnull DatabricksModelVersion modelVersion, @Nonnull DatabricksEndpoint newEndpoint, @Nonnull DatabricksServingEndpointDetails previousEndpoint) throws DKUSecurityException, IOException, URISyntaxException {
        DatabricksHTTPClient client = connection.getClient(user, connectionTimeout, socketTimeout);
        DatabricksUpdateServingEndpointTagsRequest tagsRequest = DatabricksUtils.createUpdateTagsRequest(newEndpoint, previousEndpoint);
        DatabricksServedEntity servedEntity = new DatabricksServedEntity(modelVersion.name, modelVersion.version, newEndpoint.config.servedEntitySettings.workloadType, newEndpoint.config.servedEntitySettings.workloadSize, newEndpoint.config.servedEntitySettings.isScaleToZeroEnabled, newEndpoint.config.environmentVars);
        if (tagsRequest != null) {
            client.updateServingEndpointTags(newEndpoint.name, tagsRequest);
        }
        return client.updateServingEndpointConfig(newEndpoint.name, servedEntity);
    }

    @Nullable
    private static DatabricksUpdateServingEndpointTagsRequest createUpdateTagsRequest(@Nonnull DatabricksEndpoint newEndpoint, @Nonnull DatabricksServingEndpointDetails oldEndpoint) {
        List<SimpleKeyValue> newTags = newEndpoint.config.getTagsList();
        Set<String> newTagsKeys = newEndpoint.config.tags.keySet();
        List oldTags = oldEndpoint.tags;
        HashSet<SimpleKeyValue> addTags = new HashSet<SimpleKeyValue>(newTags);
        addTags.removeAll(oldTags);
        List<String> removeTags = oldTags.stream().map(kv -> kv.key).filter(k -> !newTagsKeys.contains(k)).collect(Collectors.toList());
        if (addTags.isEmpty() && removeTags.isEmpty()) {
            return null;
        }
        return new DatabricksUpdateServingEndpointTagsRequest(new ArrayList<SimpleKeyValue>(addTags), removeTags);
    }

    public static void deleteEndpoint(@Nonnull AuthCtx user, @Nonnull DatabricksModelDeploymentConnection connection, int connectionTimeout, int socketTimeout, @Nonnull String endpointName) throws DKUSecurityException, IOException, URISyntaxException {
        DatabricksHTTPClient client = connection.getClient(user, connectionTimeout, socketTimeout);
        client.deleteServingEndpoint(endpointName);
    }

    public static JsonObject queryEndpoint(@Nonnull AuthCtx user, @Nonnull String connectionName, int connectionTimeout, int socketTimeout, String endpointName, DatabricksInvokeServingEndpointRequest query) throws URISyntaxException, IOException, DKUSecurityException {
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnection(user, connectionName);
        DatabricksHTTPClient client = connection.getClient(user, connectionTimeout, socketTimeout);
        return client.invokeServingEndpoint(endpointName, query);
    }

    @Nullable
    public static DatabricksExperimentMetadataResponse getExperimentByName(@Nonnull AuthCtx user, @Nonnull DatabricksModelDeploymentConnection connection, int connectionTimeout, int socketTimeout, String experimentName) throws UnauthorizedException, URISyntaxException, IOException {
        DatabricksHTTPClient client = connection.getClient(user, connectionTimeout, socketTimeout);
        return client.getExperimentByName(experimentName);
    }

    public static void deleteExperimentRun(AuthCtx user, @Nonnull DatabricksModelDeploymentConnection connection, int connectionTimeout, int socketTimeout, String runId) throws UnauthorizedException, URISyntaxException, IOException {
        DatabricksHTTPClient client = connection.getClient(user, connectionTimeout, socketTimeout);
        client.deleteExperimentRun(runId);
    }

    public static List<DatabricksExperiment> listExperiments(@Nonnull AuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout) throws DKUSecurityException, IOException, URISyntaxException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)connectionName), (Object)"The connection name cannot be null.");
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnection(user, connectionName);
        DatabricksHTTPClient client = connection.getClient(user, connectTimeout, socketTimeout);
        return client.listExperiments();
    }

    public static SortedSet<DatabricksWorkspaceDirectoryObject> listExperimentLocationSuggestions(@Nonnull AuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout) throws DKUSecurityException, IOException, URISyntaxException {
        TransactionContext.assertNoAttachedTransaction();
        TreeSet<DatabricksWorkspaceDirectoryObject> suggestions = new TreeSet<DatabricksWorkspaceDirectoryObject>();
        String USERS_DIRECTORY_PATH = "/Users";
        DatabricksWorkspaceDirectoryObject usersDirectory = DatabricksUtils.getWorkspaceObject(user, connectionName, connectTimeout, socketTimeout, "/Users");
        if (usersDirectory != null) {
            List<DatabricksWorkspaceDirectoryObject> userDirectories = DatabricksUtils.listWorkspaceDirectories(user, connectionName, connectTimeout, socketTimeout, "/Users");
            suggestions.addAll(userDirectories);
        }
        String SHARED_DIRECTORY_PATH = "/Shared";
        DatabricksWorkspaceDirectoryObject sharedDirectory = DatabricksUtils.getWorkspaceObject(user, connectionName, connectTimeout, socketTimeout, "/Shared");
        if (sharedDirectory != null && sharedDirectory.objectType == DatabricksWorkspaceDirectoryObject.Type.DIRECTORY) {
            suggestions.add(sharedDirectory);
        }
        return suggestions;
    }

    public static DatabricksRegisteredModelVersion getRegisteredModelVersion(@Nonnull AuthCtx user, @Nonnull DatabricksModelDeploymentConnection connection, boolean useUnityCatalog, String modelName, String version, List<File> extraLogFiles) throws Exception {
        ModelVersionListingFutureThread futureThread = new ModelVersionListingFutureThread((DSSAuthCtx)user, connection.name, modelName, useUnityCatalog, extraLogFiles);
        futureThread.execute();
        return futureThread.getResult().stream().filter(mv -> version.equalsIgnoreCase(mv.version)).findFirst().orElse(null);
    }

    public static DatabricksRegisteredModelVersion getRegisteredModelVersionWhenReady(@Nonnull AuthCtx user, @Nonnull DatabricksModelDeploymentConnection connection, boolean useUnityCatalog, String modelName, String version, List<File> extraLogFiles) throws Exception {
        DatabricksRegisteredModelVersion modelVersion = DatabricksUtils.getRegisteredModelVersion(user, connection, useUnityCatalog, modelName, version, extraLogFiles);
        BackOff backOff = MODEL_REGISTRATION_BACKOFF_STRATEGY.build();
        while (DatabricksRegisteredModelVersion.Status.PENDING_REGISTRATION.equals((Object)modelVersion.status)) {
            long millis = backOff.nextBackOffMillis();
            if (millis <= 0L) {
                return modelVersion;
            }
            Thread.sleep(millis);
            modelVersion = DatabricksUtils.getRegisteredModelVersion(user, connection, useUnityCatalog, modelName, version, extraLogFiles);
        }
        return modelVersion;
    }

    public static void deleteModelVersion(@Nonnull AuthCtx user, @Nonnull DatabricksModelDeploymentConnection connection, int connectionTimeout, int socketTimeout, @Nonnull String modelName, @Nonnull String modelVersion, boolean isInUnityCatalog) throws UnauthorizedException, IOException, URISyntaxException {
        DatabricksHTTPClient client = connection.getClient(user, connectionTimeout, socketTimeout);
        if (isInUnityCatalog) {
            client.deleteModelVersionInUnityCatalog(modelName, modelVersion);
        } else {
            client.deleteModelVersionInRegistry(modelName, modelVersion);
        }
    }

    @Nonnull
    public static DatabricksServingEndpointDetails getEndpoint(@Nonnull AuthCtx user, @Nonnull String connectionName, @Nonnull String endpointName, int connectTimeout, int socketTimeout) throws DKUSecurityException, IOException, URISyntaxException {
        Preconditions.checkArgument((!StringUtils.isBlank((String)endpointName) ? 1 : 0) != 0, (Object)"Endpoint name cannot be empty.");
        DatabricksServingEndpointDetails endpoint = DatabricksUtils.getServingEndpointDetails(user, connectionName, endpointName, connectTimeout, socketTimeout);
        if (endpoint == null) {
            throw new IOException(String.format("Failed to GET '%s' endpoint from Databricks", endpointName));
        }
        return endpoint;
    }

    @Nullable
    public static DatabricksServingEndpointDetails getEndpointOrNull(@Nonnull AuthCtx user, @Nonnull String connectionName, @Nullable String endpointName, int connectTimeout, int socketTimeout) throws IOException, URISyntaxException, DKUSecurityException {
        if (StringUtils.isEmpty((String)endpointName)) {
            return null;
        }
        return DatabricksUtils.getServingEndpointDetails(user, connectionName, endpointName, connectTimeout, socketTimeout);
    }

    @Nullable
    public static DatabricksServingEndpointDetails awaitEndpointCreationResult_NT(@Nonnull AuthCtx user, @Nonnull String connectionName, @Nonnull String endpointName, int connectTimeout, int socketTimeout) throws IOException, URISyntaxException, DKUSecurityException, InterruptedException {
        long interval;
        DatabricksServingEndpointDetails details = DatabricksUtils.getServingEndpointDetails(user, connectionName, endpointName, connectTimeout, socketTimeout);
        if (details == null) {
            return null;
        }
        BackOff backOffStrategy = SERVING_ENDPOINT_READINESS_BACKOFF_STRATEGY.build();
        while (details != null && details.state.configUpdate == DatabricksServingEndpointState.ConfigUpdate.IN_PROGRESS && (interval = backOffStrategy.nextBackOffMillis()) > 0L) {
            Thread.sleep(interval);
            details = DatabricksUtils.getServingEndpointDetails(user, connectionName, endpointName, connectTimeout, socketTimeout);
        }
        return details;
    }

    @Nullable
    private static DatabricksServingEndpointDetails getServingEndpointDetails(@Nonnull AuthCtx user, @Nonnull String connectionName, @Nonnull String endpointName, int connectTimeout, int socketTimeout) throws IOException, DKUSecurityException, URISyntaxException {
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnection(user, connectionName);
        DatabricksHTTPClient client = connection.getClient(user, connectTimeout, socketTimeout);
        DatabricksServingEndpointDetails endpoint = client.getServingEndpointDetails(endpointName);
        if (endpoint == null) {
            logger.debugV("Failed to retrieve a Databricks endpoint '%s'", new Object[]{endpointName});
        }
        return endpoint;
    }

    public static FutureResponse<List<ExternalInfraEndpoint>> startListEndpoints_NT(@Nonnull DSSAuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout) throws Exception {
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        EndpointsListingFutureThread endpointsListingFutureThread = new EndpointsListingFutureThread(user, connectionName, connectTimeout, socketTimeout);
        return futureService.runFuture(endpointsListingFutureThread, 0L, new TypeToken<FutureResponse<List<ExternalInfraEndpoint>>>(){});
    }

    public static FutureResponse<List<DatabricksExperiment>> startListExperiments_NT(@Nonnull DSSAuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout) throws Exception {
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        ExperimentsListingFutureThread experimentsListingFutureThread = new ExperimentsListingFutureThread(user, connectionName, connectTimeout, socketTimeout);
        return futureService.runFuture(experimentsListingFutureThread, 0L, new TypeToken<FutureResponse<List<DatabricksExperiment>>>(){});
    }

    public static FutureResponse<SortedSet<DatabricksWorkspaceDirectoryObject>> startListExperimentLocationSuggestions_NT(@Nonnull DSSAuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout) throws Exception {
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        ExperimentsLocationSuggestionsListingFutureThread thread = new ExperimentsLocationSuggestionsListingFutureThread(user, connectionName, connectTimeout, socketTimeout);
        return futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<SortedSet<DatabricksWorkspaceDirectoryObject>>>(){});
    }

    public static FutureResponse<List<DatabricksRegisteredModelVersion>> startListRegisteredModelVersions_NT(DSSAuthCtx user, @Nonnull String connectionName, String modelName, boolean useUnityCatalog, List<File> extraLogFiles) throws Exception {
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        ModelVersionListingFutureThread mvlft = new ModelVersionListingFutureThread(user, connectionName, modelName, useUnityCatalog, extraLogFiles);
        return futureService.runFuture(mvlft, 0L, new TypeToken<FutureResponse<List<DatabricksRegisteredModelVersion>>>(){});
    }

    public static FutureResponse<List<DatabricksRegisteredModel>> startListRegisteredModels_NT(DSSAuthCtx authCtx, @Nonnull DatabricksModelDeploymentConnection connection, boolean useUnityCatalog, List<File> extraLogFiles) throws Exception {
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        ModelListingFutureThread mlft = new ModelListingFutureThread(authCtx, connection, useUnityCatalog, extraLogFiles);
        return futureService.runFuture(mlft, 0L, new TypeToken<FutureResponse<List<DatabricksRegisteredModel>>>(){});
    }

    public static DatabricksModelDeploymentConnection retrieveMandatoryDatabricksConnection(AuthCtx user, @Nonnull String connectionName) throws IOException, DKUSecurityException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)connectionName), (Object)"The connection name cannot be empty.");
        DatabricksModelDeploymentConnection connection = (DatabricksModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(user, connectionName);
        if (connection == null) {
            throw new IllegalArgumentException(String.format("The connection %s is not found", connectionName));
        }
        return connection;
    }

    @Nonnull
    public static DatabricksModelDeploymentConnection retrieveMandatoryDatabricksConnectionAndCheckDetailsReadable(AuthCtx user, @Nonnull String connectionName) throws IOException, DKUSecurityException {
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnection(user, connectionName);
        connection.checkDetailsReadableBy(user);
        return connection;
    }

    public static File downloadModelFromDatabricks(@Nonnull DSSAuthCtx authCtx, @Nonnull DatabricksModelDeploymentConnection connection, boolean useUnityCatalog, @Nonnull String modelName, @Nonnull String modelVersion, @Nonnull File targetDirectory, List<File> extraLogFiles) throws Exception {
        if (!targetDirectory.exists() || !targetDirectory.isDirectory()) {
            throw new IOException(targetDirectory.getAbsolutePath() + " does not exist or is not a directory");
        }
        ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forExternalDeploymentInfraOperation((AuthCtx)authCtx, (String)connection.name);
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
        DatabricksUtilsKernelCachingService databricksUtilsKernelCachingService = (DatabricksUtilsKernelCachingService)SpringUtils.getBean(DatabricksUtilsKernelCachingService.class);
        CodeBasedRecipeDatasetInfoHelper.ConnectionLocationInfo connectionInfo = new CodeBasedRecipeDatasetInfoHelper().getConnectionInfo_NT((AuthCtx)authCtx, connection, null);
        try (DatabricksUtilsRunner mlflowUtilsRunner = databricksUtilsKernelCachingService.getCachedMLflowUtilsRunner(authCtx, connection, extraLogFiles);){
            File file = mlflowUtilsRunner.downloadModelFromDatabricks(connectionInfo, useUnityCatalog, modelName, modelVersion, targetDirectory);
            return file;
        }
    }

    public static DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse registerModelInDatabricks(@Nonnull DSSAuthCtx authCtx, @Nonnull File modelDirectory, @Nonnull DatabricksModelDeploymentConnection connection, boolean useUnityCatalog, @Nonnull String modelName, @Nonnull String experimentName, @Nullable List<SchemaColumn> columns, @Nonnull String targetName, List<File> extraLogFiles) throws Exception {
        CodeBasedRecipeDatasetInfoHelper.ConnectionLocationInfo connectionInfo = new CodeBasedRecipeDatasetInfoHelper().getConnectionInfo_NT((AuthCtx)authCtx, connection, null);
        if (null == connectionInfo.params) {
            throw new UnauthorizedException("Access to the configured connection is not authorized.", "denied");
        }
        ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forExternalDeploymentInfraOperation((AuthCtx)authCtx, (String)connection.name);
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
        DatabricksUtilsKernelCachingService databricksUtilsKernelCachingService = (DatabricksUtilsKernelCachingService)SpringUtils.getBean(DatabricksUtilsKernelCachingService.class);
        try (DatabricksUtilsRunner mlflowUtilsRunner = databricksUtilsKernelCachingService.getCachedMLflowUtilsRunner(authCtx, connection, extraLogFiles);){
            DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse requestModelRegistrationResponse = mlflowUtilsRunner.registerModelInDatabricks(modelDirectory, connectionInfo, useUnityCatalog, modelName, experimentName, columns, targetName);
            return requestModelRegistrationResponse;
        }
    }

    public static Pair<DeploymentHealth, InfoMessage.InfoMessages> getEndpointHealth(DatabricksServingEndpointState databricksServingEndpointState) {
        DeploymentHealth deploymentHealth;
        InfoMessage.InfoMessages endpointHealthMessages = new InfoMessage.InfoMessages();
        if (DatabricksServingEndpointState.Readiness.NOT_READY.equals((Object)databricksServingEndpointState.ready)) {
            deploymentHealth = DeploymentHealth.UNHEALTHY;
            endpointHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_NOT_READY_STATE, "Config update state : %s", new Object[]{databricksServingEndpointState.configUpdate});
        } else if (DatabricksServingEndpointState.ConfigUpdate.UPDATE_FAILED.equals((Object)databricksServingEndpointState.configUpdate)) {
            deploymentHealth = DeploymentHealth.WARNING;
            endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_CONFIG_UPDATE_FAILURE, "");
        } else if (DatabricksServingEndpointState.ConfigUpdate.IN_PROGRESS.equals((Object)databricksServingEndpointState.configUpdate)) {
            deploymentHealth = DeploymentHealth.UNKNOWN;
            endpointHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_CONFIG_UPDATE_IN_PROGRESS, "");
        } else if (DatabricksServingEndpointState.ConfigUpdate.NOT_UPDATING.equals((Object)databricksServingEndpointState.configUpdate) && DatabricksServingEndpointState.Readiness.READY.equals((Object)databricksServingEndpointState.ready)) {
            deploymentHealth = DeploymentHealth.HEALTHY;
            endpointHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_HEALTHY_STATE, "");
        } else {
            deploymentHealth = DeploymentHealth.UNKNOWN;
            endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_UNKNOWN_STATE, "");
        }
        return new Pair((Object)deploymentHealth, (Object)endpointHealthMessages);
    }

    public static List<String> getWorkloadTypes() {
        return Arrays.stream(DatabricksWorkloadType.values()).map(Enum::toString).collect(Collectors.toList());
    }

    public static List<String> getWorkloadSizeTypes() {
        return Arrays.stream(DatabricksWorkloadSize.values()).map(v -> v.value).collect(Collectors.toList());
    }

    public static Optional<DatabricksServedEntity> getServedEntity(@Nullable DatabricksModelVersion modelVersion, @Nullable DatabricksServingEndpointDetailedConfig endpointConfig) {
        if (modelVersion == null || endpointConfig == null) {
            return Optional.empty();
        }
        return endpointConfig.servedEntities.stream().filter(entity -> entity.entityName.equals(modelVersion.name) && entity.entityVersion.equals(modelVersion.version)).findFirst();
    }

    private static String getEndpointResourceLink(String endpointName, String databricksHostBaseUrl) {
        return String.format("%s/ml/endpoints/%s", databricksHostBaseUrl, endpointName);
    }

    static {
        int registrationBackOffTimeoutS = DKUApp.getParams().getIntParam(DEFAULT_MODEL_REGISTRATION_TIMEOUT_CONFIG_KEY, Integer.valueOf(300));
        MODEL_REGISTRATION_BACKOFF_STRATEGY = BackOffStrategy.expBackOff((int)2000, (int)15000, (double)1.015, (int)(registrationBackOffTimeoutS * 1000));
        int endpointReadinessBackOffMinWaitS = DKUApp.getParams().getIntParam(DEFAULT_ENDPOINT_READINESS_MIN_WAIT_CONFIG_KEY, Integer.valueOf(30));
        int endpointReadinessBackOffMaxWaitS = DKUApp.getParams().getIntParam(DEFAULT_ENDPOINT_READINESS_MAX_WAIT_CONFIG_KEY, Integer.valueOf(60));
        int endpointReadinessBackOffTimeoutS = DKUApp.getParams().getIntParam(DEFAULT_ENDPOINT_READINESS_TIMEOUT_CONFIG_KEY, Integer.valueOf(1800));
        SERVING_ENDPOINT_READINESS_BACKOFF_STRATEGY = BackOffStrategy.expBackOff((int)(endpointReadinessBackOffMinWaitS * 1000), (int)(endpointReadinessBackOffMaxWaitS * 1000), (double)1.015, (int)(endpointReadinessBackOffTimeoutS * 1000));
        logger = DKULogger.getLogger((String)"dku.deployer.deployment.databricks.utils");
    }

    public static class ModelVersionListingFutureThread
    extends FutureThread<List<DatabricksRegisteredModelVersion>> {
        @Nonnull
        private final String connectionName;
        private final boolean useUnityCatalog;
        private final String modelName;
        private final DSSAuthCtx user;
        private final List<File> extraLogFiles;
        private List<DatabricksRegisteredModelVersion> result;
        private final FuturePayload futurePayload = new FuturePayload();

        public ModelVersionListingFutureThread(DSSAuthCtx user, @Nonnull String connectionName, String modelName, boolean useUnityCatalog, List<File> extraLogFiles) {
            super(user);
            this.user = user;
            this.connectionName = connectionName;
            this.modelName = modelName;
            this.useUnityCatalog = useUnityCatalog;
            this.extraLogFiles = extraLogFiles;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public List<DatabricksRegisteredModelVersion> getResult() {
            return this.result;
        }

        public void execute() throws Exception {
            ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forExternalDeploymentInfraOperation((AuthCtx)this.user, (String)this.connectionName);
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
            DatabricksUtilsKernelCachingService databricksUtilsKernelCachingService = (DatabricksUtilsKernelCachingService)SpringUtils.getBean(DatabricksUtilsKernelCachingService.class);
            DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnectionAndCheckDetailsReadable(this.user, this.connectionName);
            CodeBasedRecipeDatasetInfoHelper.ConnectionLocationInfo connectionInfo = new CodeBasedRecipeDatasetInfoHelper().getConnectionInfo_NT((AuthCtx)this.user, connection, null);
            try (DatabricksUtilsRunner databricksUtilsRunner = databricksUtilsKernelCachingService.getCachedMLflowUtilsRunner(this.user, connection, this.extraLogFiles);){
                this.result = databricksUtilsRunner.listRegisteredModelVersions(connectionInfo, this.modelName, this.useUnityCatalog);
            }
        }
    }

    public static class EndpointsListingFutureThread
    extends FutureThread<List<ExternalInfraEndpoint>> {
        @Nonnull
        private final DSSAuthCtx user;
        @Nonnull
        private final String connectionName;
        private final int connectTimeout;
        private final int socketTimeout;
        private List<ExternalInfraEndpoint> result;
        private final FuturePayload futurePayload = new FuturePayload();

        public EndpointsListingFutureThread(@Nonnull DSSAuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout) {
            super(user);
            this.user = user;
            this.connectionName = connectionName;
            this.connectTimeout = connectTimeout;
            this.socketTimeout = socketTimeout;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public List<ExternalInfraEndpoint> getResult() {
            return this.result;
        }

        public void execute() throws Exception {
            this.result = DatabricksUtils.listExternalEndpoints(this.user, this.connectionName, this.connectTimeout, this.socketTimeout);
        }
    }

    public static class ExperimentsListingFutureThread
    extends SimpleFutureThread<List<DatabricksExperiment>> {
        @Nonnull
        private final String connectionName;
        private final int connectTimeout;
        private final int socketTimeout;

        public ExperimentsListingFutureThread(@Nonnull DSSAuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout) {
            super((AuthCtx)user);
            this.connectionName = connectionName;
            this.connectTimeout = connectTimeout;
            this.socketTimeout = socketTimeout;
        }

        public FuturePayload getPayload() {
            FuturePayload futurePayload = new FuturePayload();
            futurePayload.action = "list_experiments";
            futurePayload.targets.add(new FuturePayload.FuturePayloadTarget(this.connectionName, "CONNECTION"));
            futurePayload.displayName = "Listing experiments on Databricks connection " + this.connectionName;
            return futurePayload;
        }

        @Override
        public double getDangerosity() {
            return 0.0;
        }

        @Override
        public List<DatabricksExperiment> compute() throws Exception {
            return DatabricksUtils.listExperiments(this.owner, this.connectionName, this.connectTimeout, this.socketTimeout);
        }
    }

    public static class ExperimentsLocationSuggestionsListingFutureThread
    extends SimpleFutureThread<SortedSet<DatabricksWorkspaceDirectoryObject>> {
        @Nonnull
        private final String connectionName;
        private final int connectTimeout;
        private final int socketTimeout;

        public ExperimentsLocationSuggestionsListingFutureThread(@Nonnull DSSAuthCtx user, @Nonnull String connectionName, int connectTimeout, int socketTimeout) {
            super((AuthCtx)user);
            this.connectionName = connectionName;
            this.connectTimeout = connectTimeout;
            this.socketTimeout = socketTimeout;
        }

        public FuturePayload getPayload() {
            FuturePayload futurePayload = new FuturePayload();
            futurePayload.action = "list_experiment_location_suggestions";
            futurePayload.targets.add(new FuturePayload.FuturePayloadTarget(this.connectionName, "CONNECTION"));
            futurePayload.displayName = "Listing experiment location suggestions on Databricks connection " + this.connectionName;
            return futurePayload;
        }

        @Override
        public double getDangerosity() {
            return 0.0;
        }

        @Override
        public SortedSet<DatabricksWorkspaceDirectoryObject> compute() throws Exception {
            return DatabricksUtils.listExperimentLocationSuggestions(this.owner, this.connectionName, this.connectTimeout, this.socketTimeout);
        }
    }

    public static class ModelListingFutureThread
    extends FutureThread<List<DatabricksRegisteredModel>> {
        @Nonnull
        private final DatabricksModelDeploymentConnection connection;
        private final boolean useUnityCatalog;
        private final DSSAuthCtx user;
        private final List<File> extraLogFiles;
        private List<DatabricksRegisteredModel> result;
        private final FuturePayload futurePayload = new FuturePayload();

        public ModelListingFutureThread(DSSAuthCtx user, @Nonnull DatabricksModelDeploymentConnection connection, boolean useUnityCatalog, List<File> extraLogFiles) {
            super(user);
            this.user = user;
            this.connection = connection;
            this.useUnityCatalog = useUnityCatalog;
            this.extraLogFiles = extraLogFiles;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public List<DatabricksRegisteredModel> getResult() {
            return this.result;
        }

        public void execute() throws Exception {
            ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forExternalDeploymentInfraOperation((AuthCtx)this.user, (String)this.connection.name);
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
            DatabricksUtilsKernelCachingService databricksUtilsKernelCachingService = (DatabricksUtilsKernelCachingService)SpringUtils.getBean(DatabricksUtilsKernelCachingService.class);
            CodeBasedRecipeDatasetInfoHelper.ConnectionLocationInfo connectionInfo = new CodeBasedRecipeDatasetInfoHelper().getConnectionInfo_NT((AuthCtx)this.user, this.connection, null);
            try (DatabricksUtilsRunner mlflowUtilsRunner = databricksUtilsKernelCachingService.getCachedMLflowUtilsRunner(this.user, this.connection, this.extraLogFiles);){
                this.result = mlflowUtilsRunner.listRegisteredModels(connectionInfo, this.useUnityCatalog);
            }
        }
    }
}

