/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.excel.model;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.formats.excel.model.ExcelWorkbook;
import com.dataiku.dip.formats.excel.xssfb.XSSFBCellStyle;
import com.dataiku.dip.formats.excel.xssfb.XSSFBSheetHandler;
import com.dataiku.dip.formats.excel.xssfb.XSSFBStylesTable;
import com.dataiku.dip.formats.excel.xssfb.XSSFBWorkbookReader;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.com.google.common.math.DoubleMath;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.OPCPackage;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.PackagePart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.DataFormatter;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.DateUtil;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.binary.XSSFBRelation;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.binary.XSSFBSharedStringsTable;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.eventusermodel.XSSFBReader;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.model.SharedStrings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

public class ExcelWorkbookBinary
implements ExcelWorkbook {
    private static final ZoneId UTC_ZONE_ID = TimeZone.getTimeZone(ZoneOffset.UTC).toZoneId();
    private final XSSFBWorkbookReader workbookReader;
    private final XSSFBStylesTable stylesTable;
    private final XSSFBSharedStringsTable stringsTable;
    private final DataFormatter dataFormatter = new DataFormatter();
    private List<String> sheetNames;
    private OPCPackage pkg;
    private File tmpFile;
    private static final Logger logger = Logger.getLogger((String)"dku.format.excel");

    public ExcelWorkbookBinary(OPCPackage pkg, File tmpFile) throws IOException, OpenXML4JException, SAXException {
        this.pkg = pkg;
        this.tmpFile = tmpFile;
        this.workbookReader = new XSSFBWorkbookReader(pkg);
        this.stringsTable = new XSSFBSharedStringsTable(pkg);
        this.stylesTable = this.getXSSFBStylesTable(pkg);
    }

    @Override
    public int getNumberOfSheets() {
        return this.getSheetNames().size();
    }

    @Override
    public ExcelWorkbook.Sheet getSheetAt(int index) {
        try {
            return this.readSheet(index);
        }
        catch (OpenXML4JException | IOException e) {
            throw new RuntimeException("Unable to read sheet at index " + index, e);
        }
    }

    @Override
    public int getSheetIndex(String sheetName) {
        return this.getSheetNames().indexOf(sheetName);
    }

    @Override
    public ExcelWorkbook.Sheet getSheet(String sheetName) {
        int sheetIndex = this.getSheetIndex(sheetName);
        if (sheetIndex < 0) {
            throw new IllegalArgumentException("Unknown sheet: " + sheetName);
        }
        return this.getSheetAt(sheetIndex);
    }

    @Override
    public List<String> listSheetNames() {
        return Collections.unmodifiableList(this.getSheetNames());
    }

    @Override
    public void close() throws IOException {
        if (this.pkg != null) {
            this.pkg.revert();
            this.pkg = null;
        }
        if (this.tmpFile != null) {
            ExcelWorkbookBinary.deleteTemporaryFile(this.tmpFile);
            this.tmpFile = null;
        }
    }

    private List<String> readSheetNames() throws IOException, SAXException, OpenXML4JException {
        XSSFBReader.SheetIterator it = this.workbookReader.getSheetsIterator();
        ArrayList<String> sheetNames = new ArrayList<String>();
        while (it.hasNext()) {
            it.next();
            sheetNames.add(it.getSheetName());
        }
        return sheetNames;
    }

    private SheetImpl readSheet(int index) throws IOException, OpenXML4JException {
        XSSFBReader.SheetIterator it = this.workbookReader.getSheetsIterator();
        int currIndex = -1;
        while (it.hasNext()) {
            InputStream inputStream = it.next();
            if (++currIndex != index) continue;
            return new SheetImpl(it.getSheetName(), inputStream);
        }
        return null;
    }

    private synchronized List<String> getSheetNames() {
        if (this.sheetNames == null) {
            try {
                this.sheetNames = this.readSheetNames();
            }
            catch (OpenXML4JException | IOException | SAXException e) {
                throw new RuntimeException("Unable to list sheets from Excel file", e);
            }
        }
        return this.sheetNames;
    }

    private XSSFBStylesTable getXSSFBStylesTable(OPCPackage pkg) throws IOException {
        ArrayList parts = pkg.getPartsByContentType(XSSFBRelation.STYLES_BINARY.getContentType());
        return parts.size() == 0 ? null : new XSSFBStylesTable(((PackagePart)parts.get(0)).getInputStream());
    }

    @Override
    @NotNull
    public Iterator<ExcelWorkbook.Sheet> iterator() {
        XSSFBReader.SheetIterator it;
        try {
            it = this.workbookReader.getSheetsIterator();
        }
        catch (InvalidFormatException | IOException | RuntimeException e) {
            throw new RuntimeException("Unable to read Excel file", e);
        }
        return new Iterator<ExcelWorkbook.Sheet>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public ExcelWorkbook.Sheet next() {
                InputStream inputStream = it.next();
                String sheetName = it.getSheetName();
                return new SheetImpl(sheetName, inputStream);
            }
        };
    }

    private long getTimestamp(double d, ZoneId timezoneId) {
        return DateUtil.getLocalDateTime((double)d, (boolean)this.workbookReader.use1904Dates).atZone(timezoneId).toInstant().toEpochMilli();
    }

    private static boolean isValidExcelDate(double value) {
        return value > -4.9E-324;
    }

    private static void deleteTemporaryFile(File tmpFile) {
        try {
            DKUFileUtils.forceDelete((File)tmpFile);
        }
        catch (IOException e) {
            logger.error((Object)("Unable to delete temporary file: " + tmpFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private class SheetImpl
    implements ExcelWorkbook.Sheet {
        private final String sheetName;
        private final InputStream inputStream;

        public SheetImpl(String sheetName, InputStream inputStream) {
            this.sheetName = sheetName;
            this.inputStream = inputStream;
        }

        @Override
        public String getSheetName() {
            return this.sheetName;
        }

        @Override
        @NotNull
        public Iterator<ExcelWorkbook.Row> iterator() {
            return new RowIterator(this.inputStream);
        }
    }

    private class RowContentHandler
    implements XSSFBSheetHandler.XSSFBSheetContentHandler {
        public RowImpl row;

        private RowContentHandler() {
        }

        @Override
        public void startRow(int rowNum) {
            this.row = new RowImpl(rowNum);
        }

        @Override
        public void cell(int rowIndex, int columnIndex, CellType cellType, Object value, XSSFBCellStyle cellStyle, String formattedValue) {
            if (this.row == null) {
                throw new IllegalStateException("row has not been created yet");
            }
            this.row.add(new CellImpl(rowIndex, columnIndex, cellType, value, cellStyle, formattedValue));
        }
    }

    private class RowIterator
    implements Iterator<ExcelWorkbook.Row> {
        private final RowContentHandler rowHandler;
        private final XSSFBSheetHandler sheetHandler;
        private boolean eof;

        public RowIterator(InputStream inputStream) {
            this.rowHandler = new RowContentHandler();
            this.sheetHandler = new XSSFBSheetHandler(inputStream, ExcelWorkbookBinary.this.stylesTable, (SharedStrings)ExcelWorkbookBinary.this.stringsTable, this.rowHandler, ExcelWorkbookBinary.this.dataFormatter, ExcelWorkbookBinary.this.workbookReader.use1904Dates);
            try {
                this.eof = this.sheetHandler.parse();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read Excel row.", e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.rowHandler.row != null;
        }

        @Override
        public ExcelWorkbook.Row next() {
            if (this.rowHandler.row == null) {
                throw new NoSuchElementException("No more rows in Excel sheet");
            }
            RowImpl currentRow = this.rowHandler.row;
            try {
                this.eof = this.sheetHandler.parse();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read Excel row.", e);
            }
            if (this.eof) {
                this.rowHandler.row = null;
            }
            return currentRow;
        }
    }

    private class CellImpl
    implements ExcelWorkbook.Cell {
        private final int rowIndex;
        private final int columnIndex;
        private final CellType cellType;
        private final Object value;
        private final XSSFBCellStyle cellStyle;
        private final String formattedValue;

        private CellImpl(int rowIndex, int columnIndex, CellType cellType, Object value, XSSFBCellStyle cellStyle, String formattedValue) {
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
            this.cellType = cellType;
            this.value = value;
            this.cellStyle = cellStyle;
            this.formattedValue = formattedValue;
        }

        @Override
        public int getRowIndex() {
            return this.rowIndex;
        }

        @Override
        public int getColumnIndex() {
            return this.columnIndex;
        }

        @Override
        public String getFormattedValueAsDateISO(ZoneId timezoneId) {
            if (this.cellType == CellType.NUMERIC && this.value != null) {
                long ts = ExcelWorkbookBinary.this.getTimestamp((Double)this.value, timezoneId);
                return DKUtils.isoFormatReadableByDateFormat((long)ts);
            }
            return null;
        }

        @Override
        public boolean cellContainsDate() {
            if (this.cellType == CellType.NUMERIC && this.cellStyle != null) {
                double d = (Double)this.value;
                return ExcelWorkbookBinary.isValidExcelDate(d) && DateUtil.isADateFormat((int)this.cellStyle.getDataFormat(), (String)this.cellStyle.getDataFormatString());
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            switch (this.cellType) {
                case BLANK: 
                case ERROR: {
                    return true;
                }
                case BOOLEAN: 
                case NUMERIC: {
                    return false;
                }
                case STRING: {
                    return StringUtils.isEmpty((CharSequence)this.formattedValue);
                }
            }
            logger.info((Object)("Unknown Excel cell type: " + String.valueOf(this.cellType)));
            return true;
        }

        @Override
        public String getFormattedValue(@Nullable Type dssType, ZoneId timezoneId, boolean preserveNumberFormatting) {
            switch (this.cellType) {
                case BOOLEAN: {
                    return String.valueOf((Boolean)this.value);
                }
                case NUMERIC: {
                    if (preserveNumberFormatting) {
                        return this.formattedValue;
                    }
                    double d = (Double)this.value;
                    if (this.cellContainsDate()) {
                        if (dssType != null && dssType.isTemporal()) {
                            if (dssType == Type.DATE) {
                                return DKUtils.isoFormatReadableByDateFormat((long)ExcelWorkbookBinary.this.getTimestamp(d, timezoneId));
                            }
                            if (dssType == Type.DATEONLY) {
                                return DKUtils.isoFormatReadableByDateFormat((long)ExcelWorkbookBinary.this.getTimestamp(d, UTC_ZONE_ID)).substring(0, 10);
                            }
                            return DKUtils.isoFormatReadableByDatetimeNoTzFormat((long)ExcelWorkbookBinary.this.getTimestamp(d, UTC_ZONE_ID));
                        }
                        return this.formattedValue;
                    }
                    if (DoubleMath.isMathematicalInteger((double)d) && d >= -9.223372036854776E18 && d < 9.223372036854776E18) {
                        return String.valueOf(Math.round(d));
                    }
                    return String.valueOf(d);
                }
                case STRING: {
                    return StringUtils.isEmpty((CharSequence)this.formattedValue) ? null : this.formattedValue;
                }
                case BLANK: 
                case ERROR: {
                    return null;
                }
            }
            logger.info((Object)("Unexpected Excel cell type: " + String.valueOf(this.cellType)));
            return null;
        }
    }

    private static class RowImpl
    implements ExcelWorkbook.Row {
        private final int rowNum;
        private final List<ExcelWorkbook.Cell> cells = new ArrayList<ExcelWorkbook.Cell>();

        public RowImpl(int rowNum) {
            this.rowNum = rowNum;
        }

        @Override
        public int getRowNum() {
            return this.rowNum;
        }

        public void add(ExcelWorkbook.Cell cell) {
            this.cells.add(cell);
        }

        @Override
        @NotNull
        public Iterator<ExcelWorkbook.Cell> iterator() {
            return this.cells.iterator();
        }
    }
}

