/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.html;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.html.HtmlOutputFormatter;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.warnings.WarningsContext;

public class HtmlFormat {
    public static final FormatMeta<FakeExtractor, Config> META = new FormatMeta<FakeExtractor, Config>(){

        @Override
        public String getType() {
            return "html";
        }

        @Override
        public String getLabel() {
            return "HTML";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.TEXT_POSITION_BASED_VARIABLE_COLUMNS;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[0];
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return Config.class;
        }

        @Override
        public FakeExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            throw new IllegalStateException("HTML format can only be used as an output formatter");
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            Config c2 = (Config)params;
            return new HtmlOutputFormatter(c2.border, c2.cssClasses, c2.header, c2.indentString, c2.nullString, c2.doNotEscapeHtml);
        }
    };

    public static class FakeExtractor
    implements FormatExtractor {
        @Override
        public void setLimit(ExtractionLimit limit) {
        }

        @Override
        public boolean canSetSchemaForExtractor() {
            return false;
        }

        @Override
        public void setSchema(Schema schema, boolean allowExtraColumns) {
        }

        @Override
        public void setProgressListener(InputSplitProgressListener listener) {
        }

        @Override
        public void setWarningsContext(WarningsContext warnContext) {
        }

        @Override
        public boolean run(StreamsInputSplit in, ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
            return false;
        }
    }

    public static class Config
    implements FormatParams {
        public boolean applyColoring = false;
        public int border;
        public String cssClasses;
        public boolean header;
        public String indentString = "";
        public String nullString = "";
        public boolean doNotEscapeHtml;

        @Override
        public boolean getApplyColoring() {
            return this.applyColoring;
        }
    }
}

