/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.futures.IGarbageCollectionEventMonitor;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.Lists;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class GarbageCollectionMonitor
implements NotificationListener {
    private final List<IGarbageCollectionEventMonitor> monitors = Lists.newArrayList();
    private MemoryMXBean memoryBean;
    private final double damping = 0.3;
    private double amortizedGcDuration = 0.0;
    private double amortizedMemoryUsage = 0.0;
    private double amortizedGcEfficiency = 0.0;
    private int collectionCount = 0;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.gc.monitor");

    public GarbageCollectionMonitor() {
        try {
            Class<?> monitorClass = Class.forName("com.dataiku.dip.futures.HotspotGarbageCollectionEventMonitor");
            this.monitors.add((IGarbageCollectionEventMonitor)monitorClass.newInstance());
        }
        catch (Throwable ex) {
            logger.warn((Object)("The JVM is not a hotspot jvm. Could not instantiate the GC monitor, only partial GC info will be available to DSS : " + ExceptionUtils.getMessageWithCauses((Throwable)ex)));
        }
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcbean : gcbeans) {
            if (!(gcbean instanceof NotificationEmitter)) continue;
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcbean);
            emitter.addNotificationListener(this, null, null);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        try {
            for (IGarbageCollectionEventMonitor monitor : this.monitors) {
                GarbageCollectionEvent data = monitor.extractData(notification, handback);
                if (data == null) continue;
                this.record(data);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failure while inspecting a garbage collection notification.", (Throwable)ex);
        }
    }

    private synchronized void record(GarbageCollectionEvent data) {
        MemoryUsage heapMemoryUsage = this.memoryBean.getHeapMemoryUsage();
        long maxMem = heapMemoryUsage.getMax();
        long usedMem = heapMemoryUsage.getUsed();
        double memoryUsage = (double)usedMem / (double)maxMem;
        double gcEfficiency = 1.0 - (double)data.usedAfter / (double)data.usedBefore;
        double gcDuration = data.duration;
        ++this.collectionCount;
        this.amortizedMemoryUsage = 0.7 * memoryUsage + 0.3 * this.amortizedMemoryUsage;
        this.amortizedGcEfficiency = 0.7 * gcEfficiency + 0.3 * this.amortizedGcEfficiency;
        this.amortizedGcDuration = 0.7 * gcDuration + 0.3 * this.amortizedGcDuration;
    }

    public synchronized MemoryState getCurrentState() {
        MemoryState state = new MemoryState();
        MemoryUsage heapMemoryUsage = this.memoryBean.getHeapMemoryUsage();
        state.usedMem = heapMemoryUsage.getUsed();
        state.committedMem = heapMemoryUsage.getCommitted();
        state.maxMem = heapMemoryUsage.getMax();
        double memoryUsage = (double)state.usedMem / (double)state.maxMem;
        state.gcDuration = this.amortizedGcDuration;
        state.memoryUsage = memoryUsage;
        state.gcEfficiency = this.amortizedGcEfficiency;
        state.collectionCount = this.collectionCount;
        this.collectionCount = 0;
        return state;
    }

    public static class GarbageCollectionEvent {
        public long duration;
        public long usedBefore;
        public long usedAfter;
    }

    public static class MemoryState {
        public long usedMem;
        public long committedMem;
        public long maxMem;
        public double memoryUsage;
        public int collectionCount;
        public double gcDuration;
        public double gcEfficiency;
    }
}

