/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.gh;

import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.utils.DKULogger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class GovernIntegrationQueueHandler
implements Runnable {
    final BlockingQueue<BackendEvent> queue = new LinkedBlockingQueue<BackendEvent>();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.govern-integration.queue");

    public abstract void handleQueueEvent(BackendEvent var1);

    @Override
    public void run() {
        Thread.currentThread().setName("govern-integration-queue-handler");
        try {
            while (!Thread.currentThread().isInterrupted()) {
                BackendEvent event = this.queue.take();
                DKULogger.startCurrentCall();
                logger.debugV("Govern integration start handling event type=%s", new Object[]{event.getName()});
                try {
                    this.handleQueueEvent(event);
                    logger.debugV("Govern integration done handling event type=%s", new Object[]{event.getName()});
                }
                catch (Exception e) {
                    logger.error((Object)("Govern integration handling event failed during " + event.getName() + " event"), (Throwable)e);
                }
                DKULogger.endCurrentCall();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Govern integration thread interrupted", (Throwable)e);
        }
    }
}

