/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive.shims;

import com.dataiku.dip.hive.HiveSerdeShims;
import com.dataiku.dip.hive.shims.HiveDefaultDSSDateObjectInspector;
import com.dataiku.dip.hive.shims.HiveDefaultDSSTimestampObjectInspector;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;

public class HiveDefaultSerdeShims
implements HiveSerdeShims {
    private static final DateTimeFormatter isoDateFormatter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter dateOnlyFormatter = ISODateTimeFormat.date().withZone(DateTimeZone.getDefault());

    @Override
    public DSSBaseInspector getTimestampInspector() {
        return new HiveDefaultDSSTimestampObjectInspector();
    }

    @Override
    public DSSBaseInspector getDateInspector() {
        return new HiveDefaultDSSDateObjectInspector();
    }

    @Override
    public String readTimestamp(PrimitiveObjectInspector oi, Object o) {
        Timestamp ts = ((TimestampObjectInspector)oi).getPrimitiveJavaObject(o);
        return isoDateFormatter.print(ts.getTime());
    }

    @Override
    public Object asTimestamp(DSSBaseInspector oi, String val) {
        return HiveDefaultDSSTimestampObjectInspector.asTimestampInternal(oi, val);
    }

    @Override
    public Object asLocalTimestamp(DSSBaseInspector oi, String val) {
        return HiveDefaultDSSTimestampObjectInspector.asLocalTimestampInternal(oi, val);
    }

    @Override
    public String readDate(PrimitiveObjectInspector oi, Object o) {
        Date ts = ((DateObjectInspector)oi).getPrimitiveJavaObject(o);
        return dateOnlyFormatter.print(ts.getTime());
    }

    @Override
    public Object asDate(DSSBaseInspector oi, String val) {
        return HiveDefaultDSSDateObjectInspector.asDateInternal(oi, val);
    }
}

