/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang.mutable.MutableInt;

public class BinaryUtils {
    public static int decodeUTF8(byte[] data, char[] chars) {
        int len = 0;
        int offset = 0;
        while (offset < data.length) {
            if ((data[offset] & 0x80) == 0) {
                chars[len] = (char)data[offset];
                ++len;
                ++offset;
                continue;
            }
            int uc = 0;
            if ((data[offset] & 0xE0) == 192) {
                uc = data[offset] & 0x1F;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                ++offset;
            } else if ((data[offset] & 0xF0) == 224) {
                uc = data[offset] & 0xF;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                ++offset;
            } else if ((data[offset] & 0xF8) == 240) {
                uc = data[offset] & 7;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                ++offset;
            } else if ((data[offset] & 0xFC) == 248) {
                uc = data[offset] & 3;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                ++offset;
            } else if ((data[offset] & 0xFE) == 252) {
                uc = data[offset] & 1;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                uc <<= 6;
                uc |= data[++offset] & 0x3F;
                ++offset;
            }
            len = BinaryUtils.toChars(uc, chars, len);
        }
        return len;
    }

    public static int toChars(int codePoint, char[] dst, int index) {
        if (codePoint < 0 || codePoint > 0x10FFFF) {
            throw new IllegalArgumentException();
        }
        if (codePoint < 65536) {
            dst[index] = (char)codePoint;
            return ++index;
        }
        int offset = codePoint - 65536;
        dst[index + 1] = (char)((offset & 0x3FF) + 56320);
        dst[index] = (char)((offset >>> 10) + 55296);
        return index + 2;
    }

    public static final void encodeLE64(long value, byte[] buffer, int pos) {
        buffer[pos] = (byte)((int)value & 0xFF);
        buffer[pos + 1] = (byte)((int)(value >> 8) & 0xFF);
        buffer[pos + 2] = (byte)((int)(value >> 16) & 0xFF);
        buffer[pos + 3] = (byte)((int)(value >> 24) & 0xFF);
        buffer[pos + 4] = (byte)((int)(value >> 32) & 0xFF);
        buffer[pos + 5] = (byte)((int)(value >> 40) & 0xFF);
        buffer[pos + 6] = (byte)((int)(value >> 48) & 0xFF);
        buffer[pos + 7] = (byte)((int)(value >> 56) & 0xFF);
    }

    public static final void encodeLE32(int value, byte[] buffer, int pos) {
        buffer[pos] = (byte)(value & 0xFF);
        buffer[pos + 1] = (byte)(value >> 8 & 0xFF);
        buffer[pos + 2] = (byte)(value >> 16 & 0xFF);
        buffer[pos + 3] = (byte)(value >> 24 & 0xFF);
    }

    public static final void encodeLE16(int value, byte[] buffer, int pos) {
        buffer[pos] = (byte)(value & 0xFF);
        buffer[pos + 1] = (byte)(value >> 8 & 0xFF);
    }

    public static final void encodeLE16(short value, byte[] buffer, int pos) {
        buffer[pos] = (byte)(value & 0xFF);
        buffer[pos + 1] = (byte)(value >> 8 & 0xFF);
    }

    public static final void encodeDouble(double value, byte[] buffer, int pos) {
        long ieee754Long = Double.doubleToLongBits(value);
        BinaryUtils.encodeLE64(ieee754Long, buffer, pos);
    }

    public static final void encodeFloat(float value, byte[] buffer, int pos) {
        int ieee754Int = Float.floatToIntBits(value);
        BinaryUtils.encodeLE32(ieee754Int, buffer, pos);
    }

    public static final int decodeUInt8(byte[] buffer, int offset) {
        return buffer[offset + 0] & 0xFF;
    }

    public static final int decodeLE32(byte[] buffer, int offset) {
        return buffer[offset + 0] & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
    }

    public static final int decodeBE32(byte[] buffer, int offset) {
        return buffer[offset + 3] & 0xFF | (buffer[offset + 2] & 0xFF) << 8 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 0] & 0xFF) << 24;
    }

    public static final short decodeLE16(byte[] buffer, int offset) {
        return (short)(buffer[offset + 0] & 0xFF | (buffer[offset + 1] & 0xFF) << 8);
    }

    public static final short decodeBE16(byte[] buffer, int offset) {
        return (short)(buffer[offset + 1] & 0xFF | (buffer[offset + 0] & 0xFF) << 8);
    }

    public static final long decodeLE64(byte[] buffer, int offset) {
        return (long)buffer[offset] & 0xFFL | ((long)buffer[offset + 1] & 0xFFL) << 8 | ((long)buffer[offset + 2] & 0xFFL) << 16 | ((long)buffer[offset + 3] & 0xFFL) << 24 | ((long)buffer[offset + 4] & 0xFFL) << 32 | ((long)buffer[offset + 5] & 0xFFL) << 40 | ((long)buffer[offset + 6] & 0xFFL) << 48 | ((long)buffer[offset + 7] & 0xFFL) << 56;
    }

    public static int writeVInt(long value, byte[] buffer, int pos) {
        byte b;
        int written = 0;
        while (true) {
            b = (byte)(value & 0x7FL);
            if ((value >>= 7) == 0L) break;
            buffer[pos + written++] = (byte)(b << 1 | 1);
        }
        buffer[pos + written++] = (byte)(b << 1);
        return written;
    }

    public static void readVIntSlow(byte[] buffer, int pos, VInt ret) {
        ret.codeSize = 0;
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b;
            ++ret.codeSize;
            long lb = (b = buffer[pos++]) >= 0 ? (long)b : 256L + (long)b;
            result |= lb >> 1 << shift;
            if ((lb & 1L) != 0L) continue;
            ret.value = result;
            return;
        }
        throw new Error("Malformed Vint");
    }

    public static void readVInt(byte[] buffer, int pos, VInt ret) {
        if ((buffer[pos] & 1) == 0) {
            ret.codeSize = 1;
            ret.value = buffer[pos] >>> 1 & 0x7F;
        } else if ((buffer[pos + 1] & 1) == 0) {
            ret.codeSize = 2;
            ret.value = buffer[pos] >>> 1 & 0x7F | (buffer[pos + 1] >>> 1 & 0x7F) << 7;
        } else if ((buffer[pos + 2] & 1) == 0) {
            ret.codeSize = 3;
            ret.value = buffer[pos] >>> 1 & 0x7F | (buffer[pos + 1] >>> 1 & 0x7F) << 7 | (buffer[pos + 2] >>> 1 & 0x7F) << 14;
        } else if ((buffer[pos + 3] & 1) == 0) {
            ret.codeSize = 4;
            ret.value = buffer[pos] >>> 1 & 0x7F | (buffer[pos + 1] >>> 1 & 0x7F) << 7 | (buffer[pos + 2] >>> 1 & 0x7F) << 14 | (buffer[pos + 3] >>> 1 & 0x7F) << 21;
        } else {
            ret.codeSize = 5;
            ret.value = buffer[pos] >>> 1 & 0x7F | (buffer[pos + 1] >>> 1 & 0x7F) << 7 | (buffer[pos + 2] >>> 1 & 0x7F) << 14 | (buffer[pos + 3] >>> 1 & 0x7F) << 21 | (buffer[pos + 4] >>> 1 & 0x7F) << 28;
        }
    }

    public static void readVInt(ByteBuffer buffer, long pos, VInt ret) {
        byte[] tmpBuf = new byte[10];
        buffer.position((int)pos);
        buffer.get(tmpBuf, 0, Math.min(10, buffer.remaining()));
        BinaryUtils.readVInt(tmpBuf, 0, ret);
    }

    public static long readVInt(byte[] buffer, int pos) {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b;
            long lb = (b = buffer[pos++]) >= 0 ? (long)b : 256L + (long)b;
            result |= lb >> 1 << shift;
            if ((lb & 1L) != 0L) continue;
            return result;
        }
        throw new Error("Malformed Vint");
    }

    public static String readUTF8LenAndString(byte[] buffer, int pos, MutableInt newPos) throws IOException {
        VInt v = new VInt();
        BinaryUtils.readVInt(buffer, pos, v);
        byte[] data = Arrays.copyOfRange(buffer, pos + v.codeSize, (int)((long)(pos + v.codeSize) + v.value));
        newPos.setValue((Object)((long)(pos + v.codeSize) + v.value));
        return new String(data, "utf8");
    }

    public static class VInt {
        public long value;
        public int codeSize;
    }
}

