/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.DockerSimplePythonKernel;
import com.dataiku.dip.io.KubernetesSimplePythonKernel;
import com.dataiku.dip.io.LocalSimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.threads.ThreadCodes;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class SimplePythonKernelFactory {
    public static final Logger logger = Logger.getLogger((String)"com.dataiku.dip.io");

    public static SimplePythonKernel prepareKernel(DSSAuthCtx owner, String projectKey, GeneralSettingsDAO.CGrouppableProcessType cGrouppableProcessType, String envName, String pythonPackage, boolean impersonateKernel, String containerConfName, String kernelId) throws IOException, DKUSecurityException, CodedException {
        return SimplePythonKernelFactory.prepareKernel(owner, projectKey, cGrouppableProcessType, envName, pythonPackage, impersonateKernel, false, null, containerConfName, kernelId, false, null);
    }

    public static SimplePythonKernel prepareKernel(DSSAuthCtx owner, String projectKey, GeneralSettingsDAO.CGrouppableProcessType cGrouppableProcessType, String envName, String pythonPackage, boolean impersonateKernel, boolean useProjectLibs, Map<String, String> pythonLibs, String containerConfName, String kernelId, boolean loadInstanceLibsInContainer, @Nullable Map<String, String> extraEnv) throws IOException, DKUSecurityException, CodedException {
        ContainerExecRuntimeConfig containerConfig = null;
        if (containerConfName != null) {
            containerConfig = new ClusterSelector().selectForProject(owner, projectKey).getContainerSettings().getByName(containerConfName);
        }
        return SimplePythonKernelFactory.prepareKernel(owner, projectKey, cGrouppableProcessType, envName, pythonPackage, impersonateKernel, useProjectLibs, pythonLibs, containerConfig, kernelId, kernelId + "-", loadInstanceLibsInContainer, true, extraEnv);
    }

    public static SimplePythonKernel prepareKernel(AuthCtx owner, String projectKey, GeneralSettingsDAO.CGrouppableProcessType cGrouppableProcessType, String envName, String pythonPackage, boolean impersonateKernel, boolean useProjectLibs, Map<String, String> pythonLibsForLocal, ContainerExecRuntimeConfig containerConfig, String kernelId, String kernelPrefix, boolean loadInstanceLibsInContainer, boolean additiveLogging, @Nullable Map<String, String> extraEnv) throws IOException, DKUSecurityException, CodedException {
        return SimplePythonKernelFactory.prepareKernel(owner, projectKey, cGrouppableProcessType, envName, pythonPackage, impersonateKernel, useProjectLibs, pythonLibsForLocal, containerConfig, kernelId, kernelPrefix, loadInstanceLibsInContainer, additiveLogging, extraEnv, false);
    }

    public static SimplePythonKernel prepareKernel(AuthCtx owner, String projectKey, GeneralSettingsDAO.CGrouppableProcessType cGrouppableProcessType, String envName, String pythonPackage, boolean impersonateKernel, boolean useProjectLibs, Map<String, String> pythonLibsForLocal, ContainerExecRuntimeConfig containerConfig, String kernelId, String kernelPrefix, boolean loadInstanceLibsInContainer, boolean additiveLogging, @Nullable Map<String, String> extraEnv, boolean killProcessTreeOnClose) throws IOException, DKUSecurityException, CodedException {
        if (extraEnv == null) {
            extraEnv = new HashMap<String, String>();
        }
        if (containerConfig == null) {
            LocalSimplePythonKernel kernel = new LocalSimplePythonKernel(owner, projectKey, cGrouppableProcessType, envName, pythonPackage, impersonateKernel, useProjectLibs, pythonLibsForLocal, additiveLogging, kernelId);
            kernel.withExtraEnv(extraEnv);
            kernel.withKillProcessTreeOnClose(killProcessTreeOnClose);
            return kernel;
        }
        if (owner instanceof DSSAuthCtx) {
            DSSAuthCtx dssAuthCtx = (DSSAuthCtx)owner;
            dssAuthCtx.failIfCantUseContainerConf(containerConfig);
        }
        CodeEnvModel.UsedCodeEnvRef codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName);
        switch (containerConfig.type) {
            case DOCKER: {
                return new DockerSimplePythonKernel(kernelId + "-docker", owner, projectKey, containerConfig, codeEnvRef, pythonPackage, kernelPrefix, loadInstanceLibsInContainer, useProjectLibs, additiveLogging).withExtraEnv((Map)extraEnv);
            }
            case KUBERNETES: {
                return new KubernetesSimplePythonKernel(kernelId + "-k8s", owner, projectKey, containerConfig, codeEnvRef, pythonPackage, kernelPrefix, loadInstanceLibsInContainer, useProjectLibs, additiveLogging).withExtraEnv((Map)extraEnv);
            }
        }
        throw new CodedException((InfoMessage.MessageCode)ThreadCodes.ERR_UNSUPPORTED_CONTAINER_TYPE, "Unsupported container type: " + String.valueOf((Object)containerConfig.type));
    }
}

