/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.kernel;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;

public class DSSKernelUtils {
    public static void setKernelContext(ComputeResourceUsageContext ctx, JobContext jobContext, DKULogger logger) {
        if (ctx != null) {
            logger.info((Object)("Set compute resource context for kernel: Project=" + ctx.projectKey + ", Job=" + ctx.jobId + ", Activity=" + ctx.activityId));
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ctx);
        }
        if (jobContext != null) {
            JobContext.setJob(jobContext.projectKey, jobContext.jobId, jobContext.getJobObj());
            JobContext.setCurrentActivityInThread(jobContext.getActivityObj());
        }
    }

    public static int getMaxKernelCount(Params localParams, String maxKernelsPropertyName, String maxKernelProportionPropertyName, boolean singleInstance, int globalMaxKernelCount) {
        if (singleInstance) {
            return 1;
        }
        int maxKernelCount = localParams.getIntParam(maxKernelsPropertyName, Integer.valueOf(-1));
        if (maxKernelCount == -1) {
            maxKernelCount = (int)Math.ceil(DSSKernelUtils.getDoubleParamWithFallback(localParams, maxKernelProportionPropertyName, 0.3) * (double)globalMaxKernelCount);
        }
        return Math.min(Math.max(maxKernelCount, 1), globalMaxKernelCount);
    }

    public static int getIntParamWithFallback(Params params, String name, int defaultValue) {
        return DSSKernelUtils.getIntParamWithFallback(params, DKUApp.getParams(), name, defaultValue);
    }

    public static int getIntParamWithFallback(Params params, Params fallbackParams, String name, int defaultValue) {
        if (params.hasParam(name)) {
            return params.getIntParam(name, Integer.valueOf(defaultValue));
        }
        return fallbackParams.getIntParam(name, Integer.valueOf(defaultValue));
    }

    public static String getParamWithFallback(Params params, Params fallbackParams, String name, String defaultValue) {
        if (params.hasParam(name)) {
            return params.getParam(name, defaultValue);
        }
        return fallbackParams.getParam(name, defaultValue);
    }

    public static double getDoubleParamWithFallback(Params params, String name, double defaultValue) {
        return DSSKernelUtils.getDoubleParamWithFallback(params, DKUApp.getParams(), name, defaultValue);
    }

    public static double getDoubleParamWithFallback(Params params, Params fallbackParams, String name, double defaultValue) {
        if (params.hasParam(name)) {
            return params.getDoubleParam(name, defaultValue);
        }
        return fallbackParams.getDoubleParam(name, defaultValue);
    }

    public static boolean getBoolParamWithFallback(Params params, String name, boolean defaultValue) {
        return DSSKernelUtils.getBoolParamWithFallback(params, DKUApp.getParams(), name, defaultValue);
    }

    public static boolean getBoolParamWithFallback(Params params, Params fallbackParams, String name, boolean defaultValue) {
        if (params.hasParam(name)) {
            return params.getBoolParam(name, defaultValue);
        }
        return fallbackParams.getBoolParam(name, defaultValue);
    }
}

