/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.custom;

import com.dataiku.common.rpc.ExternalJSONAPIClient;
import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.llm.custom.CustomLLMClient;
import com.dataiku.dip.llm.utils.OnlineLLMUtils;
import com.dataiku.dss.shadelib.org.apache.http.client.ResponseHandler;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import java.io.IOException;
import java.util.concurrent.Callable;

@RoutinelyUsedInExtensionCode
public class RateLimitingJSONAPIClient
extends ExternalJSONAPIClient {
    @RoutinelyUsedInExtensionCode
    public RateLimitingJSONAPIClient(String baseURI, String serverCertPEM, boolean trustAllSSLCertificates, ProxySettings proxySettings) {
        super(baseURI, serverCertPEM, trustAllSSLCertificates, proxySettings);
    }

    protected <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<T> responseHandler) throws IOException {
        return (T)this.wrapExecute(() -> super.execute(httpUriRequest, responseHandler));
    }

    protected ExternalJSONAPIClient.EntityAndRequest executeStream(HttpRequestBase httpRequest) throws IOException {
        return this.wrapExecute(() -> super.executeStream(httpRequest));
    }

    protected boolean isRetryableException(Exception e) {
        return OnlineLLMUtils.isRetryableException(e);
    }

    private <R> R wrapExecute(Callable<R> callable) throws IOException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (this.isRetryableException(e)) {
                throw new CustomLLMClient.RetryableException(e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

