/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.bedrock;

import com.dataiku.dip.analysis.ml.llm.LLMSavedModelVersionDeployment;
import com.dataiku.dip.analysis.ml.llm.LLMSavedModelVersionDeploymentWithStatus;
import com.dataiku.dip.llm.online.ISavedModelDeployer;
import com.dataiku.dip.llm.online.bedrock.RawBedrockClient;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.Optional;

public class BedrockSavedModelDeployer
implements ISavedModelDeployer {
    private final RawBedrockClient rawBedrockClient;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.online.bedrock.model-deployer");

    public BedrockSavedModelDeployer(RawBedrockClient rawBedrockClient) {
        this.rawBedrockClient = rawBedrockClient;
    }

    @Override
    public LLMSavedModelVersionDeploymentWithStatus getDeployment(LLMSavedModelVersionDeployment deployment) throws IOException {
        Optional<RawBedrockClient.BedrockProvisionedThroughput> provisionedThroughput = this.rawBedrockClient.getProvisionedThroughput_NT(deployment.deploymentId);
        return LLMSavedModelVersionDeploymentWithStatus.fromBedrockDeployment(deployment, provisionedThroughput, LLMSavedModelVersionDeploymentWithStatus.DeploymentStatus.NOT_FOUND);
    }

    @Override
    public void deleteDeployment(LLMSavedModelVersionDeployment deployment) throws IOException {
        this.rawBedrockClient.deleteProvisionedThroughput_NT(deployment.deploymentId);
    }

    @Override
    public LLMSavedModelVersionDeploymentWithStatus createDeployment(LLMSavedModelVersionDeployment deployment, String remoteModelId) throws IOException {
        this.rawBedrockClient.createProvisionedThroughput_NT(deployment.deploymentId, remoteModelId);
        return this.getDeployment(deployment);
    }
}

