/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai;

import com.dataiku.dip.connections.AbstractAzureAIConnection;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.AzureAIFoundryConnection;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.online.openai.AbstractAzureAIClient;
import com.dataiku.dip.llm.online.openai.OpenAIChatAPI;
import com.dataiku.dip.llm.online.openai.RawOpenAIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import javax.annotation.Nullable;

public class AzureAIFoundryClient
extends AbstractAzureAIClient<AzureAIFoundryConnection.AzureAIFoundryDeployment, AzureAIFoundryConnection, AbstractLLMConnection.IHardcodedConnectionModel<AbstractAzureAIConnection.AbstractAzureAIModel>, AzureAIFoundryConnection.CustomAzureAIFoundryModel> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.azureaifoundry");

    public AzureAIFoundryClient(AzureAIFoundryConnection connection, LLMModelHandle<AbstractAzureAIConnection.AbstractAzureAIModel> modelHandle, AuthCtx authCtx, @Nullable String projectKey) throws DKUSecurityException, IOException {
        super(connection, modelHandle, authCtx, projectKey);
    }

    @Override
    protected void setRawClient(AzureAIFoundryConnection connection, AuthCtx authCtx, @Nullable String projectKey, ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds, AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings, boolean trustAllSSLCertificates, boolean forceContentLength) {
        switch (creds.authType) {
            case OAUTH2_APP: {
                this.raw = RawOpenAIClient.forAzureAiFoundryWithOAuthToken(connection.params.resourceName, creds.oauth2AccessToken, connection.params.customHeaders, projectKey, networkSettings, connection.getProxySettings(), trustAllSSLCertificates, forceContentLength, authCtx, connection, ((AzureAIFoundryConnection.AzureAIFoundryModel)this.model).modelHandlingMode);
            }
            case KEY: {
                this.raw = RawOpenAIClient.forAzureAIFoundryWithAPIKey(connection.params.resourceName, creds.key, connection.params.customHeaders, projectKey, networkSettings, connection.getProxySettings(), trustAllSSLCertificates, forceContentLength, authCtx, connection, ((AzureAIFoundryConnection.AzureAIFoundryModel)this.model).modelHandlingMode);
            }
        }
    }

    @Override
    public OpenAIChatAPI getAPI() {
        AbstractLLMConnection.BaseModel baseModel = this.model;
        if (baseModel instanceof AzureAIFoundryConnection.AzureAIFoundryModel) {
            AzureAIFoundryConnection.AzureAIFoundryModel aiFoundryModel = (AzureAIFoundryConnection.AzureAIFoundryModel)baseModel;
            if (aiFoundryModel.modelHandlingMode.supportsResponses) {
                return ((AbstractAzureAIConnection.AbstractAzureAIModel)this.model).api;
            }
        }
        return OpenAIChatAPI.CHAT_COMPLETIONS;
    }

    @Override
    public String getLogPrefix() {
        return "AzureAIFoundry";
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }
}

