/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec.drift;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DriftParams {
    Map<String, PerColumnDriftParam> columns = new HashMap<String, PerColumnDriftParam>();
    int nbBins = 10;
    boolean computeHistograms = true;
    double confidenceLevel = 0.95;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriftParams that = (DriftParams)o;
        return this.nbBins == that.nbBins && this.computeHistograms == that.computeHistograms && Double.compare(that.confidenceLevel, this.confidenceLevel) == 0 && Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.nbBins, this.computeHistograms, this.confidenceLevel);
    }

    public String toString() {
        return "nbBins: " + this.nbBins + ", computeHistograms:" + this.computeHistograms + ", confidenceLevel:" + this.confidenceLevel + ", columns:" + this.columns.toString();
    }

    public static class PerColumnDriftParam {
        public ColumnHandling handling = ColumnHandling.AUTO;
        public boolean enabled;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerColumnDriftParam that = (PerColumnDriftParam)o;
            return this.enabled == that.enabled && this.handling == that.handling;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.handling, this.enabled});
        }
    }

    public static enum ColumnHandling {
        NUMERICAL,
        CATEGORICAL,
        TEXT,
        IMAGE,
        AUTO;

    }
}

