/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec.drift;

import com.dataiku.dip.analysis.model.prediction.PredictionModelPerformanceMetrics;
import com.dataiku.dip.mec.drift.ImageDriftResult;
import com.dataiku.dip.mec.drift.PredictionDriftResult;
import com.dataiku.dip.mec.drift.TextDriftResult;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DriftResult {
    @Nullable
    public DriftModelResult driftModelResult;
    public UnivariateDriftResult univariateDriftResult;
    public List<ColumnSettings> perColumnSettings;
    public int referenceSampleSize;
    public int currentSampleSize;
    public Double referenceThreshold;
    public Double currentThreshold;
    public PredictionDriftResult predictionDriftResult;
    public TextDriftResult textDriftResult;
    public ImageDriftResult imageDriftResult;

    public static class UnivariateDriftResult {
        public Map<String, ColumnDrift> columns;

        public void populateMetrics(PredictionModelPerformanceMetrics metrics) {
            this.columns.forEach((column, drift) -> {
                if (drift instanceof NumericalColumnDrift) {
                    NumericalColumnDrift numDrift = (NumericalColumnDrift)drift;
                    metrics.ksPerFeature.put((String)column, numDrift.ksTestPvalue);
                    if (numDrift.ksTestPvalue != null && (metrics.minKs == null || numDrift.ksTestPvalue < metrics.minKs)) {
                        metrics.minKs = numDrift.ksTestPvalue;
                    }
                }
                if (drift instanceof CategoricalColumnDrift) {
                    CategoricalColumnDrift catDrift = (CategoricalColumnDrift)drift;
                    metrics.chiSquarePerFeature.put((String)column, catDrift.chiSquareTestPvalue);
                    if (catDrift.chiSquareTestPvalue != null && (metrics.minChiSquare == null || catDrift.chiSquareTestPvalue < metrics.minChiSquare)) {
                        metrics.minChiSquare = catDrift.chiSquareTestPvalue;
                    }
                }
                if (drift.populationStabilityIndex != null) {
                    metrics.psiPerFeature.put((String)column, drift.populationStabilityIndex);
                    if (drift.populationStabilityIndex != null && (metrics.maxPsi == null || drift.populationStabilityIndex > metrics.maxPsi)) {
                        metrics.maxPsi = drift.populationStabilityIndex;
                    }
                }
            });
        }

        static class NumericalColumnDrift
        extends ColumnDrift {
            public ComparativeNumericalHistogram histogram;
            @Nullable
            public Double wassersteinDistance;
            @Nullable
            public Double ksTestStatistic;
            @Nullable
            public Double ksTestPvalue;

            NumericalColumnDrift() {
            }

            public static class ComparativeNumericalHistogram {
                public double[] binEdges;
                public int[] binCountsReference;
                public int[] binCountsCurrent;
                public int nbMissingValuesReference;
                public int nbMissingValuesCurrent;
                public int rowCountReference;
                public int rowCountCurrent;
            }
        }

        public static class CategoricalColumnDrift
        extends ColumnDrift {
            public ComparativeCategoricalHistogram histogram;
            @Nullable
            public Double chiSquareTestPvalue;
            public Boolean chiSquareTestRejected;
            @Nullable
            public Double chiSquareTestStatistic;
            @Nullable
            public Double newValuesPercentage;

            static class ComparativeCategoricalHistogram {
                public String[] binNames;
                public int[] binCountsReference;
                public int[] binCountsCurrent;
                public int rowCountReference;
                public int rowCountCurrent;

                ComparativeCategoricalHistogram() {
                }
            }
        }

        @PolyJSON(value={@Mapping(value=NumericalColumnDrift.class, type="NUMERICAL"), @Mapping(value=CategoricalColumnDrift.class, type="CATEGORICAL")})
        static abstract class ColumnDrift {
            public String name;
            @Nullable
            public Double populationStabilityIndex;

            ColumnDrift() {
            }
        }
    }

    public static class DriftModelResult {
        public int referenceSampleSize;
        public int currentSampleSize;
        public DriftModelAccuracy driftModelAccuracy;
        public DriftVersusImportanceChart driftVersusImportance;

        public static class DriftModelAccuracy {
            public double value;
            public double confidenceLevel;
            public double lower;
            public double upper;
            public double pvalue;
        }

        public static class DriftVersusImportanceChart {
            public List<String> columns;
            public double[] columnDriftScores;
            @Nullable
            public double[] columnImportanceScores;
        }
    }

    static class ColumnSettings {
        String name;
        ResolvedColumnHandling actualHandling;
        ResolvedColumnHandling defaultHandling;
        @Nullable
        String errorMessage;

        ColumnSettings() {
        }
    }

    static enum ResolvedColumnHandling {
        NUMERICAL,
        CATEGORICAL,
        TEXT,
        IGNORED,
        UNSUPPORTED;

    }
}

