/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public abstract class MetricsEngineRun {
    public final String engineType;
    public final MetricsEngineDesc engine;
    public final int pass;
    private List<MetricComputation> computations = Lists.newArrayList();
    public double cost = 0.0;

    public MetricsEngineRun(MetricsEngineDesc engine) {
        this.engine = engine;
        this.engineType = engine.getType();
        this.pass = 1;
    }

    public MetricsEngineRun(MetricsEngineDesc engine, int pass) {
        this.engine = engine;
        this.engineType = engine.getType();
        this.pass = pass;
    }

    public MetricsEngineDesc getEngine() {
        return this.engine;
    }

    public int getPass() {
        return this.pass;
    }

    public List<MetricComputation> getComputations() {
        return this.computations;
    }

    public MetricsEngineRun with(MetricComputation computation) {
        this.computations.add(computation);
        this.cost = Math.max(this.cost, computation.cost);
        return this;
    }

    public MetricsEngineRun with(List<MetricComputation> computations) {
        this.computations.addAll(computations);
        for (MetricComputation computation : computations) {
            this.cost = Math.max(this.cost, computation.cost);
        }
        return this;
    }

    public boolean canMergeWith(MetricsEngineRun other) {
        return this.engine.equals(other.engine) && this.pass == other.pass;
    }

    public boolean canAdd(MetricsEngineRun other) {
        return this.canMergeWith(other);
    }

    public boolean countAfterMergeStaysBelow(MetricsEngineRun other, int maxComputationCount) {
        return this.computations.size() + other.computations.size() <= maxComputationCount;
    }

    public MetricsEngineRun mergeWith(MetricsEngineRun other) {
        this.computations.addAll(other.computations);
        return this;
    }

    protected abstract MetricsEngineRun subset(double var1, List<MetricComputation> var3);

    protected MetricsEngineRun(MetricsEngineDesc engine, double cost, List<MetricComputation> computations, int pass) {
        this.engine = engine;
        this.engineType = engine.getType();
        this.cost = cost;
        this.computations = computations;
        this.pass = pass;
    }

    public double getMaxCost() {
        double cost = 0.0;
        for (MetricComputation computation : this.computations) {
            cost = Math.max(cost, computation.cost);
        }
        return cost;
    }

    public MetricsEngineRun getUsefulPart(Set<Metric> metrics) {
        double cost = 0.0;
        ArrayList computations = Lists.newArrayList();
        for (MetricComputation computation : this.computations) {
            if (!metrics.contains(computation.metric)) continue;
            computations.add(computation);
            cost = Math.max(cost, computation.cost);
        }
        return computations.size() > 0 ? this.subset(cost, computations) : null;
    }

    public String getProgressName() {
        TreeMap metricCountsByType = Maps.newTreeMap();
        for (MetricComputation computation : this.computations) {
            Metric metric = computation.metric;
            if (metric == null || metric.getMeta() == null || !StringUtils.isNotBlank((String)metric.getMeta().getName())) continue;
            String name = metric.getMeta().getName();
            if (!metricCountsByType.containsKey(name)) {
                metricCountsByType.put(name, 0);
            }
            metricCountsByType.put(name, 1 + (Integer)metricCountsByType.get(name));
        }
        StringBuilder metricsDescription = new StringBuilder();
        for (Map.Entry metricCount : metricCountsByType.entrySet()) {
            int count = (Integer)metricCount.getValue();
            String name = (String)metricCount.getKey();
            if (metricsDescription.length() > 0) {
                metricsDescription.append(", ");
            }
            metricsDescription.append(name);
            if (count <= 1) continue;
            metricsDescription.append(" (" + count + ")");
        }
        return "Compute " + metricsDescription.toString() + " on " + this.engine.displayName;
    }
}

