/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.output.ExtensibleOutputWriter;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.PathBasedExtensibleOutputWriter;
import com.dataiku.dip.output.TransactionalizableOutputWriter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ResplittableExtensibleFileOutputWriter<T extends FSProvider>
extends PathBasedExtensibleOutputWriter
implements TransactionalizableOutputWriter<ResplittableExtensibleFileOutputWriter<? extends FSProvider>> {
    private boolean transactionalMode;
    protected T provider;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.output.file");

    public ResplittableExtensibleFileOutputWriter(AuthCtx authCtx, String projectKey, T provider, String basePath, int splitId, int nbChunks, String formatType, FormatParams formatParams, Schema schema, WarningsContext warningsContext, Output.WriteMode writeMode, String compress, SerializedDataset.ReadWriteOptions readWriteOptions) {
        super(authCtx, projectKey, basePath, splitId, nbChunks, formatType, formatParams, schema, warningsContext, writeMode, compress, readWriteOptions);
        this.provider = provider;
    }

    public ResplittableExtensibleFileOutputWriter<T> withTransactionalMode() {
        this.transactionalMode = true;
        return this;
    }

    public List<String> gatherWritesInProgress() {
        ArrayList ret = Lists.newArrayList();
        for (ExtensibleOutputWriter.SplitChunk chunk : this.chunks) {
            if (StringUtils.isNotBlank((CharSequence)chunk.tmpFilePath)) {
                ret.add(chunk.tmpFilePath);
            }
            if (!StringUtils.isNotBlank((CharSequence)chunk.finalFilePath) || StringUtils.equals((CharSequence)chunk.tmpFilePath, (CharSequence)chunk.finalFilePath)) continue;
            ret.add(chunk.finalFilePath);
        }
        return ret;
    }

    public static List<String> gatherPathsWrittenToAndNotCommitted(FSProvider provider, int splitId) throws IOException, CodedException, DKUSecurityException {
        FSEnumerationSettings enumetationSettings = FSEnumerationSettings.filesPrefixedBy((String)("_tmp\\.out\\-s" + splitId + "[.-].*")).withHiddenFiles();
        FSEnumerationResult enumeration = provider.enumerateRecursive("/", enumetationSettings);
        ArrayList paths = Lists.newArrayList();
        if (enumeration.isSuccessful() && enumeration.getPaths() != null) {
            for (FSPath path : enumeration.getPaths()) {
                paths.add(path.path());
            }
        }
        return paths;
    }

    @Override
    protected boolean fileExists(String path) throws CodedException, IOException, DKUSecurityException {
        return this.provider.stat(path) != null;
    }

    @Override
    protected boolean isTransactionalMode() {
        return this.transactionalMode;
    }

    @Override
    protected OutputStream writeToStream(String path) throws IOException, CodedException, DKUSecurityException {
        return this.provider.write(path);
    }

    @Override
    protected void chunkFinishedHook(ExtensibleOutputWriter.SplitChunk chunk) throws IOException, CodedException, DKUSecurityException {
        if (this.transactionalMode) {
            logger.infoV("Committing chunk : %s -> %s", new Object[]{chunk.tmpFilePath, chunk.finalFilePath});
            this.provider.moveFile(chunk.tmpFilePath, chunk.finalFilePath);
        }
    }

    @Override
    protected void chunkCancelledHook(ExtensibleOutputWriter.SplitChunk chunk) {
    }
}

