/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.automaticbin;

import com.dataiku.dip.pivot.backend.common.automaticbin.BinningModeComputer;
import com.dataiku.dip.pivot.backend.common.datebinner.IDateBinner;
import com.dataiku.dip.pivot.backend.model.DateAxisParams;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.sql.SQLDialect;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.List;

public class SqlBinningModeComputer
extends BinningModeComputer {
    private final SQLDialect dialect;

    SqlBinningModeComputer(int maxBinNumberForAutomaticMode, SQLDialect dialect) {
        super(maxBinNumberForAutomaticMode);
        this.dialect = dialect;
    }

    @Override
    protected List<DateAxisParams.BinningMode> computeValidAggregationLevels() {
        return FluentIterable.from((Iterable)VALID_AGGREGATION_LEVELS).filter((Predicate)new Predicate<DateAxisParams.BinningMode>(){

            public boolean apply(DateAxisParams.BinningMode mode) {
                return SqlBinningModeComputer.this.isSupportedByDialect(mode.getDateBinner());
            }
        }).toList();
    }

    private boolean isSupportedByDialect(IDateBinner dateBinner) {
        ColumnMapper.TypedExpr binningSqlExpression = null;
        try {
            binningSqlExpression = dateBinner.binningSqlExpression("foo", this.dialect);
        }
        catch (Exception e) {
            this.logger.warnV((Throwable)e, "Dialect %s can't handle date binner mode '%s'", new Object[]{this.dialect.getClass().getSimpleName(), dateBinner.getClass().getSimpleName()});
        }
        return binningSqlExpression != null;
    }
}

