/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

public class LongDataTensor {
    public int numAxes;
    public int[] axisLengths;
    public long[] tensor;
    public long[][] axes;
    public int[] multipliers;

    public int loc(int[] coordinates) {
        int loc = 0;
        for (int i = 0; i < coordinates.length; ++i) {
            loc += coordinates[i] * this.multipliers[i];
        }
        return loc;
    }

    public int[] getCoordinates(int loc) {
        int[] coordinates = new int[this.multipliers.length];
        for (int i = this.multipliers.length - 1; i >= 0; --i) {
            coordinates[i] = loc / this.multipliers[i];
            loc %= this.multipliers[i];
        }
        return coordinates;
    }

    public void put(int[] coordinates, long data) {
        this.tensor[this.loc((int[])coordinates)] = data;
    }

    public void increment(int[] coordinates) {
        this.increment(coordinates, 1L);
    }

    public void increment(int[] coordinates, long val) {
        int n = this.loc(coordinates);
        this.tensor[n] = this.tensor[n] + val;
    }

    public long get(int[] coordinates) {
        return this.tensor[this.loc(coordinates)];
    }

    public long merge(int[] coordinates, LongMerger merger, long newValue) {
        int loc = this.loc(coordinates);
        this.tensor[loc] = merger.merge(this.tensor[loc], newValue);
        return this.tensor[loc];
    }

    public LongDataTensor(int[] axisLengths) {
        this.axisLengths = axisLengths;
        this.numAxes = axisLengths.length;
        this.axes = new long[this.numAxes][];
        this.multipliers = new int[this.numAxes];
        for (int i = 0; i < this.numAxes; ++i) {
            if (i == 0) {
                this.multipliers[0] = 1;
            } else {
                this.multipliers[i] = this.multipliers[i - 1] * axisLengths[i - 1];
            }
            this.axes[i] = new long[axisLengths[i]];
        }
        this.tensor = new long[this.multipliers[this.numAxes - 1] * axisLengths[this.numAxes - 1]];
    }

    public LongDataTensor(int axisLength) {
        this(new int[]{axisLength});
    }

    public static long getUsedBytes(int[] axisLengths) {
        long usedLongs = 0L;
        int tensorLength = 1;
        for (int i = 0; i < axisLengths.length; ++i) {
            tensorLength *= axisLengths[i];
            usedLongs += (long)axisLengths[i];
        }
        return (usedLongs += (long)tensorLength) * 8L;
    }

    public static interface LongMerger {
        public long merge(long var1, long var3);
    }
}

