/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoMetaFile;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import java.util.ArrayList;
import java.util.List;

public class StringDictAxisHandler
implements AxisHandler {
    List<String> linoDict;

    public StringDictAxisHandler(LinoMetaFile.ColumnHeader header) {
        this.linoDict = header.stringDict;
    }

    @Override
    public void observe(Row row) {
        throw new Error("Bad row");
    }

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
        assert (block.getMemoryType() == ColumnBlock.MemoryType.STRING_DICT);
    }

    @Override
    public int getNbBins() {
        return this.linoDict.size();
    }

    @Override
    public void getBins(ColumnBlock block, int[] ret, boolean[] filters) {
        System.arraycopy(block.ints, 0, ret, 0, block.nbRecords());
    }

    @Override
    public List<AxisElt> getAxisElts() {
        ArrayList<AxisElt> ret = new ArrayList<AxisElt>();
        for (String label : this.linoDict) {
            AxisElt elt = new AxisElt();
            elt.label = label;
            ret.add(elt);
        }
        return ret;
    }
}

