/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.aggregators.DoubleAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import java.io.IOException;

public class CountAggregator
extends DoubleAggregator {
    private static final String ERROR_MESSAGE = "";

    public CountAggregator(Aggregation req, int[] numBins) {
        super(req, numBins, ERROR_MESSAGE);
    }

    public CountAggregator(Aggregation req, int bins) {
        super(req, bins, ERROR_MESSAGE);
    }

    public CountAggregator(Aggregation req) {
        super(req, ERROR_MESSAGE);
    }

    @Override
    public void handleBlock(ColumnBlock block, int start, int rows, int[] coords, int[] bins, boolean[] filters, boolean fillAxes) throws IOException {
        for (int row = start; row < rows; ++row) {
            if (filters != null && !filters[row]) continue;
            if (this.blockHasValidValue(block, row)) {
                int[] destBin = this.extractDestBin(row, coords, bins);
                if (destBin == null) continue;
                super.handle(1.0, destBin, fillAxes);
                continue;
            }
            this.getOutDT().hasNullValues = true;
        }
    }

    private boolean blockHasValidValue(ColumnBlock block, int row) {
        if (block == null) {
            return true;
        }
        if (block.doubles != null) {
            return Double.isFinite(block.doubles[row]);
        }
        return this.validString(block.getAsStringSlow(row));
    }

    @Override
    protected void handle(Object value, int[] coords, boolean fillAxes) throws IOException {
        if (value != null && this.validString(value.toString())) {
            super.handle(1.0, coords, fillAxes);
        } else {
            this.getOutDT().hasNullValues = true;
        }
    }

    @Override
    protected void handle(double value, int[] coords, boolean fillAxes) throws IOException {
        if (Double.isFinite(value)) {
            super.handle(1.0, coords, fillAxes);
        } else {
            this.getOutDT().hasNullValues = true;
        }
    }

    private boolean validString(String value) {
        return value != null && !value.isEmpty();
    }
}

