/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.utils;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.pivot.ChartCodes;
import com.dataiku.dip.pivot.backend.sql.utils.ConnectionPool;
import org.apache.commons.lang.StringUtils;

public class ConnectionsUtils {
    public static void ensureSnowflakeDbNotNull(ConnectionPool.PooledConnection connection) {
        if (connection == null) {
            return;
        }
        AbstractSQLConnection sqlConnection = connection.getSqlConnection().getConnectionData().getConnection();
        if (sqlConnection instanceof SnowflakeConnection && StringUtils.isBlank((String)((SnowflakeConnection)sqlConnection).params.db)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ChartCodes.ERR_SNOWFLAKE_ENGINE_REQUIRE_DATABASE, String.format("Ask your DSS administrator to configure the Snowflake connection named '%s' with an non-empty Database to be able to use it as a Chart engine.", sqlConnection.name));
        }
    }
}

