/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.connections.PerUserOAuth2Helper;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.ParameterSetSettings;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.plugins.presets.LoadedParameterSet;
import com.dataiku.dip.plugins.presets.PluginPreset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.security.model.PluginCredentialRequestService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;

public class PluginConfigUtils {
    private static final String HIDDEN_FIELD = "*********";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.pluginconfigutils");

    public static JsonObject getResolved(AuthCtx authCtx, JsonObject config, List<ParamDesc> descList, String pluginId, String paramSetId, String presetId) throws IOException, DKUSecurityException {
        if (config == null) {
            return null;
        }
        JsonObject newConfig = (JsonObject)JSON.deepCopy((Object)config);
        PluginConfigUtils.decryptInPlace(newConfig, descList);
        PluginConfigUtils.resolveCredentialRequestsInPlace(authCtx, newConfig, descList, pluginId, paramSetId, presetId);
        return newConfig;
    }

    public static JsonObject getExpandedAndResolved(AuthCtx authCtx, JsonObject config, List<ParamDesc> descList, String projectKey, String pluginId, String paramSetId, String presetId) throws IOException, DKUSecurityException {
        if (config == null) {
            return null;
        }
        JsonObject newConfig = (JsonObject)JSON.deepCopy((Object)config);
        PluginConfigUtils.decryptInPlace(newConfig, descList);
        PluginConfigUtils.expandInPlace(newConfig, descList, projectKey);
        PluginConfigUtils.resolveCredentialRequestsInPlace(authCtx, newConfig, descList, pluginId, paramSetId, presetId);
        return newConfig;
    }

    public static JsonObject getExpanded(JsonObject config, List<ParamDesc> descList, String projectKey) {
        if (config == null) {
            return null;
        }
        JsonObject newConfig = (JsonObject)JSON.deepCopy((Object)config);
        PluginConfigUtils.decryptInPlace(newConfig, descList);
        PluginConfigUtils.expandInPlace(newConfig, descList, projectKey);
        return newConfig;
    }

    public static void expandInPlace(JsonObject config, List<ParamDesc> descList, String projectKey) {
        if (descList == null || descList.size() == 0) {
            return;
        }
        VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext context = vs.getForProject(projectKey);
        block7: for (ParamDesc pd : descList) {
            if (pd.type == null) {
                throw new IllegalArgumentException("Error in plugin: no type or invalid type specified for parameter " + pd.name + "(" + pd.label + ")");
            }
            JsonElement curVal = config.get(pd.name);
            if (curVal == null) continue;
            switch (pd.type) {
                case PASSWORD: 
                case STRING: 
                case TEXTAREA: {
                    if (!PluginConfigUtils.isString(curVal)) break;
                    config.addProperty(pd.name, context.expand(curVal.getAsString()));
                    break;
                }
                case STRINGS: {
                    JsonArray strings = curVal.getAsJsonArray();
                    for (int i = 0; i < strings.size(); ++i) {
                        if (!PluginConfigUtils.isString(strings.get(i))) continue;
                        strings.set(i, (JsonElement)new JsonPrimitive(context.expand(strings.get(i).getAsString())));
                    }
                    continue block7;
                }
                case KEY_VALUE_LIST: 
                case OBJECT_LIST: {
                    JsonArray subValues = curVal.getAsJsonArray();
                    List<ParamDesc> subParams = pd.type == ParamDesc.Type.OBJECT_LIST ? pd.subParams : PluginConfigUtils.makeSubParamsForKeyValue();
                    for (int i = 0; i < subValues.size(); ++i) {
                        JsonElement jsonElement = subValues.get(i);
                        if (!jsonElement.isJsonObject()) continue;
                        PluginConfigUtils.expandInPlace(jsonElement.getAsJsonObject(), subParams, projectKey);
                    }
                    continue block7;
                }
                case ARRAY: {
                    JsonArray subValues = curVal.getAsJsonArray();
                    for (int i = 0; i < subValues.size(); ++i) {
                        JsonElement subObject = subValues.get(i);
                        if (!PluginConfigUtils.isString(subObject)) continue;
                        subValues.set(i, (JsonElement)new JsonPrimitive(context.expand(subObject.getAsString())));
                    }
                    continue block7;
                }
                case MAP: {
                    JsonArray subValues = curVal.getAsJsonObject();
                    HashMap changes = Maps.newHashMap();
                    for (Map.Entry entry : subValues.entrySet()) {
                        JsonElement subObject = (JsonElement)entry.getValue();
                        if (!PluginConfigUtils.isString(subObject)) continue;
                        changes.put((String)entry.getKey(), new JsonPrimitive(context.expand(subObject.getAsString())));
                    }
                    for (Map.Entry entry : changes.entrySet()) {
                        subValues.add((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                    continue block7;
                }
            }
        }
    }

    public static void decryptInPlace(JsonObject config, List<ParamDesc> descList) {
        if (descList == null || descList.size() == 0) {
            return;
        }
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        block4: for (ParamDesc pd : descList) {
            if (pd.type == null) {
                throw new IllegalArgumentException("Error in plugin: no type or invalid type specified for parameter " + pd.name + "(" + pd.label + ")");
            }
            JsonElement curVal = config.get(pd.name);
            if (curVal == null) continue;
            switch (pd.type) {
                case PASSWORD: {
                    if (!PluginConfigUtils.isString(curVal)) break;
                    String decrypted = cryptoService.decryptIfEncrypted(curVal.getAsString());
                    config.addProperty(pd.name, decrypted);
                    break;
                }
                case OBJECT_LIST: {
                    JsonArray subValues = curVal.getAsJsonArray();
                    for (int i = 0; i < subValues.size(); ++i) {
                        JsonElement subObject = subValues.get(i);
                        if (!subObject.isJsonObject()) continue;
                        PluginConfigUtils.decryptInPlace(subObject.getAsJsonObject(), pd.subParams);
                    }
                    continue block4;
                }
            }
        }
    }

    private static void resolveCredentialRequestsInPlace(AuthCtx authCtx, JsonObject config, List<ParamDesc> descList, String pluginId, String paramSetId, String presetId) throws IOException, DKUSecurityException {
        if (descList == null || descList.size() == 0) {
            return;
        }
        for (ParamDesc pd : descList) {
            if (pd.type != ParamDesc.Type.CREDENTIAL_REQUEST) continue;
            PluginCredentialRequestService.PluginCredentialRequestInfo credentialRequestInfo = new PluginCredentialRequestService.PluginCredentialRequestInfo();
            credentialRequestInfo.pluginId = pluginId;
            credentialRequestInfo.paramSetId = paramSetId;
            credentialRequestInfo.presetId = presetId;
            credentialRequestInfo.paramName = pd.name;
            credentialRequestInfo.refreshTokenRotation = pd.credentialRequestSettings != null && pd.credentialRequestSettings.refreshTokenRotation != null && pd.credentialRequestSettings.refreshTokenRotation != false;
            credentialRequestInfo.mandatory = pd.mandatory == null || pd.mandatory != false;
            SerializablePluginParamCredentials creds = PluginConfigUtils.getFullyResolvedCredentials(authCtx, pd.name, pd.label, credentialRequestInfo);
            if (creds.missing) continue;
            if (creds.singleField != null) {
                config.addProperty(pd.name, creds.singleField);
                continue;
            }
            if (creds.basicCredential != null) {
                JsonObject credentialObject = new JsonObject();
                credentialObject.addProperty("user", creds.basicCredential.user);
                credentialObject.addProperty("password", creds.basicCredential.password);
                config.add(pd.name, (JsonElement)credentialObject);
                continue;
            }
            if (creds.accessToken == null) continue;
            if (StringUtils.isNotBlank((String)creds.idToken)) {
                config.addProperty("id_token", creds.idToken);
            }
            config.addProperty(pd.name, creds.accessToken);
        }
    }

    public static SerializablePluginParamCredentials getFullyResolvedCredentials(AuthCtx authCtx, String name, String label, PluginCredentialRequestService.PluginCredentialRequestInfo credentialRequestInfo) throws IOException, DKUSecurityException {
        MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(new PluginCredentialsRemoteFetcher(credentialRequestInfo.pluginId, credentialRequestInfo.refreshTokenRotation));
        if (rmiTo != null) {
            String userString = authCtx == null ? "n/a" : authCtx.getIdentifier();
            logger.infoV("Fetching credentials of plugin '%s' for '%s' on %s from %s", new Object[]{credentialRequestInfo.pluginId, userString, rmiTo, ApplicationConfigurator.getProcessType()});
            CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo = new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo(rmiTo);
            SerializablePluginParamCredentials creds = CredentialsRemoteFetchConfigurationProvider.getFromRemote(fetchInfo, "/plugins/get-fully-resolved-credentials", SerializablePluginParamCredentials.class, "name", name, "label", label, "credentialRequestInfo", JSON.json((Object)credentialRequestInfo));
            logger.infoV("Fetched credentials of plugin '%s' for '%s'", new Object[]{credentialRequestInfo.pluginId, userString});
            return creds;
        }
        return PluginConfigUtils.getFullyResolvedCredentials_internal(authCtx, name, label, credentialRequestInfo);
    }

    private static SerializablePluginParamCredentials getFullyResolvedCredentials_internal(AuthCtx authCtx, String name, String label, PluginCredentialRequestService.PluginCredentialRequestInfo credentialRequestInfo) throws IOException, DKUSecurityException {
        AutoCloseableLock lock = null;
        if (credentialRequestInfo != null && credentialRequestInfo.refreshTokenRotation) {
            lock = NamedLock.acquire((String)(credentialRequestInfo.getNameForCredentialMap() + " " + authCtx.toString()));
        }
        try {
            SerializablePluginParamCredentials serializablePluginParamCredentials = PluginConfigUtils.getFullyResolvedCredentials_internal2(authCtx, name, label, credentialRequestInfo, lock != null);
            return serializablePluginParamCredentials;
        }
        catch (ParseException | URISyntaxException e) {
            throw new DKUSecurityException("Unable to acquire OAuth2 access token for plugin credential request " + name + "(" + label + ")", e);
        }
        catch (DKUSecurityException e) {
            if (credentialRequestInfo == null) {
                throw e;
            }
            throw e.withPayload("pluginId", (Object)credentialRequestInfo.pluginId).withPayload("paramSetId", (Object)credentialRequestInfo.paramSetId).withPayload("presetId", (Object)credentialRequestInfo.presetId).withPayload("paramName", (Object)credentialRequestInfo.paramName).withPayload("user", (Object)authCtx.getDSSUserForImpersonation()).withPayload("sameUser", (Object)authCtx.isUserSameAsParent());
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    private static SerializablePluginParamCredentials getFullyResolvedCredentials_internal2(AuthCtx authCtx, String name, String label, PluginCredentialRequestService.PluginCredentialRequestInfo credentialRequestInfo, boolean locked) throws IOException, DKUSecurityException, URISyntaxException, ParseException {
        ICredentialsService credentialsService = (ICredentialsService)SpringUtils.getBean(ICredentialsService.class);
        PluginCredentialRequestService credentialRequestService = (PluginCredentialRequestService)SpringUtils.getBean(PluginCredentialRequestService.class);
        ICredentialsService.Credential credential = credentialsService.getDecryptedCredential_AutoTXN(authCtx, credentialRequestInfo);
        SerializablePluginParamCredentials creds = new SerializablePluginParamCredentials();
        if (credential == null) {
            creds.missing = true;
        } else if (credential instanceof ICredentialsService.SingleFieldCredential) {
            creds.singleField = ((ICredentialsService.SingleFieldCredential)credential).value;
        } else if (credential instanceof ICredentialsService.BasicCredential) {
            creds.basicCredential = (ICredentialsService.BasicCredential)credential;
        } else if (credential instanceof ICredentialsService.OAuthRefreshTokenCredential) {
            logger.info((Object)"Acquiring OAuth2 access token from refresh token");
            String refreshToken = ((ICredentialsService.OAuthRefreshTokenCredential)credential).refreshToken;
            OAuth2Client oAuth2Client = credentialRequestService.buildOAuth2AuthorizationClient(credentialRequestInfo);
            OAuth2Client.AccessTokenResult result = PerUserOAuth2Helper.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, refreshToken, false, locked, credentialRequestInfo.getNameForCredentialMap(), "plugin");
            logger.info((Object)"Successfully acquired OAuth2 access token from refresh token");
            creds.accessToken = result.getAccessToken();
            creds.idToken = result.getIdToken();
        } else {
            throw new IllegalArgumentException("Credential type not supported in plugin credential request " + name + "(" + label + ")");
        }
        return creds;
    }

    private static String handleSecretField(String field, PasswordEncryptionService cryptoService) {
        if (cryptoService != null) {
            return cryptoService.encryptIfNotEncryptedOrEmpty(field);
        }
        return HIDDEN_FIELD;
    }

    private static JsonObject handleSecretFields(JsonObject config, List<ParamDesc> descList, boolean encrypt) {
        PasswordEncryptionService cryptoService = null;
        if (encrypt) {
            cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        }
        JsonObject newConfig = (JsonObject)JSON.deepCopy((Object)config);
        for (ParamDesc pd : descList) {
            if (pd.type == ParamDesc.Type.PASSWORD && newConfig.has(pd.name)) {
                JsonElement currentValue = newConfig.get(pd.name);
                if (!PluginConfigUtils.isString(currentValue)) continue;
                newConfig.addProperty(pd.name, PluginConfigUtils.handleSecretField(currentValue.getAsString(), cryptoService));
                continue;
            }
            if (pd.type == ParamDesc.Type.CREDENTIAL_REQUEST && newConfig.has(pd.name)) {
                JsonObject settingsObject;
                JsonElement currentValue;
                JsonElement settings;
                if (pd.credentialRequestSettings == null || pd.credentialRequestSettings.type != ParamDesc.CredentialRequestType.OAUTH2 || !(settings = newConfig.get(pd.name)).isJsonObject() || (currentValue = (settingsObject = settings.getAsJsonObject()).get("clientSecret")) == null || !currentValue.isJsonPrimitive() || !currentValue.getAsJsonPrimitive().isString()) continue;
                settingsObject.addProperty("clientSecret", PluginConfigUtils.handleSecretField(currentValue.getAsString(), cryptoService));
                continue;
            }
            if (pd.type != ParamDesc.Type.OBJECT_LIST || !newConfig.has(pd.name)) continue;
            JsonElement array = newConfig.get(pd.name);
            JsonArray subValues = array.getAsJsonArray();
            for (int i = 0; i < subValues.size(); ++i) {
                JsonElement subObject = subValues.get(i);
                if (!subObject.isJsonObject()) continue;
                subValues.set(i, (JsonElement)PluginConfigUtils.handleSecretFields(subObject.getAsJsonObject(), pd.subParams, encrypt));
            }
        }
        return newConfig;
    }

    public static String jsonNoPasswords(JsonObject config, List<ParamDesc> descList) {
        return JSON.json((Object)PluginConfigUtils.handleSecretFields(config, descList, false));
    }

    public static JsonObject setDefaultValues(List<? extends ParamDesc> params, JsonObject orig) {
        assert (orig != null);
        if (params != null) {
            block12: for (ParamDesc paramDesc : params) {
                if (orig.has(paramDesc.name)) continue;
                if (paramDesc.defaultValue != null) {
                    switch (paramDesc.type) {
                        case BOOLEAN: {
                            orig.addProperty(paramDesc.name, PluginConfigUtils.castOrDefault(paramDesc.defaultValue, Boolean.class::cast, Boolean.class, () -> false));
                            continue block12;
                        }
                        case INT: 
                        case DOUBLE: {
                            orig.addProperty(paramDesc.name, PluginConfigUtils.castOrDefault(paramDesc.defaultValue, Number.class::cast, Number.class, () -> 0));
                            continue block12;
                        }
                        case MAP: {
                            orig.add(paramDesc.name, (JsonElement)PluginConfigUtils.castOrDefault(paramDesc.defaultValue, JSON::toJsonObject, JsonObject.class, JsonObject::new));
                            continue block12;
                        }
                        case STRINGS: 
                        case KEY_VALUE_LIST: 
                        case OBJECT_LIST: 
                        case ARRAY: 
                        case DOUBLES: 
                        case MULTISELECT: {
                            orig.add(paramDesc.name, (JsonElement)PluginConfigUtils.castOrDefault(paramDesc.defaultValue, JSON::toJsonArray, JsonArray.class, JsonArray::new));
                            continue block12;
                        }
                    }
                    orig.addProperty(paramDesc.name, paramDesc.defaultValue.toString());
                    continue;
                }
                switch (paramDesc.type) {
                    case BOOLEAN: {
                        orig.addProperty(paramDesc.name, Boolean.valueOf(false));
                        break;
                    }
                    case INT: 
                    case DOUBLE: {
                        orig.addProperty(paramDesc.name, (Number)0);
                        break;
                    }
                    case MAP: {
                        orig.add(paramDesc.name, (JsonElement)new JsonObject());
                        break;
                    }
                    case KEY_VALUE_LIST: 
                    case OBJECT_LIST: {
                        orig.add(paramDesc.name, (JsonElement)new JsonArray());
                        break;
                    }
                }
            }
        }
        return orig;
    }

    public static JsonObject removeOutdatedKeys(List<? extends ParamDesc> params, JsonObject orig) {
        assert (orig != null);
        JsonObject copy = orig.deepCopy();
        if (params != null) {
            for (String key : orig.keySet()) {
                if (!params.stream().filter(p -> Objects.equals(p.name, key)).findAny().isEmpty()) continue;
                copy.remove(key);
            }
        }
        return copy;
    }

    public static List<PluginPreset> removeOutdatedKeysInPresets(List<LoadedParameterSet> parameterSets, List<PluginPreset> presets) {
        ArrayList<PluginPreset> presetCopy = new ArrayList<PluginPreset>();
        for (PluginPreset preset : presets) {
            Optional<LoadedParameterSet> maybeParameterSet = parameterSets.stream().filter(set -> Objects.equals(set.getType(), preset.type)).findAny();
            if (maybeParameterSet.isEmpty()) continue;
            LoadedParameterSet parameterSet = maybeParameterSet.get();
            PluginPreset updatedPreset = (PluginPreset)JSON.deepCopy((Object)preset);
            updatedPreset.config = PluginConfigUtils.removeOutdatedKeys(parameterSet.desc.params, preset.config);
            updatedPreset.pluginConfig = PluginConfigUtils.removeOutdatedKeys(parameterSet.desc.pluginParams, preset.pluginConfig);
            presetCopy.add(updatedPreset);
        }
        return presetCopy;
    }

    public static void setDefaultParameterSetPermissions(InstalledPluginDesc desc, PluginSettings settings) {
        for (LoadedParameterSet parameterSetDesc : desc.customParameterSets) {
            boolean found = false;
            for (ParameterSetSettings parameterSetSettings : settings.parameterSets) {
                if (!StringUtils.equals((String)parameterSetSettings.name, (String)parameterSetDesc.id)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ParameterSetSettings parameterSet = new ParameterSetSettings();
            parameterSet.name = parameterSetDesc.id;
            parameterSet.defaultPermission = new ParameterSetSettings.PermissionItem();
            parameterSet.permissions = Lists.newArrayList();
            parameterSet.defaultPermission.definableInline = parameterSetDesc.desc.defaultDefinableInline;
            parameterSet.defaultPermission.definableAtProjectLevel = parameterSetDesc.desc.defaultDefinableAtProjectLevel;
            settings.parameterSets.add(parameterSet);
        }
    }

    static JsonObject encryptParameters(JsonObject config, List<ParamDesc> descList) {
        return JSON.toJsonObject((Object)PluginConfigUtils.handleSecretFields(config, descList, true));
    }

    private static List<ParamDesc> makeSubParamsForKeyValue() {
        return Lists.newArrayList((Object[])new ParamDesc[]{new ParamDesc("from", ParamDesc.Type.STRING), new ParamDesc("to", ParamDesc.Type.STRING)});
    }

    private static boolean isString(JsonElement element) {
        return element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isString();
    }

    private static <T> T castOrDefault(Object value, Function<Object, T> castFunction, Class<T> clazzToCast, Supplier<T> defaultValueSupplier) {
        try {
            return castFunction.apply(value);
        }
        catch (Exception e) {
            T defaultValue = defaultValueSupplier.get();
            logger.warnV("Plugin contains a default value '%s' that does not match the required type '%s'. Using default value '%s' instead.", new Object[]{value, clazzToCast.getName(), defaultValue});
            return defaultValue;
        }
    }

    public static class SerializablePluginParamCredentials {
        public boolean missing;
        public String singleField;
        public ICredentialsService.BasicCredential basicCredential;
        public String accessToken;
        public String idToken;
    }

    private static class PluginCredentialsRemoteFetcher
    implements CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetcher {
        private String pluginId;
        private final boolean refreshTokenRotation;

        PluginCredentialsRemoteFetcher(String pluginId, boolean refreshTokenRotation) {
            this.pluginId = pluginId;
            this.refreshTokenRotation = refreshTokenRotation;
        }

        @Override
        public boolean forceLocalResolution() {
            return false;
        }

        @Override
        public boolean mustResolveOnDSSHost() {
            return false;
        }

        @Override
        public boolean mustResolveOnBackend() {
            if (this.refreshTokenRotation) {
                return true;
            }
            Params params = ApplicationConfigurator.getParams();
            return params.getBoolParam("dip.plugins." + this.pluginId + ".resolveCredentialsOnBackend", params.getBoolParam("dip.plugins.resolveCredentialsOnBackend", false));
        }
    }
}

