/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.PluginEntryPoint;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolsService;
import com.dataiku.dip.agents.tools.custom.LoadedCustomAgentTool;
import com.dataiku.dip.analysis.ml.prediction.CustomPythonPredictionAlgoService;
import com.dataiku.dip.analysis.ml.prediction.LoadedCustomPythonPredictionAlgoDesc;
import com.dataiku.dip.cluster.LoadedPythonPluginCluster;
import com.dataiku.dip.cluster.PythonPluginClustersService;
import com.dataiku.dip.codestudio.blocks.component.LoadedPythonPluginCodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockService;
import com.dataiku.dip.codestudio.component.LoadedPythonPluginCodeStudioTemplate;
import com.dataiku.dip.codestudio.component.PythonPluginCodeStudioTemplateService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomJavaPolicyHooksService;
import com.dataiku.dip.cuspol.LoadedCustomFieldsDesc;
import com.dataiku.dip.cuspol.LoadedJavaPolicyHooks;
import com.dataiku.dip.dataflow.kernel.master.BuildService;
import com.dataiku.dip.datasets.custompython.CustomDatasetDesc;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.LoadedFSProvider;
import com.dataiku.dip.datasets.sample.LoadedSampleDataset;
import com.dataiku.dip.datasets.sample.SampleDatasetsService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.export.CustomExporterDesc;
import com.dataiku.dip.export.CustomJavaExportersService;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.export.LoadedExporter;
import com.dataiku.dip.exposition.custom.CustomExpositionsService;
import com.dataiku.dip.exposition.custom.LoadedExposition;
import com.dataiku.dip.formats.custom.CustomFormatDesc;
import com.dataiku.dip.formats.custom.CustomJavaFormatsService;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.formats.custom.LoadedFormat;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.llm.custom.CustomJavaLLMDesc;
import com.dataiku.dip.llm.custom.CustomJavaLLMsService;
import com.dataiku.dip.llm.custom.CustomPythonLLMDesc;
import com.dataiku.dip.llm.custom.CustomPythonLLMsService;
import com.dataiku.dip.llm.custom.LoadedJavaLLM;
import com.dataiku.dip.llm.custom.LoadedPythonLLM;
import com.dataiku.dip.llm.governance.custom.CustomGuardrailsService;
import com.dataiku.dip.llm.governance.custom.LoadedCustomGuardrail;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.metrics.checks.CustomPythonChecksService;
import com.dataiku.dip.metrics.checks.LoadedPythonCheck;
import com.dataiku.dip.metrics.probes.CustomPythonProbesService;
import com.dataiku.dip.metrics.probes.CustomSQLProbesService;
import com.dataiku.dip.metrics.probes.LoadedPythonProbe;
import com.dataiku.dip.metrics.probes.LoadedSQLProbe;
import com.dataiku.dip.notebooks.NotebooksTemplatesService;
import com.dataiku.dip.plugins.CustomJavaDatasetsService;
import com.dataiku.dip.plugins.CustomPythonDatasetsService;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.LoadedCustomDataset;
import com.dataiku.dip.plugins.PluginRequirementService;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.plugins.exceptions.DuplicatePluginException;
import com.dataiku.dip.plugins.model.ComputedPluginContent;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.InstalledPluginState;
import com.dataiku.dip.plugins.model.PluginDesc;
import com.dataiku.dip.plugins.presets.LoadedParameterSet;
import com.dataiku.dip.plugins.presets.PluginParameterSetsService;
import com.dataiku.dip.projects.Desc;
import com.dataiku.dip.projects.TutorialsService;
import com.dataiku.dip.projects.apps.CustomAppTemplatesService;
import com.dataiku.dip.projects.apps.LoadedCustomAppTemplate;
import com.dataiku.dip.projectstandards.component.LoadedPythonPluginProjectStandardsCheckSpec;
import com.dataiku.dip.projectstandards.component.PythonPluginProjectStandardsService;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.reports.ReportsTemplateService;
import com.dataiku.dip.savedmodels.agents.CustomAgentsService;
import com.dataiku.dip.savedmodels.agents.LoadedCustomAgent;
import com.dataiku.dip.scheduler.runnables.CustomJavaRunnablesService;
import com.dataiku.dip.scheduler.runnables.CustomPythonRunnablesService;
import com.dataiku.dip.scheduler.runnables.DSSRunnableDesc;
import com.dataiku.dip.scheduler.runnables.LoadedRunnable;
import com.dataiku.dip.scheduler.steps.LoadedPythonPluginStep;
import com.dataiku.dip.scheduler.steps.PythonPluginStepsService;
import com.dataiku.dip.scheduler.triggers.LoadedPythonPluginTrigger;
import com.dataiku.dip.scheduler.triggers.PythonPluginTriggersService;
import com.dataiku.dip.security.auth.custom.CustomJavaUserAuthenticatorAndSupplierService;
import com.dataiku.dip.security.auth.custom.CustomJavaUserAuthenticatorService;
import com.dataiku.dip.security.auth.custom.CustomJavaUserSupplierService;
import com.dataiku.dip.security.auth.custom.LoadedJavaUserAuthenticator;
import com.dataiku.dip.security.auth.custom.LoadedJavaUserAuthenticatorAndSupplier;
import com.dataiku.dip.security.auth.custom.LoadedJavaUserSupplier;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.GRELFunctionsLoader;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorsService;
import com.dataiku.dip.shaker.processors.udf.LoadedJythonProcessor;
import com.dataiku.dip.sql.CustomJavaDialectsService;
import com.dataiku.dip.sql.LoadedJavaDialect;
import com.dataiku.dip.util.DKUExecutors;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.TestFlag;
import com.dataiku.dip.webapps.WebAppsTemplatesService;
import com.dataiku.dip.webapps.plugins.CustomWebAppsService;
import com.dataiku.dip.webapps.plugins.LoadedCustomWebApp;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PluginsLoadService {
    @Autowired
    private NotebooksTemplatesService notebooksTemplatesService;
    @Autowired
    private WebAppsTemplatesService webAppsTemplatesService;
    @Autowired
    private ReportsTemplateService reportsTemplatesService;
    @Autowired
    private CustomCodeRecipesService recipesService;
    @Autowired
    private CustomPythonDatasetsService customPythonDatasetsService;
    @Autowired
    private CustomJavaDatasetsService customJavaDatasetsService;
    @Autowired
    private CustomPythonProbesService pythonProbesService;
    @Autowired
    private CustomPythonExportersService customPythonExporterService;
    @Autowired
    private CustomJavaExportersService customJavaExporterService;
    @Autowired
    private CustomPythonChecksService pythonChecksService;
    @Autowired
    private CustomSQLProbesService sqlProbesService;
    @Autowired
    private CustomPythonFormatsService customPythonFormatsService;
    @Autowired
    private CustomJavaFormatsService customJavaFormatsService;
    @Autowired
    private PythonPluginStepsService pythonPluginStepsService;
    @Autowired
    private PythonPluginTriggersService pythonPluginTriggersService;
    @Autowired
    private CustomPythonRunnablesService customPythonRunnablesService;
    @Autowired
    private CustomWebAppsService customWebAppsService;
    @Autowired
    private CustomAgentsService customAgentsService;
    @Autowired
    private CustomAgentToolsService customAgentToolsService;
    @Autowired
    private CustomGuardrailsService customGuardrailsService;
    @Autowired
    private CustomJavaRunnablesService customJavaRunnablesService;
    @Autowired
    private CustomPythonFSProvidersService customPythonFSProvidersService;
    @Autowired
    private CustomJavaFSProvidersService customJavaFSProvidersService;
    @Autowired
    private CustomJavaDialectsService customJavaDialectsService;
    @Autowired
    private CustomJythonProcessorsService customJythonProcessorsService;
    @Autowired
    private PythonPluginClustersService pythonPluginClustersService;
    @Autowired
    private PluginParameterSetsService pluginPresetsService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private CustomPythonPredictionAlgoService customPythonPredictionAlgoService;
    @Autowired
    private CustomJavaPolicyHooksService customJavaPolicyHooksService;
    @Autowired
    private CustomJavaUserSupplierService customJavaUserSupplierService;
    @Autowired
    private CustomJavaUserAuthenticatorService customJavaUserAuthenticatorService;
    @Autowired
    private CustomJavaUserAuthenticatorAndSupplierService customJavaUserAuthenticatorAndSupplierService;
    @Autowired
    private CustomAppTemplatesService customAppTemplatesService;
    @Autowired
    private CustomExpositionsService customWebAppExpositionsService;
    @Autowired
    private CustomJavaLLMsService customJavaLLMsService;
    @Autowired
    private CustomPythonLLMsService customPythonLLMsService;
    @Autowired
    private PythonPluginCodeStudioTemplateService pythonPluginCodeStudioTemplateService;
    @Autowired
    private PythonPluginCodeStudioBlockService pythonPluginCodeStudioBlockService;
    @Autowired
    private PythonPluginProjectStandardsService pythonPluginProjectStandardsService;
    @Autowired
    private SampleDatasetsService sampleDatasetsService;
    @Autowired
    private RegularPluginsRegistryService registryService;
    private static File baseDir;
    private static File baseDevDir;
    private static File baseBuiltinDir;
    @VisibleForTesting
    public static final TestFlag skipLoadPlugins;
    private static Logger logger;

    @PostConstruct
    public void autoLoad() {
        if (skipLoadPlugins.isActivated()) {
            return;
        }
        logger.info((Object)"Init plugin service");
        baseDir = ApplicationConfigurator.getFile((String[])new String[]{"plugins", "installed"});
        baseDevDir = ApplicationConfigurator.getFile((String[])new String[]{"plugins", "dev"});
        baseBuiltinDir = ApplicationConfigurator.getPreInstalledPluginsFolder();
        if (FeatureFlags.isEnabled((String)"NO_PLUGINS")) {
            logger.info((Object)"No plugins mode enabled, not loading plugins");
            return;
        }
        if (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.JEK) {
            return;
        }
        List<PluginLoader> toLoad = this.createAllPluginsLoader();
        for (PluginLoader loader : toLoad) {
            loader.run();
        }
        logger.debug((Object)"Done init plugins service");
    }

    private List<PluginLoader> createAllPluginsLoader() {
        ArrayList<PluginLoader> toLoad = new ArrayList<PluginLoader>();
        toLoad.addAll(this.loadFromDirectory(baseDir, InstalledPluginDesc.PluginOrigin.INSTALLED, false));
        toLoad.addAll(this.loadFromDirectory(baseDevDir, InstalledPluginDesc.PluginOrigin.DEV, false));
        toLoad.addAll(this.loadFromDirectory(baseBuiltinDir, InstalledPluginDesc.PluginOrigin.BUILTIN, false));
        return toLoad;
    }

    public void loadPluginsAsync(DKUExecutors.DKUExecutor executor) {
        logger.info((Object)"Loading plugins asynchronously");
        for (PluginLoader loader : this.createAllPluginsLoader()) {
            executor.submit(loader);
        }
    }

    private List<PluginLoader> loadFromDirectory(File dir, InstalledPluginDesc.PluginOrigin origin, boolean reload) {
        ArrayList<PluginLoader> toLoad = new ArrayList<PluginLoader>();
        if (dir.isDirectory()) {
            File[] pluginDirs = dir.listFiles();
            if (pluginDirs == null) {
                return toLoad;
            }
            Arrays.sort(pluginDirs, new Comparator<File>(){

                @Override
                public int compare(File a, File b) {
                    return a.getName().compareTo(b.getName());
                }
            });
            String dipHome = DKUApp.getBaseFolder();
            String pluginDirsStr = Arrays.stream(pluginDirs).map(f -> f.getAbsolutePath().replace(dipHome, "DATADIR")).collect(Collectors.joining(","));
            logger.info((Object)("Loading plugins from " + pluginDirsStr));
            for (File pluginDir : pluginDirs) {
                File descFile;
                if (!pluginDir.isDirectory() || !(descFile = new File(pluginDir, "plugin.json")).exists()) continue;
                toLoad.add(new PluginLoader(pluginDir, origin, reload));
            }
        }
        return toLoad;
    }

    public void reloadDevPlugins() {
        logger.info((Object)"Reloading plugins");
        ArrayList<PluginLoader> toLoad = new ArrayList<PluginLoader>();
        toLoad.addAll(this.loadFromDirectory(baseDevDir, InstalledPluginDesc.PluginOrigin.DEV, true));
        if (System.getenv("DSS_DEV") != null) {
            toLoad.addAll(this.loadFromDirectory(baseDir, InstalledPluginDesc.PluginOrigin.INSTALLED, true));
            toLoad.addAll(this.loadFromDirectory(baseBuiltinDir, InstalledPluginDesc.PluginOrigin.BUILTIN, true));
        }
        for (PluginLoader loader : toLoad) {
            loader.run();
        }
        this.invalidateKernels();
    }

    public InstalledPluginDesc loadAfterStartup(String pluginId) throws Exception {
        File metaFile;
        logger.info((Object)("(Re)Loading plugin '" + pluginId + "'"));
        File pluginDir = new File(baseDir, pluginId);
        File pluginDevDir = new File(baseDevDir, pluginId);
        File pluginBuiltinDir = new File(baseBuiltinDir, pluginId);
        InstalledPluginDesc desc = null;
        if (pluginDir.isDirectory()) {
            File metaFile2 = new File(pluginDir, "plugin.json");
            if (metaFile2.exists()) {
                desc = this.loadPlugin(pluginDir, false, InstalledPluginDesc.PluginOrigin.INSTALLED, true);
            }
        } else if (pluginDevDir.isDirectory()) {
            File metaFile3 = new File(pluginDevDir, "plugin.json");
            if (metaFile3.exists()) {
                desc = this.loadPlugin(pluginDevDir, false, InstalledPluginDesc.PluginOrigin.DEV, true);
            }
        } else if (pluginBuiltinDir.isDirectory() && (metaFile = new File(pluginBuiltinDir, "plugin.json")).exists()) {
            desc = this.loadPlugin(pluginDevDir, false, InstalledPluginDesc.PluginOrigin.BUILTIN, true);
        }
        if (desc == null) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Did not find plugin " + pluginId);
        }
        this.invalidateKernels();
        return desc;
    }

    public boolean needsRestart(PluginDesc desc) {
        return !StringUtils.isBlank((String)desc.entryPoint) || desc.javaPreparationProcessors.size() > 0 || desc.javaFormulaFunctions.size() > 0;
    }

    private void invalidateKernels() {
        BuildService buildService = (BuildService)SpringUtils.getBean(BuildService.class);
        buildService.invalidateKernels();
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        futureService.invalidateKernels();
    }

    public void reloadPlugin(String pluginId) throws Exception {
        this.unloadPlugin(pluginId);
        this.loadAfterStartup(pluginId);
    }

    public Collection<InstalledPluginDesc> getLoadedPlugins() {
        this.cleanupRemovedPlugins();
        return this.registryService.getLoadedPlugins();
    }

    private void cleanupRemovedPlugins() {
        HashSet loaded = Sets.newHashSet();
        loaded.addAll(this.getExistingPlugins(baseDir));
        loaded.addAll(this.getExistingPlugins(baseDevDir));
        loaded.addAll(this.getExistingPlugins(baseBuiltinDir));
        HashSet toRemove = Sets.newHashSet();
        for (String pluginId : this.registryService.getLoadedPluginIds()) {
            if (loaded.contains(pluginId)) continue;
            logger.info((Object)("The plugin " + pluginId + " has been removed from disk."));
            toRemove.add(pluginId);
        }
        for (String pluginId : toRemove) {
            this.registryService.unregister(pluginId);
        }
    }

    private Set<String> getExistingPlugins(File dir) {
        HashSet loaded = Sets.newHashSet();
        if (dir.isDirectory()) {
            File[] pluginDirs = dir.listFiles();
            if (pluginDirs == null) {
                return loaded;
            }
            for (File pluginDir : pluginDirs) {
                File descFile;
                if (!pluginDir.isDirectory() || !(descFile = new File(pluginDir, "plugin.json")).exists()) continue;
                loaded.add(pluginDir.getName());
            }
        }
        return loaded;
    }

    private File getStateFile(InstalledPluginDesc installedDesc) {
        String pluginId = installedDesc.desc.id;
        File pluginDir = RegularPluginsRegistryService.getPluginFolder(installedDesc.origin, pluginId);
        return new File(pluginDir, "state.json");
    }

    public static void addPluginAction(InstalledPluginDesc installedDesc, InstalledPluginState.PluginActionRecord action) throws IOException {
        File stateFile = ((PluginsLoadService)SpringUtils.getBean(PluginsLoadService.class)).getStateFile(installedDesc);
        InstalledPluginState state = stateFile.exists() ? (InstalledPluginState)JSON.parseFile((File)stateFile, InstalledPluginState.class) : new InstalledPluginState();
        state.actions.add(action);
        JSON.prettyToFile((Object)state, (File)stateFile);
    }

    private void unregisterPlugin(String pluginId) {
        this.recipesService.removeComponentTypeForOnePlugin(pluginId);
        this.customPythonDatasetsService.removeComponentTypeForOnePlugin(pluginId);
        this.customJavaDatasetsService.removeComponentTypeForOnePlugin(pluginId);
        this.pythonProbesService.removeComponentTypeForOnePlugin(pluginId);
        this.pythonChecksService.removeComponentTypeForOnePlugin(pluginId);
        this.sqlProbesService.removeComponentTypeForOnePlugin(pluginId);
        this.customPythonFormatsService.removeComponentTypeForOnePlugin(pluginId);
        this.customJavaFormatsService.removeComponentTypeForOnePlugin(pluginId);
        this.customPythonExporterService.removeComponentTypeForOnePlugin(pluginId);
        this.customJavaExporterService.removeComponentTypeForOnePlugin(pluginId);
        this.pythonPluginStepsService.removeComponentTypeForOnePlugin(pluginId);
        this.pythonPluginTriggersService.removeComponentTypeForOnePlugin(pluginId);
        this.customPythonRunnablesService.removeComponentTypeForOnePlugin(pluginId);
        this.customJavaRunnablesService.removeComponentTypeForOnePlugin(pluginId);
        this.customWebAppsService.removeComponentTypeForOnePlugin(pluginId);
        this.customAgentsService.removeComponentTypeForOnePlugin(pluginId);
        this.customAgentToolsService.removeComponentTypeForOnePlugin(pluginId);
        this.customGuardrailsService.removeComponentTypeForOnePlugin(pluginId);
        this.customPythonFSProvidersService.removeComponentTypeForOnePlugin(pluginId);
        this.customJavaFSProvidersService.removeComponentTypeForOnePlugin(pluginId);
        this.customJavaDialectsService.removeComponentTypeForOnePlugin(pluginId);
        this.customJythonProcessorsService.removeComponentTypeForOnePlugin(pluginId);
        this.pythonPluginClustersService.removeComponentTypeForOnePlugin(pluginId);
        this.pluginPresetsService.removeComponentTypeForOnePlugin(pluginId);
        this.customFieldsService.removeComponentTypeForOnePlugin(pluginId);
        this.customJavaPolicyHooksService.removeComponentTypeForOnePlugin(pluginId);
        this.customJavaUserSupplierService.removeComponentTypeForOnePlugin(pluginId);
        this.customJavaUserAuthenticatorService.removeComponentTypeForOnePlugin(pluginId);
        this.customJavaUserAuthenticatorAndSupplierService.removeComponentTypeForOnePlugin(pluginId);
        this.customWebAppExpositionsService.removeComponentTypeForOnePlugin(pluginId);
        this.customPythonPredictionAlgoService.removeComponentTypeForOnePlugin(pluginId);
        this.customAppTemplatesService.removeComponentTypeForOnePlugin(pluginId);
        this.pythonPluginCodeStudioTemplateService.removeComponentTypeForOnePlugin(pluginId);
        this.pythonPluginCodeStudioBlockService.removeComponentTypeForOnePlugin(pluginId);
        this.pythonPluginProjectStandardsService.removeComponentTypeForOnePlugin(pluginId);
        this.sampleDatasetsService.removeComponentTypeForOnePlugin(pluginId);
    }

    private InstalledPluginDesc loadPlugin(File pluginDir, boolean executeJavaComponents, InstalledPluginDesc.PluginOrigin origin, boolean reload) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Loading plugin from " + String.valueOf(pluginDir)));
        }
        String pluginId = pluginDir.getName();
        if (!reload) {
            this.registryService.checkNotRegistered(pluginId);
        }
        InstalledPluginDesc installationDesc = new InstalledPluginDesc();
        installationDesc.origin = origin;
        File descFile = new File(pluginDir, "plugin.json");
        installationDesc.desc = (PluginDesc)JSON.parseFile((File)descFile, PluginDesc.class);
        if (StringUtils.isBlank((String)installationDesc.desc.id)) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_INVALID_DEFINITION, "Plugin: '" + pluginId + "' has no 'id' field in its descriptor (plugin.json)");
        }
        if (!installationDesc.desc.id.equals(pluginId)) {
            String msg = String.format("Mismatch with 'id' field in plugin.json: '%s' instead of expected '%s'", installationDesc.desc.id, pluginId);
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_INVALID_DEFINITION, msg);
        }
        File stateFile = this.getStateFile(installationDesc);
        InstalledPluginState pluginState = stateFile.exists() ? (InstalledPluginState)JSON.parseFile((File)stateFile, InstalledPluginState.class) : new InstalledPluginState();
        installationDesc.gitState = pluginState.gitState;
        try {
            PluginRequirementService pluginRequirementService = (PluginRequirementService)SpringUtils.getBean(PluginRequirementService.class);
            installationDesc.requirementsSpec = pluginRequirementService.getRequirementsSpec(pluginDir, installationDesc.loadingFailures);
            installationDesc.codeEnvSpec = pluginRequirementService.getCodeEnvDesc(pluginDir, installationDesc.loadingFailures);
            installationDesc.codeEnvLang = pluginRequirementService.getCodeEnvLang(pluginDir);
            installationDesc.frontendRequirements = pluginRequirementService.resolveRequirements(pluginId, installationDesc.requirementsSpec, installationDesc.codeEnvLang, pluginState, origin);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.info((Object)("In Spark driver, not loading requirements (" + ExceptionUtils.getMessageWithCauses((Throwable)e) + ")"));
        }
        this.registryService.register(pluginId, installationDesc);
        installationDesc.customCodeRecipes = this.recipesService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customCodeRecipes", installationDesc.loadingFailures);
        installationDesc.customDatasets.addAll(this.customPythonDatasetsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customDatasets", installationDesc.loadingFailures));
        installationDesc.customDatasets.addAll(this.customJavaDatasetsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customDatasets", installationDesc.loadingFailures));
        installationDesc.customPythonProbes = this.pythonProbesService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customPythonProbes", installationDesc.loadingFailures);
        installationDesc.customPythonChecks = this.pythonChecksService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customPythonChecks", installationDesc.loadingFailures);
        installationDesc.customSQLProbes = this.sqlProbesService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customSQLProbes", installationDesc.loadingFailures);
        installationDesc.customFormats.addAll(this.customPythonFormatsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customFormats", installationDesc.loadingFailures));
        installationDesc.customFormats.addAll(this.customJavaFormatsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customFormats", installationDesc.loadingFailures));
        installationDesc.customExporters.addAll(this.customPythonExporterService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customExporters", installationDesc.loadingFailures));
        installationDesc.customExporters.addAll(this.customJavaExporterService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customExporters", installationDesc.loadingFailures));
        installationDesc.customPythonSteps.addAll(this.pythonPluginStepsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customPythonSteps", installationDesc.loadingFailures));
        installationDesc.customPythonTriggers.addAll(this.pythonPluginTriggersService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customPythonTriggers", installationDesc.loadingFailures));
        installationDesc.customRunnables.addAll(this.customPythonRunnablesService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customRunnables", installationDesc.loadingFailures));
        installationDesc.customRunnables.addAll(this.customJavaRunnablesService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customRunnables", installationDesc.loadingFailures));
        installationDesc.customWebApps.addAll(this.customWebAppsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customWebApps", installationDesc.loadingFailures));
        installationDesc.customAgents.addAll(this.customAgentsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customAgents", installationDesc.loadingFailures));
        installationDesc.customAgentTools.addAll(this.customAgentToolsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customAgentTools", installationDesc.loadingFailures));
        installationDesc.customGuardrails.addAll(this.customGuardrailsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customGuardrails", installationDesc.loadingFailures));
        installationDesc.customFSProviders.addAll(this.customPythonFSProvidersService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customFSProviders", installationDesc.loadingFailures));
        installationDesc.customFSProviders.addAll(this.customJavaFSProvidersService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customFSProviders", installationDesc.loadingFailures));
        installationDesc.customDialects.addAll(this.customJavaDialectsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customDialects", installationDesc.loadingFailures));
        installationDesc.customJythonProcessors.addAll(this.customJythonProcessorsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customJythonProcessors", installationDesc.loadingFailures));
        installationDesc.customPythonClusters.addAll(this.pythonPluginClustersService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customPythonClusters", installationDesc.loadingFailures));
        installationDesc.customParameterSets.addAll(this.pluginPresetsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "presets", installationDesc.loadingFailures));
        installationDesc.customFields.addAll(this.customFieldsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customFields", installationDesc.loadingFailures));
        installationDesc.customJavaPolicyHooks.addAll(this.customJavaPolicyHooksService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customPolicyHooks", installationDesc.loadingFailures));
        installationDesc.customJavaUserSupplier.addAll(this.customJavaUserSupplierService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customUserSupplier", installationDesc.loadingFailures));
        installationDesc.customJavaUserAuthenticator.addAll(this.customJavaUserAuthenticatorService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customUserAuthenticator", installationDesc.loadingFailures));
        installationDesc.customJavaUserAuthenticatorAndSupplier.addAll(this.customJavaUserAuthenticatorAndSupplierService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customUserAuthenticatorAndSupplier", installationDesc.loadingFailures));
        installationDesc.customExpositions.addAll(this.customWebAppExpositionsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customWebAppExpositions", installationDesc.loadingFailures));
        installationDesc.customJavaLLMs.addAll(this.customJavaLLMsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customJavaLLMs", installationDesc.loadingFailures));
        installationDesc.customPythonLLMs.addAll(this.customPythonLLMsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customPythonLLMs", installationDesc.loadingFailures));
        installationDesc.customPythonPredictionAlgos.addAll(this.customPythonPredictionAlgoService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customAlgos", installationDesc.loadingFailures));
        installationDesc.customAppTemplates.addAll(this.customAppTemplatesService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customAppTemplates", installationDesc.loadingFailures));
        installationDesc.customPythonCodeStudioTemplates.addAll(this.pythonPluginCodeStudioTemplateService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customPythonCodeStudioTemplates", installationDesc.loadingFailures));
        installationDesc.customPythonCodeStudioBlocks.addAll(this.pythonPluginCodeStudioBlockService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customPythonCodeStudioBlocks", installationDesc.loadingFailures));
        installationDesc.customPythonProjectStandardsCheckSpecs.addAll(this.pythonPluginProjectStandardsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customPythonProjectStandardsCheckSpecs", installationDesc.loadingFailures));
        installationDesc.customSampleDatasets.addAll(this.sampleDatasetsService.reloadComponentTypeForOnePlugin(pluginId, pluginDir, "customSampleDatasets", installationDesc.loadingFailures));
        if (executeJavaComponents) {
            boolean hasJava = false;
            if (installationDesc.desc.entryPoint != null && installationDesc.desc.entryPoint.trim().length() > 0) {
                hasJava = true;
                logger.info((Object)("Executing entry point " + installationDesc.desc.entryPoint));
                Iterator<Object> entryPoint = (PluginEntryPoint)Class.forName(installationDesc.desc.entryPoint).newInstance();
                ((PluginEntryPoint)((Object)entryPoint)).setPluginId(pluginId);
                ((PluginEntryPoint)((Object)entryPoint)).load();
            }
            boolean bl = installationDesc.desc.javaFormulaFunctions.size() > 0;
            GRELFunctionsLoader.loadFromPlugin(installationDesc);
            if (hasJava |= bl) {
                logger.info((Object)"Java plugin activated");
            }
        }
        ComputedPluginContent computedContent = new ComputedPluginContent();
        for (LoadedCustomCodeRecipeDesc loadedCustomCodeRecipeDesc : installationDesc.customCodeRecipes) {
            computedContent.customCodeRecipes.add(new ComputedPluginContent.ContributionWithId(loadedCustomCodeRecipeDesc.id, loadedCustomCodeRecipeDesc.desc.meta, loadedCustomCodeRecipeDesc.folderName));
        }
        for (LoadedCustomDataset loadedCustomDataset : installationDesc.customDatasets) {
            computedContent.customDatasets.add(new ComputedPluginContent.ContributionWithId(loadedCustomDataset.id, ((CustomDatasetDesc)loadedCustomDataset.desc).meta, loadedCustomDataset.folderName));
        }
        for (LoadedExporter loadedExporter : installationDesc.customExporters) {
            computedContent.customExporters.add(new ComputedPluginContent.ContributionWithId(loadedExporter.id, ((CustomExporterDesc)loadedExporter.desc).meta, loadedExporter.folderName));
        }
        for (LoadedFormat<?> loadedFormat : installationDesc.customFormats) {
            computedContent.customFormats.add(new ComputedPluginContent.ContributionWithId(loadedFormat.id, ((CustomFormatDesc)loadedFormat.desc).meta, loadedFormat.folderName));
        }
        for (LoadedPythonCheck loadedPythonCheck : installationDesc.customPythonChecks) {
            computedContent.customPythonChecks.add(new ComputedPluginContent.ContributionWithId(loadedPythonCheck.id, loadedPythonCheck.desc.meta, loadedPythonCheck.folderName));
        }
        for (LoadedPythonProbe loadedPythonProbe : installationDesc.customPythonProbes) {
            computedContent.customPythonProbes.add(new ComputedPluginContent.ContributionWithId(loadedPythonProbe.id, loadedPythonProbe.desc.meta, loadedPythonProbe.folderName));
        }
        for (LoadedSQLProbe loadedSQLProbe : installationDesc.customSQLProbes) {
            computedContent.customSQLProbes.add(new ComputedPluginContent.ContributionWithId(loadedSQLProbe.id, loadedSQLProbe.desc.meta, loadedSQLProbe.folderName));
        }
        for (PluginDesc.JavaContributionDesc javaContributionDesc : installationDesc.desc.javaPreparationProcessors) {
            computedContent.javaPreparationProcessors.add(new ComputedPluginContent.ContributionWithId(javaContributionDesc.id, javaContributionDesc.meta, null));
        }
        for (PluginDesc.JavaFormulaFunction javaFormulaFunction : installationDesc.desc.javaFormulaFunctions) {
            computedContent.javaFormulaFunctions.add(new ComputedPluginContent.ContributionWithId(javaFormulaFunction.functionName, javaFormulaFunction.meta, null));
        }
        for (LoadedPythonPluginStep loadedPythonPluginStep : installationDesc.customPythonSteps) {
            computedContent.customPythonSteps.add(new ComputedPluginContent.ContributionWithId(loadedPythonPluginStep.id, loadedPythonPluginStep.desc.meta, loadedPythonPluginStep.folderName));
        }
        for (LoadedPythonPluginTrigger loadedPythonPluginTrigger : installationDesc.customPythonTriggers) {
            computedContent.customPythonTriggers.add(new ComputedPluginContent.ContributionWithId(loadedPythonPluginTrigger.id, loadedPythonPluginTrigger.desc.meta, loadedPythonPluginTrigger.folderName));
        }
        for (LoadedRunnable loadedRunnable : installationDesc.customRunnables) {
            computedContent.customRunnables.add(new ComputedPluginContent.ContributionWithId(loadedRunnable.id, ((DSSRunnableDesc)loadedRunnable.desc).meta, loadedRunnable.folderName));
        }
        for (LoadedJythonProcessor loadedJythonProcessor : installationDesc.customJythonProcessors) {
            computedContent.customJythonProcessors.add(new ComputedPluginContent.ContributionWithId(loadedJythonProcessor.id, loadedJythonProcessor.desc.meta, loadedJythonProcessor.folderName));
        }
        for (LoadedFSProvider loadedFSProvider : installationDesc.customFSProviders) {
            computedContent.customFileSystemProviders.add(new ComputedPluginContent.ContributionWithId(loadedFSProvider.id, ((CustomFSProviderDesc)loadedFSProvider.desc).meta, loadedFSProvider.folderName));
        }
        for (LoadedJavaDialect loadedJavaDialect : installationDesc.customDialects) {
            computedContent.customFileSystemProviders.add(new ComputedPluginContent.ContributionWithId(loadedJavaDialect.id, loadedJavaDialect.desc.meta, loadedJavaDialect.folderName));
        }
        for (LoadedPythonPluginCluster loadedPythonPluginCluster : installationDesc.customPythonClusters) {
            computedContent.customPythonClusters.add(new ComputedPluginContent.ContributionWithId(loadedPythonPluginCluster.id, loadedPythonPluginCluster.desc.meta, loadedPythonPluginCluster.folderName));
        }
        for (LoadedParameterSet loadedParameterSet : installationDesc.customParameterSets) {
            computedContent.customParameterSets.add(new ComputedPluginContent.ContributionWithId(loadedParameterSet.id, loadedParameterSet.desc.meta, loadedParameterSet.folderName));
        }
        for (LoadedCustomFieldsDesc loadedCustomFieldsDesc : installationDesc.customFields) {
            computedContent.customFields.add(new ComputedPluginContent.ContributionWithId(loadedCustomFieldsDesc.id, loadedCustomFieldsDesc.desc.meta, loadedCustomFieldsDesc.folderName));
        }
        for (LoadedJavaPolicyHooks loadedJavaPolicyHooks : installationDesc.customJavaPolicyHooks) {
            computedContent.customJavaPolicyHooks.add(new ComputedPluginContent.ContributionWithId(loadedJavaPolicyHooks.id, loadedJavaPolicyHooks.desc.meta, loadedJavaPolicyHooks.folderName));
        }
        for (LoadedJavaUserSupplier loadedJavaUserSupplier : installationDesc.customJavaUserSupplier) {
            computedContent.customJavaUserSupplier.add(new ComputedPluginContent.ContributionWithId(loadedJavaUserSupplier.id, loadedJavaUserSupplier.desc.meta, loadedJavaUserSupplier.folderName));
        }
        for (LoadedJavaUserAuthenticator loadedJavaUserAuthenticator : installationDesc.customJavaUserAuthenticator) {
            computedContent.customJavaUserAuthenticator.add(new ComputedPluginContent.ContributionWithId(loadedJavaUserAuthenticator.id, loadedJavaUserAuthenticator.desc.meta, loadedJavaUserAuthenticator.folderName));
        }
        for (LoadedJavaUserAuthenticatorAndSupplier loadedJavaUserAuthenticatorAndSupplier : installationDesc.customJavaUserAuthenticatorAndSupplier) {
            computedContent.customJavaUserAuthenticatorAndSupplier.add(new ComputedPluginContent.ContributionWithId(loadedJavaUserAuthenticatorAndSupplier.id, loadedJavaUserAuthenticatorAndSupplier.desc.meta, loadedJavaUserAuthenticatorAndSupplier.folderName));
        }
        for (LoadedCustomWebApp loadedCustomWebApp : installationDesc.customWebApps) {
            computedContent.customWebApps.add(new ComputedPluginContent.ContributionWithId(loadedCustomWebApp.id, loadedCustomWebApp.desc.meta, loadedCustomWebApp.folderName));
        }
        for (LoadedCustomAgent loadedCustomAgent : installationDesc.customAgents) {
            computedContent.customAgents.add(new ComputedPluginContent.ContributionWithId(loadedCustomAgent.id, loadedCustomAgent.desc.meta, loadedCustomAgent.folderName));
        }
        for (LoadedCustomAgentTool loadedCustomAgentTool : installationDesc.customAgentTools) {
            computedContent.customAgentTools.add(new ComputedPluginContent.ContributionWithId(loadedCustomAgentTool.id, loadedCustomAgentTool.desc.meta, loadedCustomAgentTool.folderName));
        }
        for (LoadedCustomGuardrail loadedCustomGuardrail : installationDesc.customGuardrails) {
            computedContent.customGuardrails.add(new ComputedPluginContent.ContributionWithId(loadedCustomGuardrail.id, loadedCustomGuardrail.desc.meta, loadedCustomGuardrail.folderName));
        }
        for (LoadedCustomPythonPredictionAlgoDesc loadedCustomPythonPredictionAlgoDesc : installationDesc.customPythonPredictionAlgos) {
            computedContent.customPythonPredictionAlgos.add(new ComputedPluginContent.ContributionWithId(loadedCustomPythonPredictionAlgoDesc.id, loadedCustomPythonPredictionAlgoDesc.desc.meta, loadedCustomPythonPredictionAlgoDesc.folderName));
        }
        for (LoadedCustomAppTemplate loadedCustomAppTemplate : installationDesc.customAppTemplates) {
            computedContent.customAppTemplates.add(new ComputedPluginContent.ContributionWithId(loadedCustomAppTemplate.id, loadedCustomAppTemplate.desc.meta, loadedCustomAppTemplate.folderName));
        }
        for (LoadedExposition loadedExposition : installationDesc.customExpositions) {
            computedContent.customExpositions.add(new ComputedPluginContent.ContributionWithId(loadedExposition.id, loadedExposition.desc.meta, loadedExposition.folderName));
        }
        for (LoadedJavaLLM loadedJavaLLM : installationDesc.customJavaLLMs) {
            computedContent.customJavaLLMs.add(new ComputedPluginContent.ContributionWithId(loadedJavaLLM.id, ((CustomJavaLLMDesc)loadedJavaLLM.desc).meta, loadedJavaLLM.folderName));
        }
        for (LoadedPythonLLM loadedPythonLLM : installationDesc.customPythonLLMs) {
            computedContent.customPythonLLMs.add(new ComputedPluginContent.ContributionWithId(loadedPythonLLM.id, ((CustomPythonLLMDesc)loadedPythonLLM.desc).meta, loadedPythonLLM.folderName));
        }
        for (LoadedPythonPluginCodeStudioTemplate loadedPythonPluginCodeStudioTemplate : installationDesc.customPythonCodeStudioTemplates) {
            computedContent.customPythonCodeStudioTemplates.add(new ComputedPluginContent.ContributionWithId(loadedPythonPluginCodeStudioTemplate.id, loadedPythonPluginCodeStudioTemplate.desc.meta, loadedPythonPluginCodeStudioTemplate.folderName));
        }
        for (LoadedPythonPluginCodeStudioBlock loadedPythonPluginCodeStudioBlock : installationDesc.customPythonCodeStudioBlocks) {
            computedContent.customPythonCodeStudioBlocks.add(new ComputedPluginContent.ContributionWithId(loadedPythonPluginCodeStudioBlock.id, loadedPythonPluginCodeStudioBlock.desc.meta, loadedPythonPluginCodeStudioBlock.folderName));
        }
        for (LoadedPythonPluginProjectStandardsCheckSpec loadedPythonPluginProjectStandardsCheckSpec : installationDesc.customPythonProjectStandardsCheckSpecs) {
            computedContent.customPythonProjectStandardsCheckSpecs.add(new ComputedPluginContent.ContributionWithId(loadedPythonPluginProjectStandardsCheckSpec.id, loadedPythonPluginProjectStandardsCheckSpec.desc.meta, loadedPythonPluginProjectStandardsCheckSpec.folderName));
        }
        for (LoadedSampleDataset loadedSampleDataset : installationDesc.customSampleDatasets) {
            computedContent.customSampleDatasets.add(new ComputedPluginContent.ContributionWithId(loadedSampleDataset.id, loadedSampleDataset.desc.meta, loadedSampleDataset.folderName));
        }
        computedContent.customStandardWebAppTemplates = this.webAppsTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "STANDARD");
        computedContent.customBokehWebAppTemplates = this.webAppsTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "BOKEH");
        computedContent.customDashWebAppTemplates = this.webAppsTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "DASH");
        computedContent.customStreamlitWebAppTemplates = this.webAppsTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "STREAMLIT");
        computedContent.customShinyWebAppTemplates = this.webAppsTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "SHINY");
        computedContent.customRMarkdownReportTemplates = this.reportsTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "RMARKDOWN");
        computedContent.customPreBuiltNotebookTemplates = this.notebooksTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "STANDALONE", "pre-built");
        computedContent.customPythonNotebookTemplates = this.notebooksTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "STANDALONE", "python");
        computedContent.customRNotebookTemplates = this.notebooksTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "STANDALONE", "r");
        computedContent.customScalaNotebookTemplates = this.notebooksTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "STANDALONE", "scala");
        computedContent.customPreBuiltDatasetNotebookTemplates = this.notebooksTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "DATASET", "pre-built");
        computedContent.customPythonDatasetNotebookTemplates = this.notebooksTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "DATASET", "python");
        computedContent.customRDatasetNotebookTemplates = this.notebooksTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "DATASET", "r");
        computedContent.customScalaDatasetNotebookTemplates = this.notebooksTemplatesService.listTemplatesInPluginOfType(pluginId, pluginDir, "DATASET", "scala");
        computedContent.sampleProjects = TutorialsService.getPluginContent(this.registryService, installationDesc, Desc.Type.SAMPLE);
        computedContent.tutorials = TutorialsService.getPluginContent(this.registryService, installationDesc, Desc.Type.TUTORIAL);
        installationDesc.content = computedContent;
        File jsSnippetsDir = new File(pluginDir, "js");
        if (jsSnippetsDir.isDirectory()) {
            for (File f : jsSnippetsDir.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".js")) continue;
                installationDesc.customJSSnippets.add(FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8));
            }
        }
        return installationDesc;
    }

    public List<ComputedPluginContent.ContributionWithId> listCodeEnvInPlugin(String pluginId, File pluginDir) {
        ArrayList<ComputedPluginContent.ContributionWithId> ret = new ArrayList<ComputedPluginContent.ContributionWithId>();
        File codeEnvDir = DKUFileUtils.getWithin((File)pluginDir, (String[])new String[]{"code-env"});
        String templatesDirPath = "code-env";
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Checking for code-env in plugin " + pluginId + ": " + String.valueOf(codeEnvDir)));
        }
        if (codeEnvDir.listFiles() != null) {
            for (File codeEnv : codeEnvDir.listFiles()) {
                if (!codeEnv.isDirectory()) continue;
                try {
                    String id = codeEnv.getName();
                    String folderName = templatesDirPath + "/" + id;
                    ret.add(new ComputedPluginContent.ContributionWithId(id, null, folderName));
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to read codeEnv from " + String.valueOf(codeEnv)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    public String getPluginId(File pluginPath) throws CodedException, IOException {
        File descFile = new File(pluginPath, "plugin.json");
        if (!descFile.isFile()) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_INVALID_DEFINITION, "The repository you selected does not appear to contain a DSS plugin (plugin.json not found)");
        }
        PluginDesc pluginDesc = (PluginDesc)JSON.parseFile((File)descFile, PluginDesc.class);
        if (StringUtils.isBlank((String)pluginDesc.id)) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_INVALID_DEFINITION, "No 'id' field found in plugin descriptor (plugin.json)");
        }
        return pluginDesc.id;
    }

    public void unloadPlugin(String pluginId) {
        this.registryService.unregister(pluginId);
        this.unregisterPlugin(pluginId);
        logger.info((Object)"Plugin deactivated");
    }

    public void deleteDevPlugin(String pluginId) throws IOException {
        DKUFileUtils.forceDelete((File)this.registryService.getActualPluginFolder(pluginId));
    }

    static {
        skipLoadPlugins = new TestFlag();
        logger = Logger.getLogger((String)"dku.plugins");
    }

    private class PluginLoader
    implements Runnable {
        private final File pluginDir;
        private final InstalledPluginDesc.PluginOrigin origin;
        private final boolean reload;

        public PluginLoader(File pluginDir, InstalledPluginDesc.PluginOrigin origin, boolean reload) {
            this.pluginDir = pluginDir;
            this.origin = origin;
            this.reload = reload;
        }

        @Override
        public void run() {
            if (!this.pluginDir.exists() || !this.pluginDir.isDirectory()) {
                return;
            }
            File descFile = new File(this.pluginDir, "plugin.json");
            if (!descFile.exists()) {
                return;
            }
            try {
                PluginsLoadService.this.loadPlugin(this.pluginDir, true, this.origin, this.reload);
            }
            catch (DuplicatePluginException e) {
                logger.warn((Object)("Loading plugin " + String.valueOf(this.pluginDir) + " failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
            catch (CodedException e) {
                if (e.getCode() == IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION || e.getCode() == IPluginsRegistryService.PluginCodes.ERR_PLUGIN_INVALID_DEFINITION) {
                    logger.warn((Object)("Loading plugin " + String.valueOf(this.pluginDir) + " failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                } else {
                    logger.warn((Object)("Loading plugin " + String.valueOf(this.pluginDir) + " failed (code: " + String.valueOf(e.getCode()) + ")"), (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Loading plugin " + String.valueOf(this.pluginDir) + " failed"), (Throwable)e);
            }
            catch (UnsupportedClassVersionError e) {
                logger.warn((Object)("Loading plugin " + String.valueOf(this.pluginDir) + " failed. Upgrade your version of Java to use it."), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                logger.warn((Object)("Loading plugin " + String.valueOf(this.pluginDir) + " failed. You may need to upgrade your version of the plugin to use it."), (Throwable)e);
            }
        }
    }
}

