/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.code.CodeEnvUsagesService;
import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.ContainerExecUsagesService;
import com.dataiku.dip.containers.exec.UsedContainerExec;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.projects.importexport.BundleCodes;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.backend.WebAppBackendInfra;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ContainerExecRemapper {
    @Autowired
    private CodeEnvUsagesService codeEnvUsagesService;
    @Autowired
    private ContainerExecUsagesService containerExecUsagesService;
    @Autowired
    private MLBaseService mLBaseService;
    private final AuthCtx authCtx;
    private final ProjectRemappingSettings settings;
    private final ExportedProject sourceExportedProject;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.bundles.container-exec");

    public ContainerExecRemapper(AuthCtx authCtx, ProjectRemappingSettings settings, ExportedProject sourceExportedProject) {
        this.authCtx = authCtx;
        this.settings = settings;
        this.sourceExportedProject = sourceExportedProject;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public List<InfoMessage> checkRemapProject(SerializedProject input) throws IOException {
        return this.checkRemap(this.containerExecUsagesService.listProjectContainerExecSelections(input), input);
    }

    public List<InfoMessage> checkRemapRecipe(SerializedRecipe input) throws IOException {
        ParamsWithContainerizable params = this.containerExecUsagesService.getParamsWithContainerizable(input);
        if (params == null || params.getContainerSelection() == null) {
            return List.of();
        }
        ContainerExecSelection containerExecSelection = params.getContainerSelection();
        return this.checkRemap(containerExecSelection, "recipe " + input.name);
    }

    public List<InfoMessage> checkRemapPayloadRecipe(SerializedRecipe input) throws IOException {
        ParamsWithContainerizable params = this.containerExecUsagesService.getParamsWithContainerizablePayload(input);
        if (params == null || params.getContainerSelection() == null) {
            return List.of();
        }
        return this.checkRemap(params.getContainerSelection(), "recipe payload " + input.name);
    }

    public List<InfoMessage> checkRemapAnalysis(AnalysisCoreParams input) throws IOException {
        return this.checkRemap(this.containerExecUsagesService.listAnalysesContainerExecSelections(input), input);
    }

    public List<InfoMessage> checkRemapSavedModels(SavedModel input) throws IOException {
        return this.checkRemap(this.containerExecUsagesService.listSavedModelContainerExecSelections(input), input);
    }

    public List<InfoMessage> checkRetrievableKnowledge(RetrievableKnowledge input) throws IOException {
        if (input.containerExecSelection == null) {
            return List.of();
        }
        return this.checkRemap(Set.of(input.containerExecSelection), input);
    }

    public List<InfoMessage> checkRemapNotebooks(JupyterUtils.JupyterNotebookListEntry input, String projectKey) throws IOException {
        ContainerExecSelection containerExecSelection = this.containerExecUsagesService.getNotebookContainerExecSelection(input, projectKey);
        if (containerExecSelection == null) {
            return List.of();
        }
        return this.checkRemap(Set.of(containerExecSelection), input);
    }

    public List<InfoMessage> checkRemapWebApp(WebApp input) throws IOException {
        ContainerExecSelection containerExecSelection = this.containerExecUsagesService.getWebAppContainerExecSelection(input);
        if (containerExecSelection == null) {
            return List.of();
        }
        return this.checkRemap(Set.of(containerExecSelection), input);
    }

    private List<InfoMessage> checkRemap(Collection<ContainerExecSelection> containerExecSelections, TaggableObjectsService.TaggableObject input) throws IOException {
        return this.checkRemap(containerExecSelections, input.getTaggableType().toHumanReadableString() + " " + input.getDisplayName());
    }

    private List<InfoMessage> checkRemap(Collection<ContainerExecSelection> containerExecSelections, String objectDescription) throws IOException {
        ArrayList<InfoMessage> ret = new ArrayList<InfoMessage>();
        HashSet<ContainerExecSelection> containerExecSelectionsSet = new HashSet<ContainerExecSelection>(containerExecSelections);
        for (ContainerExecSelection sourceContainerExec : containerExecSelectionsSet) {
            ret.addAll(this.checkRemap(sourceContainerExec, objectDescription));
        }
        return ret;
    }

    @Nonnull
    private List<InfoMessage> checkRemap(@Nonnull ContainerExecSelection containerExecSelection, String objectDescription) throws IOException {
        ArrayList<InfoMessage> ret = new ArrayList<InfoMessage>();
        if (containerExecSelection.containerMode != ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER) {
            logger.infoV("%s doesn't use a named container exec config, skipping", new Object[]{objectDescription});
            return ret;
        }
        String sourceContainerExecName = containerExecSelection.containerConf;
        if (StringUtils.isBlank((CharSequence)sourceContainerExecName)) {
            logger.infoV("%s has an empty container exec config name, skipping", new Object[]{objectDescription});
            return ret;
        }
        UsedContainerExec sourceContainerExec = this.sourceExportedProject.usedContainerExecConfs.stream().filter(c2 -> sourceContainerExecName.equals(c2.name)).findFirst().orElse(null);
        if (sourceContainerExec == null) {
            logger.infoV("source container exec '%s' is not referenced, skipping check", new Object[]{sourceContainerExecName});
            return ret;
        }
        logger.debugV("%s uses source-container-exec '%s'", new Object[]{objectDescription, sourceContainerExecName});
        ProjectRemappingSettings.ContainerExecRemapping remapping = this.settings.getRemappingForContainerExec(sourceContainerExecName);
        if (remapping == null) {
            logger.infoV("source is not remapped, checking it", new Object[0]);
            ContainerExecRuntimeConfig unremapped = this.getContainerExecRuntimeConfig(sourceContainerExecName);
            if (unremapped == null) {
                if (this.isAllowedMissing(sourceContainerExecName)) {
                    logger.infoV(" container-exec '%s' is missing, but allowed to be missing", new Object[]{sourceContainerExecName});
                } else {
                    logger.warnV(" container-exec '%s' is missing", new Object[]{sourceContainerExecName});
                    ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_MISSING_CONTAINER_EXEC_CONFIG, (String)"Container-exec missing for %s (not remapped): '%s'", (Object[])new Object[]{objectDescription, sourceContainerExecName}));
                }
            } else if (!unremapped.isFreelyUsableBy(this.authCtx)) {
                if (this.isAllowedMissing(sourceContainerExecName)) {
                    logger.infoV(" container-exec '%s' is forbidden, but allowed to be missing", new Object[]{sourceContainerExecName});
                } else {
                    logger.warnV(" container-exec '%s' is forbidden", new Object[]{sourceContainerExecName});
                    ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_CONTAINER_EXEC_CONFIG_NOT_USABLE, (String)"Invalid container exec for %s : '%s' (%s) is not freely usable and needs to be remapped.", (Object[])new Object[]{objectDescription, sourceContainerExecName, unremapped.type}));
                }
            } else if (!unremapped.supportsWorkloadType(sourceContainerExec.workloadType)) {
                logger.warnV(" container-exec '%s' has incompatible workload type. Found %s, expected %s.", new Object[]{sourceContainerExecName, unremapped.workloadType, sourceContainerExec.workloadType});
                ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_CONTAINER_EXEC_INCOMPATIBLE_WORKLOAD_TYPE, (String)"Incompatible workload type for %s: '%s'. Found %s, expected %s.", (Object[])new Object[]{objectDescription, sourceContainerExecName, unremapped.workloadType, sourceContainerExec.workloadType}));
            } else {
                logger.debugV("Non-remapped container-exec '%s' is present", new Object[]{sourceContainerExecName});
            }
        } else {
            logger.infoV("Remapped to '%s'", new Object[]{remapping.target});
            ContainerExecRuntimeConfig remapped = this.getContainerExecRuntimeConfig(remapping.target);
            if (remapped == null) {
                logger.warnV("Container-exec '%s' missing for %s (remapped from '%s')", new Object[]{remapping.target, objectDescription, sourceContainerExecName});
                ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_MISSING_CONTAINER_EXEC_CONFIG, (String)"Container-exec '%s' missing for %s (remapped from '%s')", (Object[])new Object[]{remapping.target, objectDescription, sourceContainerExecName}));
            } else if (!remapped.isFreelyUsableBy(this.authCtx)) {
                logger.warnV(" container-exec '%s' is forbidden", new Object[]{remapping.target});
                ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_CONTAINER_EXEC_CONFIG_NOT_USABLE, (String)"Invalid container-exec for %s : '%s' is not freely usable, '%s' needs to be mapped to a usable connection.", (Object[])new Object[]{objectDescription, remapping.target, sourceContainerExecName}));
            } else if (!remapped.supportsWorkloadType(sourceContainerExec.workloadType)) {
                logger.warnV(" container-exec '%s' has incompatible workload type. Found %s, expected %s.", new Object[]{remapping.target, remapped.workloadType, sourceContainerExec.workloadType});
                ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_CONTAINER_EXEC_INCOMPATIBLE_WORKLOAD_TYPE, (String)"Incompatible workload type for %s: '%s' (remapped from '%s'). Found %s, expected %s.", (Object[])new Object[]{objectDescription, remapping.target, sourceContainerExecName, remapped.workloadType, sourceContainerExec.workloadType}));
            } else {
                logger.debugV("Remapped container-exec '%s' is present and authorized", new Object[]{remapping.target});
            }
        }
        return ret;
    }

    public boolean remapProject(SerializedProject input) throws IOException {
        ContainerExecSelection containerForVisualRecipes;
        ProjectRemappingSettings.ContainerExecRemapping containerForVisualRecipesRemapping;
        boolean remapped = false;
        ContainerExecSelection container = input.settings.container;
        ProjectRemappingSettings.ContainerExecRemapping containerRemapping = this.remap(container, "project " + input.name, false);
        if (containerRemapping != null && StringUtils.isNotEmpty((CharSequence)containerRemapping.target)) {
            input.settings.container.containerConf = containerRemapping.target;
            remapped = true;
        }
        if ((containerForVisualRecipesRemapping = this.remap(containerForVisualRecipes = input.settings.containerForVisualRecipesWorkloads, "project " + input.name, false)) != null && StringUtils.isNotEmpty((CharSequence)containerForVisualRecipesRemapping.target)) {
            input.settings.containerForVisualRecipesWorkloads.containerConf = containerForVisualRecipesRemapping.target;
            remapped = true;
        }
        return remapped;
    }

    public boolean remapRecipe(SerializedRecipe input) throws IOException {
        ParamsWithContainerizable params = this.containerExecUsagesService.getParamsWithContainerizable(input);
        return this.remapRecipeParamsOrPayloadParams(params, "recipe " + input.getDisplayName()) != null;
    }

    @Nullable
    public Object remapRecipePayload(SerializedRecipe input) throws IOException {
        ParamsWithContainerizable params = this.containerExecUsagesService.getParamsWithContainerizablePayload(input);
        return this.remapRecipeParamsOrPayloadParams(params, "recipe payload " + input.getDisplayName());
    }

    @Nullable
    private Object remapRecipeParamsOrPayloadParams(@Nullable ParamsWithContainerizable params, String objectDescription) throws IOException {
        if (params == null || params.getContainerSelection() == null) {
            return null;
        }
        ContainerExecSelection containerExecSelection = params.getContainerSelection();
        ProjectRemappingSettings.ContainerExecRemapping remapping = this.remap(containerExecSelection, objectDescription, false);
        if (remapping != null && StringUtils.isNotEmpty((CharSequence)remapping.target)) {
            containerExecSelection.containerConf = remapping.target;
            params.setContainerSelection(containerExecSelection);
            return params;
        }
        return null;
    }

    public boolean remapAnalysis(AnalysisCoreParams acp, MLTask input) throws IOException {
        ContainerExecSelection containerExecSelection = input.containerSelection;
        ProjectRemappingSettings.ContainerExecRemapping remapping = this.remap(containerExecSelection, acp.getTaggableType().toHumanReadableString() + " " + acp.getDisplayName(), false);
        if (remapping != null && StringUtils.isNotEmpty((CharSequence)remapping.target)) {
            containerExecSelection.containerConf = remapping.target;
            input.setContainerSelection(containerExecSelection);
            return true;
        }
        return false;
    }

    public boolean remapRetrievableKnowledge(RetrievableKnowledge input) throws IOException {
        ProjectRemappingSettings.ContainerExecRemapping remapping = this.remap(input.containerExecSelection, "retrievable knowledge " + input.id, false);
        if (remapping != null && StringUtils.isNotEmpty((CharSequence)remapping.target)) {
            input.containerExecSelection.containerConf = remapping.target;
            return true;
        }
        return false;
    }

    public boolean remapWebApp(WebApp input) throws IOException {
        WebAppBackendInfra webAppBackendInfra = input.params.infra;
        ProjectRemappingSettings.ContainerExecRemapping remapping = this.remap(webAppBackendInfra.containerSelection, "web app " + input.id, false);
        if (remapping != null && StringUtils.isNotEmpty((CharSequence)remapping.target)) {
            webAppBackendInfra.containerSelection.containerConf = remapping.target;
            return true;
        }
        return false;
    }

    public boolean remapTrainedModels(AnalysisCoreParams acp, MLTask mlTask) throws IOException {
        MLTaskLoc loc = new MLTaskLoc(acp.projectKey, acp.id, mlTask.id);
        boolean remap = false;
        for (FullModelId fmi : this.mLBaseService.listCompletedModelIds(loc)) {
            if (!this.remapFmi(acp, fmi)) continue;
            remap = true;
        }
        return remap;
    }

    public boolean remapSavedModels(SavedModel sm) throws IOException {
        boolean remap = false;
        for (FullModelId fmi : this.codeEnvUsagesService.listFmisInSavedModel(sm)) {
            if (!this.remapFmi(sm, fmi)) continue;
            remap = true;
        }
        return remap;
    }

    public boolean remapNotebook(String name, JsonObject input) throws IOException {
        JupyterCodeEnvUtils.NotebookCodeEnvInfo info = JupyterCodeEnvUtils.getCodeEnvInfoFromNotebook(input);
        if (info == null) {
            return false;
        }
        ProjectRemappingSettings.ContainerExecRemapping remapping = this.remap(new ContainerExecSelection(info.containerConf), "notebook " + name, false);
        if (remapping != null && StringUtils.isNotEmpty((CharSequence)remapping.target)) {
            info.containerConf = remapping.target;
            JupyterCodeEnvUtils.setKernelNameInNotebook(input, JupyterCodeEnvUtils.getKernelName(info.envLang, info.envName, info.projectKey, info.bundleId, info.containerConf));
            JupyterCodeEnvUtils.setDisplayNameInNotebook(input, JupyterCodeEnvUtils.getDisplayName(info.envLang, info.envName, info.projectKey, info.bundleId, info.containerConf));
            return true;
        }
        return false;
    }

    private boolean remapFmi(TaggableObjectsService.TaggableObject object, FullModelId fmi) throws IOException {
        ContainerExecSelection usage = fmi.getContainerSelection();
        if (usage == null) {
            return false;
        }
        boolean remapped = false;
        ProjectRemappingSettings.ContainerExecRemapping remapping = this.remap(usage, object.getTaggableType().toHumanReadableString() + " " + object.getDisplayName(), false);
        if (remapping != null && StringUtils.isNotEmpty((CharSequence)remapping.target)) {
            MLTask trainedTask;
            ContainerExecSelection taskContainerSelection;
            assert (!fmi.isExternalMLflowModelVersion()) : "External MLflow models are not supposed to contain container exec selection";
            ResolvedCoreParams rcp = fmi.getResolvedCoreParams();
            ContainerExecSelection containerSelection = rcp.getContainerSelection();
            if (containerSelection != null) {
                containerSelection.containerConf = remapping.target;
                rcp.setContainerSelection(containerSelection);
                remapped = true;
                JSON.prettyToFile((Object)rcp, (File)fmi.getSessionFile("core_params.json"));
            }
            if (fmi.type == FullModelId.Type.ANALYSIS && (taskContainerSelection = (trainedTask = fmi.parseSessionFile("mltask.json", MLTask.class)).getContainerSelection()) != null) {
                taskContainerSelection.containerConf = remapping.target;
                trainedTask.setContainerSelection(taskContainerSelection);
                JSON.prettyToFile((Object)trainedTask, (File)fmi.getSessionFile("mltask.json"));
                remapped = true;
            }
            return remapped;
        }
        return false;
    }

    @Nullable
    private ProjectRemappingSettings.ContainerExecRemapping remap(@Nonnull ContainerExecSelection containerExecSelection, @Nonnull String objectDescription, boolean failIfNoSource) throws IOException {
        String sourceContainerExecName = containerExecSelection.containerConf;
        if (containerExecSelection.containerMode != ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER || StringUtils.isEmpty((CharSequence)sourceContainerExecName)) {
            return null;
        }
        logger.infoV("%s uses source-container-exec '%s'", new Object[]{objectDescription, sourceContainerExecName});
        UsedContainerExec sourceContainerExec = this.sourceExportedProject.usedContainerExecConfs.stream().filter(c2 -> sourceContainerExecName.equals(c2.name)).findFirst().orElse(null);
        if (sourceContainerExec == null && failIfNoSource) {
            throw ErrorContext.iaef((String)"Inconsistent bundle data: container-exec '%s' not referenced", (Object)sourceContainerExecName, (Object[])new Object[0]);
        }
        ProjectRemappingSettings.ContainerExecRemapping remapping = this.settings.getRemappingForContainerExec(sourceContainerExecName);
        if (remapping == null) {
            logger.infoV("source is not remapped, checking it", new Object[0]);
            ContainerExecRuntimeConfig unremapped = this.getContainerExecRuntimeConfig(sourceContainerExecName);
            if (unremapped == null) {
                if (this.isAllowedMissing(sourceContainerExecName)) {
                    logger.infoV(" container exec '%s' is missing, but allowed to be missing", new Object[]{sourceContainerExecName});
                    return null;
                }
                logger.warnV(" container exec '%s' is missing", new Object[]{sourceContainerExecName});
                throw ErrorContext.iaef((String)"Missing container exec '%s'", (Object)sourceContainerExecName, (Object[])new Object[0]);
            }
            if (sourceContainerExec == null) {
                logger.infoV("source container exec workload type unknown, using '%s' of workload type %s", new Object[]{unremapped.name, unremapped.workloadType});
            } else if (!unremapped.supportsWorkloadType(sourceContainerExec.workloadType)) {
                throw ErrorContext.iaef((String)"Invalid workload type for %s: '%s'. Found %s, expected %s.", (Object)objectDescription, (Object[])new Object[]{sourceContainerExecName, unremapped.workloadType, sourceContainerExec.workloadType});
            }
            if (!unremapped.isFreelyUsableBy(this.authCtx)) {
                if (this.isAllowedMissing(sourceContainerExecName)) {
                    logger.infoV("Container-exec '%s' is forbidden, but allowed to be missing", new Object[]{sourceContainerExecName});
                    return null;
                }
                throw ErrorContext.iaef((String)"Invalid container exec for %s : '%s' (%s) is not freely usable", (Object)objectDescription, (Object[])new Object[]{sourceContainerExecName, unremapped.type});
            }
        } else {
            ContainerExecRuntimeConfig remapped = this.getContainerExecRuntimeConfig(remapping.target);
            if (remapped == null) {
                logger.warnV("Container exec '%s' is missing (remapped from '%s')", new Object[]{remapping.target, sourceContainerExecName});
                throw ErrorContext.iaef((String)"Missing container exec '%s' (remapped from '%s')", (Object)remapping.target, (Object[])new Object[]{sourceContainerExecName});
            }
            if (sourceContainerExec == null) {
                logger.infoV("source container exec workload type unknown, using '%s' of workload type %s", new Object[]{remapped.name, remapped.workloadType});
            } else if (!remapped.supportsWorkloadType(sourceContainerExec.workloadType)) {
                throw ErrorContext.iaef((String)"Invalid workload type for %s: '%s' (remapped from '%s'). Found %s, expected %s.", (Object)objectDescription, (Object[])new Object[]{remapping.target, sourceContainerExecName, remapped.workloadType, sourceContainerExec.workloadType});
            }
            if (!remapped.isFreelyUsableBy(this.authCtx)) {
                throw ErrorContext.iaef((String)"Invalid container-exec for %s : '%s' is not freely usable, '%s' needs to be mapped to a usable connection.", (Object)objectDescription, (Object[])new Object[]{remapping.target, sourceContainerExecName});
            }
        }
        return remapping;
    }

    private ContainerExecRuntimeConfig getContainerExecRuntimeConfig(String configName) throws IOException {
        ClusterSettings clusterSettings = new ClusterSelector().selectGlobal();
        return clusterSettings.getContainerSettings().getByNameOrNull(configName);
    }

    private boolean isAllowedMissing(String containerExecConfigName) {
        return false;
    }
}

