/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes;

import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RecipeDesc {
    public boolean copiable = true;
    public boolean isMultiEngine = false;
    public List<IORoleDef> inputRoles = new ArrayList<IORoleDef>();
    public List<IORoleDef> outputRoles = new ArrayList<IORoleDef>();
    public DkuComponentMetadata meta = new DkuComponentMetadata();

    public RecipeDesc() {
    }

    public RecipeDesc(String typeLabel, String description) {
        this.meta.label = typeLabel;
        this.meta.description = description;
    }

    public static RecipeDesc newSisoDesc(String type, String typeDisplayName) {
        RecipeDesc desc = new RecipeDesc(type, typeDisplayName);
        desc.inputRoles.add(IORoleDef.newUnaryRequiredDataset("main", ""));
        desc.outputRoles.add(IORoleDef.newUnaryRequiredDataset("main", ""));
        return desc;
    }

    public static RecipeDesc newDescWithNaryAny(String type, String typeDisplayName) {
        IORoleDef mainIn = IORoleDef.newNaryAny("main", "");
        IORoleDef mainOut = IORoleDef.newNaryAny("main", "");
        mainOut.required = true;
        RecipeDesc desc = new RecipeDesc(type, typeDisplayName);
        desc.inputRoles.add(mainIn);
        desc.outputRoles.add(mainOut);
        return desc;
    }

    public static RecipeDesc newDescWithNaryDatasets(String type, String typeDisplayName) {
        IORoleDef mainIn = IORoleDef.newNary("main", "");
        IORoleDef mainOut = IORoleDef.newNary("main", "");
        mainOut.required = true;
        RecipeDesc desc = new RecipeDesc(type, typeDisplayName);
        desc.inputRoles.add(mainIn);
        desc.outputRoles.add(mainOut);
        return desc;
    }

    public Map<String, IORoleDef> getInputRolesMap() {
        HashMap<String, IORoleDef> ret = new HashMap<String, IORoleDef>();
        if (this.inputRoles != null) {
            for (IORoleDef r : this.inputRoles) {
                ret.put(r.name, r);
            }
        }
        return ret;
    }

    public Map<String, IORoleDef> getOutputRolesMap() {
        HashMap<String, IORoleDef> ret = new HashMap<String, IORoleDef>();
        if (this.outputRoles != null) {
            for (IORoleDef r : this.outputRoles) {
                ret.put(r.name, r);
            }
        }
        return ret;
    }

    public RecipeDesc multiEngine(boolean isMultiEngine) {
        this.isMultiEngine = isMultiEngine;
        return this;
    }

    public static class IORoleDef {
        public String name;
        public String label;
        public String description;
        public IOArity arity = IOArity.NARY;
        public boolean required;
        public boolean availabilityDependsOnPayload = false;
        public boolean editableInModal = true;
        public boolean editableInEditor = true;
        public boolean saveAndReloadAfterEditInEditor = false;
        public boolean acceptsDataset = true;
        public boolean acceptsSavedModel = false;
        public boolean acceptsManagedFolder = false;
        public boolean acceptsStreamingEndpoint = false;
        public boolean acceptsRetrievableKnowledge = false;
        public boolean acceptsModelEvaluationStore = false;
        public boolean acceptsAgentEvaluationStore = false;
        public boolean acceptsLLMEvaluationStore = false;
        public boolean mustBeSQL;
        public boolean mustBeSQLAble;
        public String mustBeStrictlyType;
        public List<String> acceptedTypes;
        public boolean mustHaveSchema = false;
        public boolean mustNotBePartitioned = false;
        public boolean mustBeSharepointFolder = false;

        public IORoleDef() {
        }

        public IORoleDef(String name, String label) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"A name is required for recipe input and output roles");
            this.name = name;
            this.label = label;
        }

        public boolean acceptsEvaluationStore() {
            return this.acceptsModelEvaluationStore || this.acceptsAgentEvaluationStore || this.acceptsLLMEvaluationStore;
        }

        public IORoleDef withEditable(boolean editableInModal, boolean editableInEditor) {
            this.editableInModal = editableInModal;
            this.editableInEditor = editableInEditor;
            return this;
        }

        public IORoleDef withHdsfOnly() {
            this.mustBeStrictlyType = BuiltinFSDatasets.HDFS_META.getType();
            return this;
        }

        public IORoleDef withHdsOrHivefOnly() {
            this.acceptedTypes = Lists.newArrayList((Object[])new String[]{BuiltinFSDatasets.HDFS_META.getType(), BuiltinSQLDatasets.HIVE_META.getType()});
            return this;
        }

        public boolean hasSchema() {
            return this.acceptsDataset || this.acceptsStreamingEndpoint;
        }

        public static IORoleDef newUnaryDataset(String name, String label) {
            IORoleDef desc = new IORoleDef(name, label);
            desc.arity = IOArity.UNARY;
            return desc;
        }

        public static IORoleDef newUnaryRequiredDataset(String name, String label) {
            IORoleDef desc = IORoleDef.newUnaryDataset(name, label);
            desc.required = true;
            return desc;
        }

        public static IORoleDef newUnaryRequiredModel(String name, String label) {
            IORoleDef desc = new IORoleDef(name, label);
            desc.arity = IOArity.UNARY;
            desc.required = true;
            desc.acceptsDataset = false;
            desc.acceptsSavedModel = true;
            return desc;
        }

        public static IORoleDef newUnaryRetrievableKnowledge(String name, String label) {
            IORoleDef desc = new IORoleDef(name, label);
            desc.arity = IOArity.UNARY;
            desc.acceptsDataset = false;
            desc.acceptsRetrievableKnowledge = true;
            return desc;
        }

        public static IORoleDef newUnaryRequiredRetrievableKnowledge(String name, String label) {
            IORoleDef desc = IORoleDef.newUnaryRetrievableKnowledge(name, label);
            desc.required = true;
            return desc;
        }

        public static IORoleDef newUnaryRequiredFolder(String name, String label) {
            IORoleDef desc = IORoleDef.newUnaryRequiredDataset(name, label);
            desc.acceptsDataset = false;
            desc.acceptsManagedFolder = true;
            return desc;
        }

        public static IORoleDef newUnaryFolder(String name, String label) {
            IORoleDef desc = IORoleDef.newUnaryDataset(name, label);
            desc.acceptsDataset = false;
            desc.acceptsManagedFolder = true;
            return desc;
        }

        public static IORoleDef newNary(String name, String label) {
            IORoleDef desc = new IORoleDef(name, label);
            desc.arity = IOArity.NARY;
            return desc;
        }

        public static IORoleDef newNaryFolder(String name, String label) {
            IORoleDef desc = IORoleDef.newNary(name, label);
            desc.acceptsDataset = false;
            desc.acceptsManagedFolder = true;
            return desc;
        }

        public static IORoleDef newNaryRequiredFolder(String name, String label) {
            IORoleDef desc = IORoleDef.newNaryFolder(name, label);
            desc.required = true;
            return desc;
        }

        public static IORoleDef newNaryAny(String name, String label) {
            IORoleDef desc = new IORoleDef(name, label);
            desc.acceptsSavedModel = true;
            desc.acceptsManagedFolder = true;
            desc.arity = IOArity.NARY;
            return desc;
        }

        public static IORoleDef newUnaryAgentEvaluationStore(String name, String label) {
            IORoleDef desc = new IORoleDef(name, label);
            desc.arity = IOArity.UNARY;
            desc.acceptsDataset = false;
            desc.acceptsAgentEvaluationStore = true;
            return desc;
        }

        public static IORoleDef newUnaryLLMEvaluationStore(String name, String label) {
            IORoleDef desc = new IORoleDef(name, label);
            desc.arity = IOArity.UNARY;
            desc.acceptsDataset = false;
            desc.acceptsLLMEvaluationStore = true;
            return desc;
        }

        public static IORoleDef newUnaryModelEvaluationStore(String name, String label) {
            IORoleDef desc = new IORoleDef(name, label);
            desc.arity = IOArity.UNARY;
            desc.acceptsDataset = false;
            desc.acceptsModelEvaluationStore = true;
            return desc;
        }
    }

    public static enum IOArity {
        UNARY,
        NARY;

    }
}

