/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.impala;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.code.impala.ImpalaQueryInternalRunner;
import com.dataiku.dip.util.DatasetLocUtils;
import java.util.ArrayList;
import java.util.List;

public class ImpalaExecutor
implements AbortableRecipeRunner {
    private JobActivity activity;
    private ImpalaExecutorParams params;
    private String initialQuery;
    private List<String> preQueries;
    private List<String> postQueries;
    ImpalaQueryInternalRunner internalRunner;

    public ImpalaExecutor(JobActivity activity, ImpalaExecutorParams params, String sql, List<String> preQueries, List<String> postQueries) {
        this.internalRunner = new ImpalaQueryInternalRunner(activity, false);
        this.activity = activity;
        this.initialQuery = sql;
        this.preQueries = preQueries != null ? preQueries : new ArrayList();
        this.postQueries = postQueries != null ? postQueries : new ArrayList();
        this.params = params;
    }

    @Override
    public void run() throws Exception {
        DatasetLocUtils.DatasetLoc outputLoc = DatasetLocUtils.resolveFull(this.activity.getSubgraph().getSingleTargetDataset().getFullName());
        this.internalRunner.execute(outputLoc, this.initialQuery, this.preQueries, this.postQueries, this.params.forceStreamMode);
    }

    @Override
    public void notifyBeforeAborting() {
        this.internalRunner.notifyBeforeAborting();
    }

    public static class ImpalaExecutorParams
    extends RecipeParams {
        public boolean forceStreamMode = true;
        public String preQueries;
    }
}

