/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sparksql;

import com.dataiku.dip.spark.SparkCodes;
import com.dataiku.dip.utils.DKUtils;
import java.io.IOException;
import java.util.regex.Pattern;

public class SparkSQLLogParser
implements DKUtils.LineSubscription {
    private static final Pattern sparkSqlUnionSupportPattern = Pattern.compile("^org\\.apache\\.spark\\.sql\\.AnalysisException: missing ALL at 'SELECT' near '\\<EOF\\>'; line \\d+ pos \\d+$");
    private SparkCodes lastExplainableError;

    public synchronized SparkCodes getLastExplainableError() {
        return this.lastExplainableError;
    }

    public void close() throws IOException {
    }

    public synchronized void handle(String line, boolean replace) throws IOException {
        if (sparkSqlUnionSupportPattern.matcher(line).matches()) {
            this.lastExplainableError = SparkCodes.ERR_SPARK_SQL_LEGACY_UNION_SUPPORT;
        }
    }
}

