/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sql;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.utils.FlowVariables;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.GenericSQLDatasetMeta;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SQLQueryRecipeUtils {
    private static Logger logger = Logger.getLogger((String)"dku.recipes.sql");

    public static SQLConnections getSourceConnections(AuthCtx authCtx, RecipeRunnableSubgraph subgraph, DatasetsDAO datasetsDAO, String forRole) throws IOException {
        SQLConnections res = new SQLConnections();
        for (FlowDataset source : subgraph.getSourceDatasetsForRole(forRole)) {
            Dataset sourceDS = source.getMandatory(datasetsDAO);
            String sourceDSConnection = DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(authCtx, sourceDS);
            res.add(sourceDSConnection);
        }
        return res;
    }

    public static SQLConnections getSourceConnections(AuthCtx authCtx, RecipeRunnableSubgraph subgraph, DatasetsDAO datasetsDAO) throws IOException {
        SQLConnections res = new SQLConnections();
        for (FlowDataset source : subgraph.getSourceDatasets()) {
            Dataset sourceDS = source.getMandatory(datasetsDAO);
            String sourceDSConnection = DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(authCtx, sourceDS);
            res.add(sourceDSConnection);
        }
        return res;
    }

    public static SQLConnections getSourceConnections(AuthCtx authCtx, RecipeRunnableSubgraph subgraph) throws IOException {
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        return SQLQueryRecipeUtils.getSourceConnections(authCtx, subgraph, datasetsDAO);
    }

    public static List<Dataset> getSourceDatasets(SerializedRecipe recipe) throws IOException {
        return SQLQueryRecipeUtils.getSourceDatasetStream(recipe).map(Dataset::fromSerialized).collect(Collectors.toList());
    }

    public static Stream<SerializedDataset> getSourceDatasetStream(SerializedRecipe recipe) throws IOException {
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        ArrayList<SerializedDataset> datasets = new ArrayList<SerializedDataset>();
        for (SerializedRecipe.RecipeInput input : recipe.getInputsForRole("main")) {
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(recipe.projectKey, input.ref);
            SerializedDataset inputDs = (SerializedDataset)datasetsDAO.getOrNull(loc);
            if (inputDs == null) continue;
            datasets.add(inputDs);
        }
        return datasets.stream();
    }

    public static Stream<SerializedDataset> getAllDatasetStream(SerializedRecipe recipe) throws IOException {
        return Stream.concat(SQLQueryRecipeUtils.getSourceDatasetStream(recipe), SQLQueryRecipeUtils.getTargetDatasetStream(recipe));
    }

    public static Stream<String> getTargetConnectionStream(SerializedRecipe recipe) throws IOException {
        return SQLQueryRecipeUtils.getTargetDatasetStream(recipe).map(dataset -> dataset.getParams().getConnection()).filter(Objects::nonNull);
    }

    public static String getDefaultConnection(SQLConnections inputConnections, SQLConnections outputConnections) throws IllegalArgumentException {
        String connection;
        if (StringUtils.isNotBlank((String)inputConnections.firstConnection)) {
            connection = inputConnections.firstConnection;
        } else if (StringUtils.isNotBlank((String)outputConnections.firstConnection)) {
            connection = outputConnections.firstConnection;
        } else {
            throw ErrorContext.iae((String)"No SQL connection among input nor output datasets.");
        }
        return connection;
    }

    public static String getMainConnection(SerializedRecipe recipe, AuthCtx liu) throws IOException, IllegalArgumentException {
        SQLQueryRecipeMeta.SQLQueryRecipeParams params = (SQLQueryRecipeMeta.SQLQueryRecipeParams)SQLQueryRecipeMeta.SQLQueryRecipeParams.class.cast(recipe.params);
        if (!params.allowMultipleConnections) {
            return SQLQueryRecipeUtils.getDefaultConnection(recipe, liu);
        }
        if (params.mainConnectionDataset == null) {
            throw ErrorContext.iae((String)"The dataset whose connection the query should be run in is not specified (mandatory when using multiple connections).");
        }
        Optional<String> datasetRef = Stream.concat(recipe.getInputsForRole("main").stream().map(input -> input.ref), recipe.getOutputsForRole("main").stream().map(output -> output.ref)).filter(params.mainConnectionDataset::equals).findFirst();
        if (!datasetRef.isPresent()) {
            throw ErrorContext.iaef((String)"The dataset %s is not among the inputs nor output of the recipe.", (Object)params.mainConnectionDataset, (Object[])new Object[0]);
        }
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        SerializedDataset serializedDataset = (SerializedDataset)datasetsDAO.getMandatoryUnsafe(DatasetLocUtils.resolveSmart(recipe.projectKey, datasetRef.get()));
        if (!DatasetInspector.isSQL(serializedDataset)) {
            throw ErrorContext.iaef((String)"The dataset %s is not a SQL dataset.", (Object)params.mainConnectionDataset, (Object[])new Object[0]);
        }
        AbstractSQLDatasetHandler.AbstractSQLConfig config = serializedDataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        return config.connection;
    }

    public static String getDefaultConnection(SerializedRecipe recipe, AuthCtx liu) throws IOException {
        SQLConnections sourceConnections = new SQLConnections();
        for (Dataset sourceDataset : SQLQueryRecipeUtils.getSourceDatasets(recipe)) {
            String sourceDSConnection = DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(liu, sourceDataset);
            sourceConnections.add(sourceDSConnection);
        }
        SQLConnections targetConnections = SQLQueryRecipeUtils.getConnectionsFromSqlTableDatasets(SQLQueryRecipeUtils.getTargetDatasets(recipe));
        return SQLQueryRecipeUtils.getDefaultConnection(sourceConnections, targetConnections);
    }

    public static List<Dataset> getTargetDatasets(RecipeRunnableSubgraph subgraph) throws IOException {
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        ArrayList<Dataset> targetsDatasets = new ArrayList<Dataset>();
        for (FlowDataset flowDataset : subgraph.getTargetsDatasets()) {
            targetsDatasets.add(flowDataset.getMandatory(datasetsDAO));
        }
        return targetsDatasets;
    }

    public static List<Dataset> getTargetDatasets(SerializedRecipe recipe) throws IOException {
        return SQLQueryRecipeUtils.getTargetDatasetStream(recipe).map(Dataset::fromSerialized).collect(Collectors.toList());
    }

    public static Stream<SerializedDataset> getTargetDatasetStream(SerializedRecipe recipe) throws IOException {
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        ArrayList<SerializedDataset> datasets = new ArrayList<SerializedDataset>();
        for (SerializedRecipe.RecipeOutput output : recipe.getOutputsForRole("main")) {
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(recipe.projectKey, output.ref);
            SerializedDataset outputDs = (SerializedDataset)datasetsDAO.getOrNull(loc);
            if (outputDs == null) continue;
            datasets.add(outputDs);
        }
        return datasets.stream();
    }

    public static SQLConnections getConnectionsFromSqlTableDatasets(List<Dataset> datasets) {
        SQLConnections res = new SQLConnections();
        for (Dataset dataset : datasets) {
            if (!DatasetInspector.isSQLTable(dataset)) continue;
            res.add(dataset.getParams().getConnection());
        }
        return res;
    }

    public static boolean runsInSQLMode(String mainConnection, Dataset outputDataset, String sqlQuery) {
        if (DatasetHandlerFactory.getMeta(outputDataset) instanceof GenericSQLDatasetMeta) {
            if (!DatasetInspector.isSQLTable(outputDataset)) {
                throw ErrorContext.iae((String)"Can only write to a SQL dataset in TABLE mode");
            }
            AbstractSQLDatasetHandler.AbstractSQLConfig outputConfig = (AbstractSQLDatasetHandler.AbstractSQLConfig)outputDataset.getParams();
            String outputConnection = outputConfig.connection;
            if (outputConnection.equals(mainConnection)) {
                if (sqlQuery.toUpperCase().contains("SELECT")) {
                    logger.info((Object)"Running the SQL query recipe in full-SQL mode");
                    return true;
                }
                logger.info((Object)"Not running the SQL query recipe in full-SQL mode : no SELECT statement found");
            } else {
                logger.info((Object)"Not running the SQL query recipe in full-SQL mode : output connection is not the same as input");
            }
        } else {
            logger.info((Object)"Not running the SQL query recipe in full-SQL mode : output is not SQL");
        }
        return false;
    }

    public static ProcessorOutput buildProcessorOutput(AuthCtx authCtx, Dataset dataset, Partition partition, JobActivity activity, ColumnFactory cf, RowFactory rf) throws Exception {
        FlowRecipe recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        SerializedRecipe.RecipeOutput recipeOutput = null;
        block5: for (Map.Entry<String, SerializedRecipe.OutputRole> outputRole : recipe.getModel().getOutputsUnsafe().entrySet()) {
            for (SerializedRecipe.RecipeOutput output : outputRole.getValue().items) {
                String outputFullName = output.getLoc(recipe.getProjectKey()).getFullName();
                if (!outputFullName.equals(dataset.getFullName())) continue;
                recipeOutput = output;
                continue block5;
            }
        }
        if (recipeOutput == null) {
            throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "Could not find dataset " + dataset.getFullName() + " among outputs of " + recipe.getName());
        }
        Output.WriteMode wm = recipeOutput.getWriteMode();
        try (DatasetHandler handler = DatasetHandlerFactory.build(authCtx, dataset);){
            logger.info((Object)("Output handles clear " + handler.outputHandlesClear() + " ON " + String.valueOf(handler) + " wm " + String.valueOf(wm)));
            if (wm == Output.WriteMode.OVERWRITE && !handler.outputHandlesClear()) {
                FlowDataset fc = activity.getSubgraph().getTargetDataset(dataset.getFullName());
                handler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{activity.getSubgraph().getTargetPartition(fc)}));
                wm = Output.WriteMode.APPEND;
            }
        }
        ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing(authCtx, dataset, partition, cf, activity.warnContext, wm);
        return streamer.getAsOutput();
    }

    public static void streamSingleRow(SQLConnectionProvider.SQLConnectionData connData, List<Column> columns, List<SchemaColumn> schemaColumns, ResultSet rs2, ResultSetMetaData meta, RowFactory rf, ProcessorOutput out, DateTimeZone assumedTz, boolean normalizeDoubles) throws Exception {
        Row r = rf.row();
        int columnCount = Math.min(meta.getColumnCount(), columns.size());
        for (int i = 1; i <= columnCount; ++i) {
            SchemaColumn schemaColumn = schemaColumns.get(i - 1);
            String v = connData.getDialect().getValueAsDSSString(rs2, meta.getColumnType(i), i, schemaColumn, normalizeDoubles, schemaColumn.timestampNoTzAsDate, assumedTz);
            r.put(columns.get(i - 1), v);
        }
        out.emitRow(r);
    }

    public static String substituteAllAndStripComments(AuthCtx authCtx, String projectKey, RecipeRunnableSubgraph subgraph, String sqlQuery, SQLDialect dialect, boolean queryIsCommentFree) throws IOException, CodedException, DKUSecurityException {
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        HashMap<String, String> variables = new HashMap<String, String>();
        FlowVariables.addPartitioningVariables(authCtx, variables, subgraph, datasetsDAO);
        FlowVariables.addWhereClauseVariables(variables, subgraph, datasetsDAO, dialect);
        variables.putAll(FlowVariables.getSQLTableVariables(authCtx, subgraph.getRecipe().getModel()));
        VariablesContext variablesContext = variablesService.getForProject(projectKey);
        logger.info((Object)("Substituting variables in SQL query : " + JSON.pretty(variables)));
        ArrayList queryChunks = queryIsCommentFree ? Lists.newArrayList((Object[])new Splitter.QueryChunk[]{new Splitter.QueryChunk(sqlQuery, false)}) : dialect.getSplitter().chunkComments(sqlQuery);
        StringBuilder sb = new StringBuilder();
        for (Splitter.QueryChunk queryChunk : queryChunks) {
            String chunk = queryChunk.chunk;
            if (queryChunk.isComment) continue;
            chunk = FlowVariables.substitute(variables, chunk);
            chunk = variablesContext.expand(chunk);
            sb.append(chunk);
        }
        return sb.toString();
    }

    public static String substituteAllAndStripCommentsUnchecked(AuthCtx authCtx, String projectKey, RecipeRunnableSubgraph subgraph, String sqlQuery, SQLDialect dialect, boolean queryIsCommentFree) {
        try {
            return SQLQueryRecipeUtils.substituteAllAndStripComments(authCtx, projectKey, subgraph, sqlQuery, dialect, queryIsCommentFree);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to substitute", e);
        }
    }

    public static SQLUtils.SQLTable substituteAll(String projectKey, SQLUtils.SQLTable sqlTable) {
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext variablesContext = variablesService.getForProject(projectKey);
        String catalog = sqlTable.getCatalog();
        String schema = sqlTable.getSchemaNullIfBlank();
        String table = sqlTable.getTable();
        if (catalog != null) {
            catalog = variablesContext.expand(catalog);
        }
        if (schema != null) {
            schema = variablesContext.expand(schema);
        }
        if (table != null) {
            table = variablesContext.expand(table);
        }
        return new SQLUtils.SQLTable(catalog, schema, table, sqlTable.isTrueTable());
    }

    public static void killMySQLConnection(SQLConnectionProvider.SQLConnectionData connectionData, SQLConnectionProvider.SQLConnectionWrapper conn, AuthCtx authCtx, String projectKey) {
        SQLQueryRecipeUtils.killMySQLConnection(connectionData, conn.getConnectionUnsafe(true), authCtx, projectKey);
    }

    private static void killMySQLConnection(SQLConnectionProvider.SQLConnectionData connectionData, Connection conn, AuthCtx authCtx, String projectKey) {
        logger.info((Object)"Force the mysql connection to close");
        try {
            Method mysqlGetIo = conn.getClass().getMethod("getIO", new Class[0]);
            Object mysqlIo = mysqlGetIo.invoke((Object)conn, new Object[0]);
            Method mysqlGetThreadId = mysqlIo.getClass().getDeclaredMethod("getThreadId", new Class[0]);
            mysqlGetThreadId.setAccessible(true);
            Object threadId = mysqlGetThreadId.invoke(mysqlIo, new Object[0]);
            try (SQLConnectionProvider.SQLConnectionWrapper cancelConn = SQLConnectionProvider.newConnection(connectionData, authCtx, projectKey);
                 Statement cancelStmt = cancelConn.createStatement();){
                cancelStmt.execute("KILL " + String.valueOf(threadId));
            }
            catch (DKUSecurityException | InterruptedException | SQLException e) {
                logger.warn((Object)"Cannot force kill the mysql query, the cancel query failed");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
            logger.warn((Object)"Cannot force kill the mysql query, the jdbc driver is probably an old one");
        }
    }

    public static void checkConnectionUsability(Collection<String> connections, AuthCtx liu) throws SecurityException, IOException, DKUSecurityException {
        if (liu == null) {
            return;
        }
        ConnectionsDAO connectionsDAO = ConnectionsDAO.get();
        for (String connection : connections) {
            DSSConnection conn = connectionsDAO.getMandatoryConnection(liu, connection);
            if (conn.isFreelyUsableBy(liu)) continue;
            throw new SecurityException("You may not execute arbitrary SQL on connection " + conn.name);
        }
    }

    public static SQLConnections getSourceConnections(SerializedRecipe recipe) throws IOException {
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        SQLConnections connections = new SQLConnections();
        for (SerializedRecipe.RecipeInput source : recipe.getInputsForRole("main")) {
            String connection;
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(recipe.projectKey, source.ref);
            SerializedDataset sourceDS = (SerializedDataset)datasetsDAO.getOrNull(loc);
            if (sourceDS == null || (connection = sourceDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved((String)sourceDS.getProjectKey()).connection) == null) continue;
            connections.add(connection);
        }
        return connections;
    }

    public static Collection<String> getAllConnections(SerializedRecipe recipe) throws IOException {
        String connection;
        DatasetLocUtils.DatasetLoc loc;
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        HashSet conns = Sets.newHashSet();
        for (SerializedRecipe.RecipeInput source : recipe.getInputsForRole("main")) {
            loc = DatasetLocUtils.resolveSmart(recipe.projectKey, source.ref);
            SerializedDataset sourceDS = (SerializedDataset)datasetsDAO.getOrNull(loc);
            if (sourceDS == null || (connection = sourceDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved((String)sourceDS.getProjectKey()).connection) == null) continue;
            conns.add(connection);
        }
        for (SerializedRecipe.RecipeOutput target : recipe.getOutputsForRole("main")) {
            loc = DatasetLocUtils.resolveSmart(recipe.projectKey, target.ref);
            SerializedDataset targetDS = (SerializedDataset)datasetsDAO.getOrNull(loc);
            if (targetDS == null || (connection = targetDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved((String)targetDS.getProjectKey()).connection) == null) continue;
            conns.add(connection);
        }
        return conns;
    }

    public static class SQLConnections {
        public Set<String> connections = Sets.newHashSet();
        public String firstConnection;

        public void add(String connection) {
            if (this.connections.isEmpty()) {
                this.firstConnection = connection;
            }
            this.connections.add(connection);
        }
    }
}

