/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.streaming.DatasetWriter;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.eda.EDAKernelCreator;
import com.dataiku.dip.recipes.eda.EDARecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NullChecker;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class EDARecipeRunner<T extends RecipePayloadParams>
implements InitializableAbortableRecipeRunner,
RecipeRunnerWithPayload {
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.eda");
    @Autowired
    private VariablesService variablesService;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected JobAuthCtxService authCtxService;
    @Autowired
    protected SingleWriteTransactionTransactionService singleWTxService;
    protected final JobActivity activity;
    protected final RecipeRunnableSubgraph subgraph;
    protected final FlowRecipe recipe;
    protected final EDARecipeParams recipeParams;
    protected Dataset sourceDs;
    private List<Partition> sourcePartitions;
    protected T payloadParams;
    private AuthCtx authCtx;
    private boolean abortSignalReceived = false;
    private ComputationRunner edaRunner;
    protected String computationTimestamp;
    private EDAKernelCreator kernelCreator;

    public EDARecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
        this.recipeParams = this.recipe.getModel().getParamsAs(EDARecipeParams.class);
        this.kernelCreator = new EDAKernelCreator();
        SpringUtils.getInstance().autowire((Object)this);
        activity.initStatus();
    }

    @VisibleForTesting
    void setKernelCreator(EDAKernelCreator kernelCreator) {
        this.kernelCreator = kernelCreator;
    }

    @Override
    public void setPayload(String payload) {
        this.payloadParams = this.parsePayload(payload);
    }

    protected abstract T parsePayload(String var1);

    @Override
    public void init() throws Exception {
        this.activity.setStatusMessage("Initializing");
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.authCtx = this.authCtxService.getAuthCtx();
        this.validateRecipe();
        PreRunSchemaPropagationHandler handler = new PreRunSchemaPropagationHandler(this.activity, this.recipe);
        SerializedRecipe.SerializedRecipeAndPayload srp = handler.propagateIfNeeded();
        if (srp != null && srp.payload != null) {
            this.setPayload(srp.payload);
        }
        Objects.requireNonNull(this.payloadParams, "Payload parameters must be set");
        NullChecker.checkObject(this.payloadParams);
        ((RecipePayloadParams)this.payloadParams).validate();
        FlowDataset sourceFDs = this.subgraph.getSingleSourceDataset();
        this.sourceDs = sourceFDs.getMandatoryUnsafe(this.datasetsDAO);
        this.sourcePartitions = this.subgraph.getSourcePartitions(sourceFDs);
    }

    private StreamableDatasetSelection getDatasetSelection() {
        StreamableDatasetSelection datasetSelection = (StreamableDatasetSelection)((Object)JSON.deepCopy((Object)((Object)this.recipeParams.getDatasetSelection())));
        VariablesContext vc = this.variablesService.getForProject(this.recipe.getProjectKey());
        FilterDescUtils.expand(datasetSelection.filter, vc);
        if (this.sourceDs.getPartitioningSchema().isPartitioned()) {
            datasetSelection.withSelectedPartitions(this.sourcePartitions);
        }
        return datasetSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        this.activity.setStatusMessage("Filling job context");
        JobActivity.ActivityRunSummary summary = JobContext.getCurrentActivitySummary();
        summary.engineType = "DSS";
        ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().select_autoTXN(this.authCtx, this.recipe.getProjectKey(), this.recipeParams.getContainerSelection());
        if (containerConfig != null) {
            summary.containerConfType = containerConfig.type.name();
        }
        Computation computationPlan = this.getComputationPlan();
        StreamableDatasetSelection datasetSelection = this.getDatasetSelection();
        this.activity.setStatusMessage("Running the computation");
        this.singleWTxService.stashTheSingleTransaction();
        try {
            this.edaRunner = this.kernelCreator.createEDARunner_NT(this.authCtx, this.recipe.getProjectKey(), this.sourceDs, datasetSelection, containerConfig);
            try (ComputationResultSession session = this.edaRunner.computeAndOpenSession(computationPlan);){
                ComputationResult result = session.getComputationResult();
                EDARecipeRunner.requireAvailable(result);
                this.fillWarnings(result);
                this.activity.setStatusMessage("Writing output datasets");
                this.computationTimestamp = DKUDateUtils.isoFormatUTCNow();
                this.singleWTxService.unstashTheSingleTransaction();
                try {
                    this.writeOutputs(session);
                }
                finally {
                    this.singleWTxService.stashTheSingleTransaction();
                }
            }
        }
        catch (Exception e) {
            if (this.abortSignalReceived) {
                logger.warn((Object)"Caught error while aborting", (Throwable)e);
                throw new ActivityAbortedException();
            }
            throw e;
        }
        finally {
            if (this.edaRunner != null && this.edaRunner.isAlive()) {
                this.edaRunner.close();
            }
            this.singleWTxService.unstashTheSingleTransaction();
        }
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        EDARecipeRunner eDARecipeRunner = this;
        synchronized (eDARecipeRunner) {
            if (this.abortSignalReceived) {
                return;
            }
            this.abortSignalReceived = true;
        }
        try {
            ComputationRunner runner = this.edaRunner;
            if (runner == null || !runner.isAlive()) {
                return;
            }
            runner.close();
        }
        catch (Exception e) {
            logger.error((Object)"Could not close the EDA runner", (Throwable)e);
        }
    }

    protected void validateRecipe() {
        this.recipe.validateExactly1Source();
    }

    protected final boolean hasRecipeOutput(String role) {
        List<SerializedRecipe.RecipeOutput> outputs = this.recipe.getModel().getOutputsForRole(role);
        return !outputs.isEmpty();
    }

    private static void requireAvailable(ComputationResult result) {
        NullChecker.checkObject((Object)((Object)result));
        if (result.isFailed()) {
            throw new IllegalArgumentException(String.format("Computation error: %s", result.asFailed().message));
        }
    }

    private void fillWarnings(ComputationResult result) {
        for (String warning : result.collectWarnings()) {
            this.activity.warnContext.addWarning(WarningsContext.WarningType.STATISTICS_ENGINE_ISSUE, warning, null);
        }
        for (String error : result.collectErrors()) {
            this.activity.warnContext.addWarning(WarningsContext.WarningType.STATISTICS_ENGINE_ISSUE, error, null);
        }
    }

    protected final ProcessorOutput buildOutputDatasetWriter(String role, ColumnFactory cf) throws Exception {
        Output.WriteMode writeMode = this.recipe.getModel().getSingleOutput(role).getWriteMode();
        FlowDataset flowDataset = this.subgraph.getSingleTargetDatasetForRole(role);
        Dataset dataset = flowDataset.getMandatory(this.datasetsDAO);
        Partition partition = this.subgraph.getTargetPartition(flowDataset);
        writeMode = DatasetWriter.getWriteModeAfterDatasetCleanup(dataset, partition, writeMode, this.authCtx);
        ToDatasetStreamer dsStreamer = ToDatasetStreamer.newWithAutoBucketing(this.authCtx, dataset, partition, cf, this.activity.warnContext, writeMode);
        return dsStreamer.getAsOutput();
    }

    protected final ProcessorOutput buildMainOutputDatasetWriter(ColumnFactory cf) throws Exception {
        return this.buildOutputDatasetWriter("main", cf);
    }

    protected abstract Computation getComputationPlan();

    protected abstract void writeOutputs(ComputationResultSession var1) throws Exception;
}

