/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.filtering.IntervalFilter;

public final class FilterFormatter {
    private FilterFormatter() {
    }

    public static String formatValue(AnumFilter anumFilter) {
        return String.join((CharSequence)", ", anumFilter.values);
    }

    public static String formatValue(IntervalFilter intervalFilter) {
        String left = intervalFilter.left > -1.7976931348623157E308 ? Double.toString(intervalFilter.left) : "-\u221e";
        String right = intervalFilter.right < Double.MAX_VALUE ? Double.toString(intervalFilter.right) : "+\u221e";
        switch (intervalFilter.closed) {
            case LEFT: {
                return String.format("[%s, %s)", left, right);
            }
            case RIGHT: {
                return String.format("(%s, %s]", left, right);
            }
            case BOTH: {
                return String.format("[%s, %s]", left, right);
            }
            case NEITHER: {
                return String.format("(%s, %s)", left, right);
            }
        }
        throw new RuntimeException(String.format("Unexpected closed mode for interval filter: %s", new Object[]{intervalFilter.closed}));
    }
}

