/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.eda.EDASchemaColumns;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

@UIModel
public class PCARecipePayloadParams
extends RecipePayloadParams {
    public static final String FORWARDED_COLUMNS_PREFIX = "input_";
    public List<String> columns = new ArrayList<String>();
    public List<String> forwardedColumns = new ArrayList<String>();
    public boolean addComputationTimestamp = false;

    public PCARecipePayloadParams(List<String> columns) {
        this.columns = columns;
    }

    public PCARecipePayloadParams() {
    }

    @Override
    public void validate() {
        if (this.columns.isEmpty()) {
            throw ErrorContext.iae((String)"The recipe settings must include at least one column from the input dataset");
        }
    }

    public ProjectionsSchemaDetails computeProjectionsSchema(Schema inputSchema) {
        SchemaColumn column;
        HashSet<String> computedColumnNames = new HashSet<String>();
        LinkedList<String> fetchableColumnNames = new LinkedList<String>();
        LinkedList<SchemaColumn> schemaColumns = new LinkedList<SchemaColumn>();
        int i = 0;
        for (SchemaColumn sc : inputSchema.columns) {
            if (!this.columns.contains(sc.getName())) continue;
            String pcName = EDASchemaColumns.principalComponent(i);
            fetchableColumnNames.add(pcName);
            computedColumnNames.add(pcName);
            column = new SchemaColumn(pcName, Type.DOUBLE);
            schemaColumns.add(column);
            ++i;
        }
        if (this.addComputationTimestamp) {
            computedColumnNames.add("computation_timestamp");
            column = new SchemaColumn("computation_timestamp", Type.DATE);
            schemaColumns.add(column);
        }
        i = 0;
        for (SchemaColumn sc : inputSchema.columns) {
            if (!this.forwardedColumns.contains(sc.getName())) continue;
            String forwardedColumnName = EDASchemaColumns.forwardedColumn(sc.getName(), FORWARDED_COLUMNS_PREFIX);
            fetchableColumnNames.add(i, forwardedColumnName);
            String conflictFreeName = computedColumnNames.contains(sc.getName()) ? forwardedColumnName : sc.getName();
            column = SchemaColumn.copyWithNewName((String)conflictFreeName, (SchemaColumn)sc);
            schemaColumns.add(i, column);
            ++i;
        }
        return new ProjectionsSchemaDetails(schemaColumns, fetchableColumnNames);
    }

    public static class ProjectionsSchemaDetails {
        public final List<SchemaColumn> schemaColumns;
        public final List<String> fetchableColumnNames;

        public ProjectionsSchemaDetails(List<SchemaColumn> schemaColumns, List<String> fetchableColumnNames) {
            this.schemaColumns = schemaColumns;
            this.fetchableColumnNames = fetchableColumnNames;
        }
    }
}

