/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.evaluation;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.model.core.GenAiCustomEvaluationMetric;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.FinalCommitable;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dss.shadelibpoi.org.apache.commons.collections4.CollectionUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGenAIEvaluationRecipeRunner
implements InitializableAbortableRecipeRunner,
RecipeRunnerWithPayload,
FlowRunnable,
FinalCommitable {
    protected final FlowRecipe recipe;
    protected final JobActivity activity;
    protected final RecipeRunnableSubgraph subgraph;
    @Autowired
    private DatasetsDAO datasetsDAO;

    public AbstractGenAIEvaluationRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
        this.activity.initStatus();
    }

    protected GenAiEvaluationRecipeInputAndOutputs getRecipeInputAndOutputs() throws IOException {
        SerializedRecipe.RecipeInput recipeInput = this.recipe.getModel().getSingleInput("main");
        SerializedDataset serializedInputDataset = (SerializedDataset)this.datasetsDAO.getMandatory(recipeInput.getLoc(this.recipe.getProjectKey()));
        Dataset inputDataset = Dataset.fromSerialized(serializedInputDataset);
        SerializedRecipe.RecipeOutput outputDatasetRO = this.recipe.getModel().getSingleOutputOrNull("main");
        String outputDatasetSmartName = outputDatasetRO != null ? outputDatasetRO.getLoc(this.recipe.getProjectKey()).getSmartName(this.recipe.getProjectKey()) : null;
        SerializedRecipe.RecipeOutput metricsDatasetRO = this.recipe.getModel().getSingleOutputOrNull("metrics");
        String metricsDatasetSmartName = metricsDatasetRO != null ? metricsDatasetRO.getLoc(this.recipe.getProjectKey()).getSmartName(this.recipe.getProjectKey()) : null;
        SerializedRecipe.RecipeOutput mesRO = this.recipe.getModel().getSingleOutputOrNull("evaluationStore");
        AnyLoc evaluationStoreLoc = mesRO != null ? mesRO.getLoc(this.recipe.getProjectKey()) : null;
        return new GenAiEvaluationRecipeInputAndOutputs(inputDataset, outputDatasetSmartName, metricsDatasetSmartName, evaluationStoreLoc);
    }

    protected static int getRagasMaxWorkers(@Nullable Integer descMaxWorkers) {
        if (descMaxWorkers == null) {
            return ApplicationConfigurator.getProperty((String)"dku.llmEvaluation.defaultRagasMaxWorkers", (int)9);
        }
        if (descMaxWorkers < 1) {
            throw new IllegalArgumentException("The max number of workers for RAGAS metric computation must be equal to or greater than 1. Please review your advanced recipe configuration.");
        }
        return descMaxWorkers;
    }

    protected static void validateCustomMetrics(AuthCtx authCtx, Collection<GenAiCustomEvaluationMetric> customMetrics) throws UnauthorizedException {
        List<GenAiCustomEvaluationMetric> wrongMinMax;
        if (CollectionUtils.isNotEmpty(customMetrics)) {
            authCtx.failIfNoSafeCode("You do not have the required permission to run code");
        }
        if (!(wrongMinMax = customMetrics.stream().filter(cm -> cm.minValue != null && cm.maxValue != null && cm.minValue > cm.maxValue).toList()).isEmpty()) {
            throw new IllegalArgumentException("Some Custom Metrics have a Minimum value greater than the Maximum value.");
        }
    }

    protected record GenAiEvaluationRecipeInputAndOutputs(@Nonnull Dataset inputDataset, @Nullable String outputDatasetSmartName, @Nullable String metricsDatasetSmartName, @Nullable AnyLoc evaluationStoreLoc) {
    }
}

