/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.evaluation;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.llm.LLMStructuredRef;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class GenAIEvaluationUtils {
    public static final List<SchemaColumn> BERT_SCORE_METRIC_SCHEMA_COLUMNS = List.of(new SchemaColumn("bertScorePrecision", Type.DOUBLE), new SchemaColumn("bertScoreRecall", Type.DOUBLE), new SchemaColumn("bertScoreF1", Type.DOUBLE));
    public static final List<SchemaColumn> ROUGE_METRIC_SCHEMA_COLUMNS = List.of(new SchemaColumn("rouge1Precision", Type.DOUBLE), new SchemaColumn("rouge1Recall", Type.DOUBLE), new SchemaColumn("rouge1F1", Type.DOUBLE), new SchemaColumn("rouge2Precision", Type.DOUBLE), new SchemaColumn("rouge2Recall", Type.DOUBLE), new SchemaColumn("rouge2F1", Type.DOUBLE), new SchemaColumn("rougeLPrecision", Type.DOUBLE), new SchemaColumn("rougeLRecall", Type.DOUBLE), new SchemaColumn("rougeLF1", Type.DOUBLE));
    public static final List<SchemaColumn> TOKEN_COUNT_METRIC_OUTPUT_SCHEMA_COLUMNS = List.of(new SchemaColumn("inputTokensPerRow", Type.INT), new SchemaColumn("outputTokensPerRow", Type.INT));
    public static final List<SchemaColumn> TOKEN_COUNT_METRIC_METRIC_SCHEMA_COLUMNS = List.of(new SchemaColumn("inputTokensPerRow", Type.DOUBLE), new SchemaColumn("outputTokensPerRow", Type.DOUBLE));
    public static final List<SchemaColumn> TOOLS_STATISTICS_METRIC_SCHEMA_COLUMNS = List.of(new SchemaColumn("totalToolExecutions", Type.INT), new SchemaColumn("totalFailedToolExecutions", Type.INT), new SchemaColumn("totalToolExecutionTimeSeconds", Type.DOUBLE));
    public static final List<SchemaColumn> TOOLS_STATISTICS_METRIC_METRIC_SCHEMA_COLUMNS = List.of(new SchemaColumn("averageToolExecutionsPerRow", Type.DOUBLE), new SchemaColumn("averageFailedToolExecutionsPerRow", Type.DOUBLE), new SchemaColumn("averageToolExecutionTimeSecondsPerRow", Type.DOUBLE));
    public static final List<SchemaColumn> TOOL_CALL_METRIC_SCHEMA_COLUMNS = List.of(new SchemaColumn("toolCallPrecision", Type.DOUBLE), new SchemaColumn("toolCallRecall", Type.DOUBLE), new SchemaColumn("toolCallF1", Type.DOUBLE));
    public static final String PARSED_OUTPUT_NAME = "dkuParsedOutput";
    public static final String PARSED_CONTEXT_NAME = "dkuParsedContexts";
    public static final String RECONSTRUCTED_INPUT_NAME = "dkuReconstructedInput";
    public static final String PARSED_TOOL_CALLS_NAME = "dkuParsedToolCalls";
    public static final String PARSED_TRAJECTORY_NAME = "dkuParsedTrajectory";

    private GenAIEvaluationUtils() {
    }

    public static String remapConnectionOfLLMId(String llmId, Map<String, String> replacements) {
        if (StringUtils.isEmpty((String)llmId) || "None".equals(llmId)) {
            return llmId;
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(llmId);
        if (ref.connection == null) {
            return llmId;
        }
        String newValue = replacements.get(ref.connection);
        if (newValue != null) {
            ref.setConnection(newValue);
        }
        return ref.encodeToId();
    }

    public static Optional<String> getLLMConnection(String llmId) {
        if (StringUtils.isEmpty((String)llmId) || "None".equals(llmId)) {
            return Optional.empty();
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(llmId);
        if (ref.connection == null || ref.connection.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ref.connection);
    }
}

