/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.sql.NonLoopingSQLEngineVisualRecipeRunner;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.shaker.AbstractShakerRecipeSQLRunner;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.sql.ShakerSQLTranslator;
import com.dataiku.dip.shaker.sql.SqlQueryWithSchemaBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ShakerRecipeSQLRunner
extends AbstractShakerRecipeSQLRunner {
    private static Logger logger = Logger.getLogger((String)"dku.flow.shaker.sql");

    ShakerRecipeSQLRunner(JobActivity activity) {
        super(activity);
        this.sqlQueryWithSchemaBuilder = new SqlQueryWithSchemaBuilder(this.activity);
    }

    @Override
    protected String getEngineType() {
        return "SQL";
    }

    @Override
    protected AbortableRecipeRunner buildRecipeRunner(final ShakerSQLTranslator.TranslatorResult translatorResult) throws Exception {
        NonLoopingSQLEngineVisualRecipeRunner runner = new NonLoopingSQLEngineVisualRecipeRunner(this.activity){

            @Override
            protected QueryBunch getQueryBunch(AbstractSQLConnection conn) {
                QueryBunch ret = new QueryBunch();
                if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
                    PrepareSnowflakeUDFUtils.fillPrePostQueriesForUDF(conn, translatorResult, ret.preQueries, ret.postQueries);
                }
                ret.query = translatorResult.translated.toSQL(conn.getDialect());
                return ret;
            }
        };
        runner.init();
        return runner;
    }

    public static List<ProcessorScriptStep> getFlattenedEnabledProcessorsList(List<ScriptStep> rawSteps) {
        ArrayList<ProcessorScriptStep> ret = new ArrayList<ProcessorScriptStep>();
        for (ScriptStep ss : rawSteps) {
            if (ss.metaType == ScriptStep.MetaType.GROUP && !ss.disabled) {
                for (ProcessorScriptStep pss : ((GroupScriptStep)ss).steps) {
                    if (pss.disabled) continue;
                    ret.add(pss);
                }
                continue;
            }
            if (ss.disabled) continue;
            ret.add((ProcessorScriptStep)ss);
        }
        return ret;
    }
}

