/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.python;

import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.recipes.streaming.AbstractCodeBasedContinuousActivityRunner;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractPythonContinuousRecipeRunner
extends AbstractCodeBasedContinuousActivityRunner {
    private CodeEnvResolutionService codeEnvResolutionService = (CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class);

    public AbstractPythonContinuousRecipeRunner(ContinuousActivity activity, SerializedRecipe sr) {
        super(activity, sr);
    }

    protected List<String> getPythonCmd(String projectKey, String envName, List<String> args) throws IOException {
        return this.codeEnvResolutionService.getPythonCmd(envName, projectKey, args);
    }

    protected void executeScript(String envName, File tmpDirectory, File scriptFile, int nbReplicas, int replicaIndex, int restartCount) throws Exception {
        String wrapperContent = DKUtils.getResourceFileContentUTF8((String)"com/dataiku/dip/dataflow/exec/python-exec-wrapper.py");
        File wrapperFile = new File(tmpDirectory, "python-exec-wrapper.py");
        DKUFileUtils.writeFileUTF8((File)wrapperFile, (String)wrapperContent);
        HashMap extraEnv = Maps.newHashMap();
        extraEnv.put("DKU_REPLICA_COUNT", Integer.toString(nbReplicas));
        extraEnv.put("DKU_REPLICA_INDEX", Integer.toString(replicaIndex));
        extraEnv.put("DKU_REPLICA_RESTARTS", Integer.toString(restartCount));
        this.writeRemoteRunEnvDefForLocalExecution(tmpDirectory, extraEnv, envName);
        ArrayList args = Lists.newArrayList((Object[])new String[]{wrapperFile.getAbsolutePath(), scriptFile.getAbsolutePath()});
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(tmpDirectory);
        builder.command(this.getPythonCmd(this.projectKey, envName, args));
        builder.environment().putAll(this.codeEnvResolutionService.getEnvironmentVariablesForPythonCmd(envName, this.projectKey));
        this.executeLocal(builder, null, "Python", GeneralSettingsDAO.CGrouppableProcessType.PYTHON_R_RECIPE, false, new File(tmpDirectory, "process-out" + (String)(nbReplicas <= 1 ? "" : "-" + replicaIndex) + ".log"));
    }

    protected void executeModule(String envName, File tmpDirectory, String module, String ... params) throws Exception {
        ArrayList args = Lists.newArrayList((Object[])new String[]{"-m", module});
        for (String arg : params) {
            args.add(arg);
        }
        this.writeRemoteRunEnvDefForLocalExecution(tmpDirectory, Maps.newHashMap(), envName);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(tmpDirectory);
        builder.command(this.getPythonCmd(this.projectKey, envName, args));
        builder.environment().putAll(this.codeEnvResolutionService.getEnvironmentVariablesForPythonCmd(envName, this.projectKey));
        this.executeLocal(builder, null, "Python", GeneralSettingsDAO.CGrouppableProcessType.PYTHON_R_RECIPE, false, new File(tmpDirectory, "process-out.log"));
    }
}

