/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ModelVersionDeletedEvent;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.LockablePythonLogsService;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SavedModelsAgentsService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private LockablePythonLogsService pythonLogsService;
    @Autowired
    private DSSInternalCodeEnvsService dssInternalCodeEnvsService;
    public static String DEFAULT_QUICKTEST_QUERY = "{\n   \"messages\": [      {         \"role\": \"user\",         \"content\": \"Put your query here\"      }   ],   \"context\": {}}";
    static DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.service");

    public SavedModel createAgent(AuthCtx authCtx, String projectKey, SavedModel.SavedModelType type, String name, String zoneId) throws Exception {
        SavedModel sm = new SavedModel();
        sm.projectKey = projectKey;
        sm.id = SecretKeyGenerator.generate((int)8);
        sm.name = name;
        sm.savedModelType = type;
        File targetSMFolder = MLPaths.savedModelBaseFolder(sm.projectKey, sm.id);
        DKUFileUtils.mkdirs((File)targetSMFolder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(targetSMFolder);
        FilesystemACLUtils.grantFSReadACLs(authCtx, sm.projectKey, targetSMFolder);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.savedModelsDAO.getOrNull(sm.projectKey, sm.id) != null) {
                throw new IllegalArgumentException("Agent " + sm.id + " already exists");
            }
            this.savedModelsCRUDService.save(sm, true, false);
            if (StringUtils.isNotBlank((String)zoneId)) {
                this.flowZonesService.attachObjectToZone(zoneId, projectKey, sm, true);
            }
            t.commit("Created Agent: " + name + ": " + sm.id);
            SavedModel savedModel = sm;
            return savedModel;
        }
    }

    public FullModelId createAgentVersion(AuthCtx authCtx, SavedModel sm, String versionId, SavedModel.SavedModelInlineVersion smiv) throws Exception {
        if (sm.savedModelType == SavedModel.SavedModelType.PLUGIN_AGENT) {
            throw new IllegalArgumentException("Plugin agents do not support versioning");
        }
        StringTransmogrifier transmogrifier = new StringTransmogrifier("_");
        List usedIds = sm.inlineVersions.stream().map(version -> version.versionId).collect(Collectors.toList());
        transmogrifier.addAllAlreadyTransmogrifiedAcceptDupes(usedIds);
        smiv.versionId = versionId = transmogrifier.transmogrify(versionId);
        smiv.creationTag = new VersionTag(authCtx.getIdentifier());
        smiv.versionTag = new VersionTag(authCtx.getIdentifier());
        if (smiv.quickTestQuery == null || StringUtils.isBlank((String)smiv.quickTestQuery.toString())) {
            smiv.quickTestQuery = JsonParser.parseString((String)DEFAULT_QUICKTEST_QUERY).getAsJsonObject();
        }
        if (sm.savedModelType == SavedModel.SavedModelType.PYTHON_AGENT && smiv.pythonAgentSettings != null && smiv.pythonAgentSettings.codeEnvSelection != null && smiv.pythonAgentSettings.codeEnvSelection.envName == null) {
            String defaultEnvName = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.getDefaultRetrievableKnowledgeCodeEnv();
            if (!DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.RAG_CODE_ENV).equals(defaultEnvName) || this.dssInternalCodeEnvsService.getCodeEnv_NT(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.RAG_CODE_ENV).isPresent()) {
                smiv.pythonAgentSettings.codeEnvSelection = CodeEnvSelection.explicitEnv(defaultEnvName);
            }
        }
        sm.inlineVersions.add(smiv);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.savedModelsDAO.getOrNull(sm.projectKey, sm.id) == null) {
                throw new IllegalArgumentException("Saved model " + sm.id + " does not exist");
            }
            if (sm.inlineVersions.size() == 1) {
                sm.activeVersion = versionId;
            }
            this.savedModelsCRUDService.save(sm, false, false);
            t.commit("Added Agent version: " + sm.id + " / Version: " + versionId);
        }
        return new FullModelId(sm.projectKey, sm.id, versionId);
    }

    public SavedModel createPluginAgentAndVersion(AuthCtx authCtx, String projectKey, String pluginAgentType, String name, String zoneId) throws Exception {
        SavedModel sm = new SavedModel();
        sm.projectKey = projectKey;
        sm.id = SecretKeyGenerator.generate((int)8);
        sm.name = name;
        sm.savedModelType = SavedModel.SavedModelType.PLUGIN_AGENT;
        File targetSMFolder = MLPaths.savedModelBaseFolder(sm.projectKey, sm.id);
        DKUFileUtils.mkdirs((File)targetSMFolder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(targetSMFolder);
        FilesystemACLUtils.grantFSReadACLs(authCtx, sm.projectKey, targetSMFolder);
        SavedModel.SavedModelInlineVersion smiv = new SavedModel.SavedModelInlineVersion();
        smiv.pluginAgentType = pluginAgentType;
        smiv.pluginAgentConfig = new JsonObject();
        smiv.versionId = "v1";
        smiv.creationTag = new VersionTag(authCtx.getIdentifier());
        smiv.versionTag = new VersionTag(authCtx.getIdentifier());
        smiv.quickTestQuery = JsonParser.parseString((String)DEFAULT_QUICKTEST_QUERY).getAsJsonObject();
        sm.inlineVersions.add(smiv);
        sm.activeVersion = smiv.versionId;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.savedModelsDAO.getOrNull(sm.projectKey, sm.id) != null) {
                throw new IllegalArgumentException("Agent " + sm.id + " already exists");
            }
            this.savedModelsCRUDService.save(sm, true, false);
            if (StringUtils.isNotBlank((String)zoneId)) {
                this.flowZonesService.attachObjectToZone(zoneId, projectKey, sm, true);
            }
            t.commit("Created Agent: " + name + ": " + sm.id);
            SavedModel savedModel = sm;
            return savedModel;
        }
    }

    public SavedModel createToolsUsingAgentAndVersion(AuthCtx authCtx, String projectKey, String name, String zoneId) throws Exception {
        SavedModel sm = new SavedModel();
        sm.projectKey = projectKey;
        sm.id = SecretKeyGenerator.generate((int)8);
        sm.name = name;
        sm.savedModelType = SavedModel.SavedModelType.TOOLS_USING_AGENT;
        File targetSMFolder = MLPaths.savedModelBaseFolder(sm.projectKey, sm.id);
        DKUFileUtils.mkdirs((File)targetSMFolder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(targetSMFolder);
        FilesystemACLUtils.grantFSReadACLs(authCtx, sm.projectKey, targetSMFolder);
        SavedModel.SavedModelInlineVersion smiv = new SavedModel.SavedModelInlineVersion();
        smiv.versionId = "v1";
        smiv.creationTag = new VersionTag(authCtx.getIdentifier());
        smiv.versionTag = new VersionTag(authCtx.getIdentifier());
        smiv.quickTestQuery = JsonParser.parseString((String)DEFAULT_QUICKTEST_QUERY).getAsJsonObject();
        sm.inlineVersions.add(smiv);
        sm.activeVersion = smiv.versionId;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.savedModelsDAO.getOrNull(sm.projectKey, sm.id) != null) {
                throw new IllegalArgumentException("Agent " + sm.id + " already exists");
            }
            this.savedModelsCRUDService.save(sm, true, false);
            if (StringUtils.isNotBlank((String)zoneId)) {
                this.flowZonesService.attachObjectToZone(zoneId, projectKey, sm, true);
            }
            t.commit("Created Agent: " + name + ": " + sm.id);
            SavedModel savedModel = sm;
            return savedModel;
        }
    }

    public FullModelId duplicateAgentVersion(AuthCtx authCtx, SavedModel sm, String versionIdToCopy, String newVersionId) throws Exception {
        SavedModel.SavedModelInlineVersion targetVersion = sm.getVersion(versionIdToCopy).orElseThrow(() -> new IllegalArgumentException("Can't find model version: " + versionIdToCopy));
        StringTransmogrifier transmogrifier = new StringTransmogrifier("_");
        List usedIds = sm.inlineVersions.stream().map(version -> version.versionId).collect(Collectors.toList());
        transmogrifier.addAllAlreadyTransmogrifiedAcceptDupes(usedIds);
        newVersionId = transmogrifier.transmogrify(newVersionId);
        SavedModel.SavedModelInlineVersion duplicatedVersion = new SavedModel.SavedModelInlineVersion(targetVersion);
        duplicatedVersion.versionId = newVersionId;
        duplicatedVersion.versionTag = duplicatedVersion.creationTag = new VersionTag(authCtx.getIdentifier());
        if (duplicatedVersion.quickTestQuery == null) {
            duplicatedVersion.quickTestQuery = JsonParser.parseString((String)DEFAULT_QUICKTEST_QUERY).getAsJsonObject();
        }
        sm.inlineVersions.add(duplicatedVersion);
        this.savedModelsCRUDService.save(sm, true, false);
        return new FullModelId(sm.projectKey, sm.id, newVersionId);
    }

    public void setAgentVersionActive(SavedModel sm, String versionId) throws Exception {
        boolean changed;
        boolean bl = changed = sm.activeVersion == null || !StringUtils.equals((String)sm.activeVersion, (String)versionId);
        if (changed) {
            if (StringUtils.isBlank((String)versionId)) {
                throw ErrorContext.iaef((String)"The new active version to set (%s) is not valid", (Object)versionId, (Object[])new Object[0]);
            }
            if (sm.getVersion(versionId).isEmpty()) {
                throw new IllegalArgumentException("Can't find model version: " + versionId);
            }
            sm.activeVersion = versionId;
            this.savedModelsCRUDService.save(sm, false, false);
        }
    }

    public void deleteAgentVersion(SavedModel sm, String versionId) throws Exception {
        if (StringUtils.equals((String)sm.activeVersion, (String)versionId)) {
            throw new IllegalArgumentException("Cannot delete the active version");
        }
        int nbVersions = sm.inlineVersions.size();
        List filteredVersions = sm.inlineVersions.stream().filter(version -> versionId != null && !versionId.equals(version.versionId)).collect(Collectors.toList());
        if (filteredVersions.size() == nbVersions) {
            throw new IllegalArgumentException("Can't find model version: " + versionId);
        }
        sm.inlineVersions = filteredVersions;
        this.savedModelsCRUDService.save(sm, false, false);
        this.pubSub.publishAfterTransaction((DSSEvent)new ModelVersionDeletedEvent(new FullModelId(sm.getProjectKey(), sm.getId(), versionId).toString()));
    }

    public SavedModel save(AuthCtx authCtx, SavedModel sm, @Nullable String versionId) throws Exception {
        if (versionId != null) {
            SavedModel preExisting = (SavedModel)this.savedModelsDAO.getMandatory(sm.projectKey, sm.id);
            SavedModel.SavedModelInlineVersion preExistingInlineVersion = preExisting.getVersion(versionId).orElseThrow(() -> new IllegalArgumentException("Agent version " + versionId + " does not exist."));
            SavedModel.SavedModelInlineVersion currentInlineVersion = sm.getVersion(versionId).orElseThrow(() -> new IllegalArgumentException("Agent version " + versionId + " does not exist."));
            currentInlineVersion.versionTag = VersionTag.increment(preExistingInlineVersion.versionTag, authCtx.getIdentifier());
            currentInlineVersion.creationTag = (VersionTag)JSON.deepCopy((Object)preExistingInlineVersion.creationTag);
        }
        return this.savedModelsCRUDService.save(sm, false, false);
    }

    public List<LogsService.LogDesc> listLogs(String projectKey, String smId, String versionId) throws IOException {
        File logsDir = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs"});
        return this.pythonLogsService.listLogs(logsDir);
    }

    public SmartLogTail getLog(String projectKey, String smId, String versionId, String logName) throws IOException {
        File logFile = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs", logName});
        return this.pythonLogsService.getLog(logFile);
    }

    public void deleteLog(String projectKey, String smId, String versionId, String logName) throws IOException {
        File logFile = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs", logName});
        this.pythonLogsService.deleteLog(logFile);
    }

    public void clearLogs(String projectKey, String smId, String versionId) throws IOException {
        File logDir = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs"});
        this.pythonLogsService.clearLogs(logDir);
    }

    public void streamLog(String projectKey, String smId, String versionId, String logName, OutputStream os) throws IOException {
        File logFile = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs", logName});
        this.pythonLogsService.streamLog(logFile, os);
    }
}

