/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomJavaElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.scheduler.runnables.DSSRunnableRegistry;
import com.dataiku.dip.scheduler.runnables.JavaRunnableDesc;
import com.dataiku.dip.scheduler.runnables.JavaRunnableMeta;
import com.dataiku.dip.scheduler.runnables.LoadedJavaRunnable;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.reflect.TypeToken;
import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.dss.shadelib.com.google.gson.JsonObject;
import com.dataiku.dss.shadelib.com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomJavaRunnablesService
extends CustomJavaElementService<JavaRunnableDesc, LoadedJavaRunnable> {
    @Override
    public String getFolderName() {
        return "java-runnables";
    }

    @Override
    public String getPrefix() {
        return "runnable";
    }

    @Override
    protected String getCodeExtension(LoadedJavaRunnable desc) {
        return ".java";
    }

    @Override
    public Class<JavaRunnableDesc> getDescClass() {
        return JavaRunnableDesc.class;
    }

    @Override
    public Class<LoadedJavaRunnable> getLoadedDescClass() {
        return LoadedJavaRunnable.class;
    }

    @Override
    protected void removeElement(LoadedJavaRunnable desc) {
        DSSRunnableRegistry.deregister(desc.runnableType);
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "jrunnable_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedJavaRunnable load(String elementType, String pluginId, String elementId, File file) throws IOException {
        File ldFile;
        LoadedJavaRunnable loaded = new LoadedJavaRunnable(elementType, pluginId, elementId, (JavaRunnableDesc)JSON.parseFile((File)file, JavaRunnableDesc.class));
        if (StringUtils.isBlank((String)((JavaRunnableDesc)loaded.desc).longDescription) && (ldFile = new File(file.getParent(), "long-description.md")).isFile()) {
            ((JavaRunnableDesc)loaded.desc).longDescription = DKUFileUtils.readFileToStringUTF8((File)ldFile);
        }
        if (StringUtils.isBlank((String)((JavaRunnableDesc)loaded.desc).longDescription)) {
            ((JavaRunnableDesc)loaded.desc).longDescription = ((JavaRunnableDesc)loaded.desc).meta.description;
        }
        if (((JavaRunnableDesc)loaded.desc).permissions.contains(null)) {
            ((JavaRunnableDesc)loaded.desc).permissions = ((JavaRunnableDesc)loaded.desc).permissions.stream().filter(Objects::nonNull).collect(Collectors.toList());
            JsonObject jsonObj = JsonParser.parseReader((Reader)new FileReader(file)).getAsJsonObject();
            List originalPermissions = (List)new Gson().fromJson(jsonObj.get("permissions"), new TypeToken<List<String>>(){}.getType());
            originalPermissions.removeAll(((JavaRunnableDesc)loaded.desc).permissions.stream().map(Enum::toString).collect(Collectors.toList()));
            throw new JsonSyntaxException("Invalid permission(s) '" + String.join((CharSequence)"', '", originalPermissions) + "' referenced in java runnable '" + pluginId + "'");
        }
        JavaRunnableMeta stepMeta = new JavaRunnableMeta(loaded, this);
        DSSRunnableRegistry.register(stepMeta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final JavaRunnableDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomJavaRunnablesService.this.getPrefix());
                }
                if (desc.adminParams != null) {
                    this.genericValidateParams(desc.adminParams, CustomJavaRunnablesService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                if (StringUtils.isBlank((String)desc.runnableClass)) {
                    this.withFatal("Java plugin macros require a \"runnableClass\" field.");
                }
                return this.messages;
            }
        }.validate();
    }
}

