/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.analysis.docgen.model.DocumentGenerationResponse;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.graphicsexport.FlowDocumentGenerationService;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateFlowDocumentationExportStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return CreateFlowDocumentationExportStepParams.class;
        }

        @Override
        public String getType() {
            return "create_flow_documentation_export";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new CreateFlowDocumentationExportStepRunner(scenario, step, step.getParamsAs(CreateFlowDocumentationExportStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "export flow documentation";
        }

        @Override
        public String buildId(Step step) {
            return "create_flow_documentation_export";
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final CreateFlowDocumentationExportStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;
    @Autowired
    private FlowDocumentGenerationService flowDocumentGenerationService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.FDGExportStepRunner");

    public CreateFlowDocumentationExportStepRunner(Scenario scenario, Step step, CreateFlowDocumentationExportStepParams params) {
        this.params = params;
        this.scenario = scenario;
        this.step = step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        String projectKey = this.scenario.getProjectKey();
        DSSAuthCtx user = stepRun.getScenarioRun().getRunAsUser();
        if (this.params.targetFolderId == null) {
            throw new IllegalArgumentException("No target managed folder selected. Select a target managed folder to store the result of the export or remove this step.");
        }
        if (!(this.params.defaultTemplate || this.params.sourceFolderId != null && this.params.templatePath != null)) {
            throw new IllegalArgumentException("No custom template selected. Select a custom template or use default template.");
        }
        ManagedFolder targetMF = this.getManagedFolder(projectKey, this.params.targetFolderId);
        logger.info((Object)"Get FDG template");
        File templateFile = this.getFDGTemplate(user, projectKey);
        ReportTargetItem.FlowDocumentationExportItem target = new ReportTargetItem.FlowDocumentationExportItem(projectKey, this.params.targetFolderId, targetMF.name);
        ReportItem reportItem = new ReportItem.CreatedFlowDocumentExport(target).withStart(System.currentTimeMillis());
        try {
            logger.info((Object)"Start FDG");
            DocumentGenerationResponse fdgResponse = this.flowDocumentGenerationService.getFdgResponse(user, projectKey, new FileInputStream(templateFile));
            File outputFile = this.flowDocumentGenerationService.getFdgFile(fdgResponse.exportId);
            if (outputFile == null) {
                throw new FileNotFoundException("Generated file not found");
            }
            if (this.params.withTimestamp) {
                outputFile = this.appendFileTimestamp(outputFile);
            }
            logger.info((Object)"Transfer file to managed folder");
            try (FileInputStream exportFileStream = new FileInputStream(outputFile);){
                Callable<ManagedFolderHandler.ManagedFolderListingItem> callableUploadHandler;
                try (Transaction ignored = this.transactionService.beginRead();){
                    callableUploadHandler = this.kernelsManagedFolderService.handleUploadRequest(projectKey, targetMF.id, exportFileStream, File.separator + outputFile.getName(), true, user);
                }
                callableUploadHandler.call();
            }
            finally {
                this.flowDocumentGenerationService.clean(outputFile);
            }
            logger.info((Object)"Flow documentation successfully exported");
            reportItem.withEnd(DateTime.now().getMillis());
            if (fdgResponse.data.warning) {
                SmartLogTail logTail = new SmartLogTail();
                logTail.appendLine(fdgResponse.data.report());
                reportItem.withOutcome(ReportItem.Outcome.WARNING).withLogTail(logTail);
            } else {
                reportItem.withOutcome(ReportItem.Outcome.SUCCESS);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to create flow doc", (Throwable)ex);
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            stepReportItem.withThrown(ex);
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(projectKey, targetMF.id), null, null, stepRun.getScenarioRun(), stepRun, reportItem);
        }
        stepReportItem.outcome = reportItem.getOutcome();
        logger.info((Object)("Done step " + this.step.name));
    }

    private File getFDGTemplate(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException, CodedException {
        ManagedFolder source;
        if (this.params.defaultTemplate) {
            return this.flowDocumentGenerationService.getDefaultTemplate();
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            source = this.managedFoldersService.getMandatory(projectKey, this.params.sourceFolderId);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)source.buildHandler(authCtx);){
            File file = new File(handler.getAbsolutePath(this.params.templatePath));
            return file;
        }
    }

    private ManagedFolder getManagedFolder(String projectKey, String folderId) throws IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            ManagedFolder managedFolder = this.managedFoldersService.getMandatory(projectKey, folderId);
            return managedFolder;
        }
    }

    private File appendFileTimestamp(File f) throws IOException {
        Object newFilename = f.getName().replace(".docx", "");
        newFilename = (String)newFilename + new SimpleDateFormat("' - 'yyyyMMdd'-'HHmm'.docx'").format(new Date());
        File outputFileStamped = new File(f.getParent(), (String)newFilename);
        Files.move(f.toPath(), outputFileStamped.toPath(), new CopyOption[0]);
        return outputFileStamped;
    }

    public static class CreateFlowDocumentationExportStepParams
    extends NonFatalStepParams
    implements StepParams {
        private boolean withTimestamp;
        private String targetFolderId;
        private boolean defaultTemplate;
        private String sourceFolderId;
        private String templatePath;
    }
}

