/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.graphicsexport.wikis.WikiExportService;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExport;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExportType;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.CreateBaseExportStepRunner;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.WikisService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateWikiExportStepRunner
extends CreateBaseExportStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return CreateWikiExportStepParams.class;
        }

        @Override
        public String getType() {
            return "create_wiki_export";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new CreateWikiExportStepRunner(scenario, step, step.getParamsAs(CreateWikiExportStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            CreateWikiExportStepParams stepParams = step.getParamsAs(CreateWikiExportStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("export");
            if (stepParams != null) {
                sb.append(" ");
                sb.append(stepParams.articleId);
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            CreateWikiExportStepParams stepParams = step.getParamsAs(CreateWikiExportStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("create_wiki_export");
            if (stepParams != null) {
                sb.append("_");
                sb.append(stepParams.articleId);
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final CreateWikiExportStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private WikiExportService wikiExportService;
    @Autowired
    private WikisService wikisService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.wikiExportStepRunner");

    public CreateWikiExportStepRunner(Scenario scenario, Step step, CreateWikiExportStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        ReportItem reportItem;
        WikiExport export;
        logger.info((Object)("Start step " + this.step.name));
        String projectKey = this.scenario.getProjectKey();
        String articleId = this.params.articleId;
        String folderId = this.params.folderSmartId;
        ErrorContext.checkNotNull((Object)folderId, (String)"No managed folder selected. Select a managed folder to store the result of the export or remove this step.");
        ManagedFolder mf = this.getManagedFolder(projectKey, folderId);
        ErrorContext.checkNotNull((Object)mf, (String)("Unknown managed folder: " + projectKey + "." + folderId));
        this.params.exportFormat.fileType = ExportFormat.FileType.PDF;
        if (this.params.exportType == WikiExportType.WHOLE_WIKI) {
            export = new WikiExport(projectKey, this.params.exportFormat, this.params.exportAttachments);
            ReportTargetItem.WikiExportItem target = new ReportTargetItem.WikiExportItem(projectKey, folderId, mf.name);
            reportItem = new ReportItem.CreatedWikiExport(target);
        } else {
            ErrorContext.checkNotNull((Object)articleId, (String)"No article selected. Select an article to export or remove the step.");
            Article article = this.getArticle(projectKey, articleId);
            ErrorContext.checkNotNull((Object)article, (String)("Unknown article: " + projectKey + "." + articleId));
            ReportTargetItem.WikiArticleExportItem target = new ReportTargetItem.WikiArticleExportItem(projectKey, articleId, article.name, folderId, mf.name);
            reportItem = new ReportItem.CreatedWikiArticleExport(target);
            export = new WikiExport(projectKey, this.params.exportFormat, articleId, this.params.exportType == WikiExportType.ARTICLE_AND_CHILDREN, this.params.exportAttachments);
        }
        this.exportToManagedFolder(projectKey, articleId, folderId, export, this.wikiExportService, stepRun, reportItem.withStart(System.currentTimeMillis()));
        stepReportItem.outcome = reportItem.getOutcome();
        stepReportItem.thrown = reportItem.getThrown();
        logger.info((Object)("Done step " + this.step.name));
    }

    private Article getArticle(String projectKey, String articleId) throws IOException {
        if (projectKey == null || articleId == null) {
            return null;
        }
        try (Transaction t = this.transactionService.beginRead();){
            Article article = this.wikisService.getArticleMandatory(projectKey, articleId);
            return article;
        }
    }

    public static class CreateWikiExportStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String articleId;
        public ExportFormat exportFormat;
        public String folderSmartId;
        public WikiExportType exportType;
        public boolean exportAttachments;
    }
}

