/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.triggers;

import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.security.DSSAuthCtx;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class TriggerFire {
    public String projectKey;
    public String scenarioId;
    public Trigger trigger;
    public String runId;
    public long timestamp;
    public String triggerState;
    public boolean cancelled;
    public JsonObject params = new JsonObject();
    public transient boolean executedFromExternal = false;
    public DSSAuthCtx triggerAuthCtx;

    public TriggerFire() {
    }

    public TriggerFire(TriggerFire triggerFire) {
        this.projectKey = triggerFire.getProjectKey();
        this.scenarioId = triggerFire.getScenarioId();
        this.trigger = triggerFire.getTrigger();
        this.runId = triggerFire.getRunId();
        this.timestamp = triggerFire.getTimestamp();
        this.triggerState = triggerFire.getTriggerState();
        this.cancelled = triggerFire.isCancelled();
        this.params = triggerFire.getParams();
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getRunId() {
        return this.runId;
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getTriggerState() {
        return this.triggerState;
    }

    public JsonObject getParams() {
        return this.params;
    }

    public TriggerFire withProjectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    public TriggerFire withScenarioId(String scenarioId) {
        this.scenarioId = scenarioId;
        return this;
    }

    public TriggerFire withRunId(String runId) {
        this.runId = runId;
        return this;
    }

    public TriggerFire withScenario(Scenario scenario) {
        this.scenarioId = scenario.getId();
        this.projectKey = scenario.getProjectKey();
        return this;
    }

    public TriggerFire withTrigger(Trigger trigger) {
        this.trigger = trigger;
        return this;
    }

    public TriggerFire withTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public TriggerFire withCancelled(boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    public TriggerFire withTriggerState(String triggerState) {
        this.triggerState = triggerState;
        return this;
    }

    public TriggerFire withParams(JsonObject params) {
        this.params = params;
        return this;
    }

    public TriggerFire withParam(String key, Object value) {
        this.params.add(key, new Gson().toJsonTree(value));
        return this;
    }

    public TriggerFire withTriggerAuthCtx(DSSAuthCtx triggerAuthCtx) {
        this.triggerAuthCtx = triggerAuthCtx;
        return this;
    }
}

