/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.pmml.models.classification.multiclass;

import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.scoring.exports.pmml.PMMLPreprocessing;
import com.dataiku.dip.scoring.exports.pmml.XML;
import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLNode;
import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLTransformationDictionary;
import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLTreeGenerator;
import com.dataiku.dip.scoring.exports.pmml.models.PMMLModel;
import com.dataiku.dip.scoring.exports.pmml.models.classification.PMMLClassifier;
import com.dataiku.scoring.models.Classifier;
import com.dataiku.scoring.models.DecisionTreeClassifier;
import com.dataiku.scoring.models.DecisionTreeModel;
import com.dataiku.scoring.pipelines.ClassificationPipeline;
import com.dataiku.scoring.pipelines.MulticlassProbabilisticPipeline;

@XML.Named(name="TreeModel")
public class PMMLTreeMultiClassClassifier
extends PMMLClassifier {
    @XML.Element
    PMMLNode<String> Node;

    public PMMLTreeMultiClassClassifier(ClassificationPipeline pipe, ResolvedPredictionPreprocessingParams rppp, DecisionTreeClassifier otherModel, int treeIndex) {
        super(pipe, rppp);
        this.Output = PMMLModel.PMMLOutput.multiclassClassification(pipe.getClasses());
        String[] colnames = PMMLPreprocessing.normalizedOutputColumns(pipe.getPreprocessing().getOutputColumns(), pipe.getPreprocessing());
        String treeName = Integer.toString(treeIndex);
        this.Node = new PMMLTreeGenerator.PMMLClassificationTreeGenerator((DecisionTreeModel<double[]>)otherModel, treeName, colnames, pipe.getClasses()).generateTree();
    }

    public PMMLTreeMultiClassClassifier(MulticlassProbabilisticPipeline pipe, ResolvedPredictionPreprocessingParams rppp) {
        this((ClassificationPipeline)pipe, rppp, (DecisionTreeClassifier)pipe.getModel(), 0);
    }

    @Override
    public void enrichTransformationDictionaryFromModel(PMMLTransformationDictionary dictionary, String[] colNames, Classifier model) {
        DecisionTreeClassifier[] trees = new DecisionTreeClassifier[]{(DecisionTreeClassifier)model};
        dictionary.addDerivedFieldsForTrees((DecisionTreeModel<T>[])trees, colNames);
    }
}

