/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.AvailablePythonInterpretersService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.connections.HuggingFaceLocalConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DSSInternalCodeEnvController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private DSSInternalCodeEnvsService dssInternalCodeEnvsService;
    @Autowired
    private AvailablePythonInterpretersService availablePythonInterpretersService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ConnectionsService connectionsService;
    public static final DKULogger logger = DKULogger.getLogger((String)"dip.publicapi");

    @AuditedCall(value={"msgType", "dss-internal-code-env-create", "codeEnvVersion", "${codeEnvVersion}", "pythonInterpreter", "${pythonInterpreter}", "dssInternalCodeEnvType", "${dssInternalCodeEnvType}"})
    @RequestMapping(value={"/api/code-envs/dss-internal/create"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<CodeEnvModel.EnvCreationResult> createDSSInternalCodeEnv(HttpServletRequest req, @RequestParam(required=false) String codeEnvVersion, @RequestParam String pythonInterpreter, @RequestParam DSSInternalCodeEnvsService.DSSInternalCodeEnvType dssInternalCodeEnvType) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!authCtx.getPermissions().mayCreateCodeEnvs()) {
                throw new SecurityException("You may not create new code envs");
            }
        }
        return this.dssInternalCodeEnvsService.createCodeEnv(authCtx, dssInternalCodeEnvType, codeEnvVersion, pythonInterpreter);
    }

    @AuditedCall(value={"msgType", "dss-internal-code-env-update", "codeEnvVersion", "${codeEnvVersion}", "dssInternalCodeEnvType", "${dssInternalCodeEnvType}"})
    @RequestMapping(value={"/api/code-envs/dss-internal/update"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<CodeEnvModel.EnvUpdateResult> updateDSSInternalCodeEnv(HttpServletRequest req, @RequestParam(required=false) String codeEnvVersion, @RequestParam DSSInternalCodeEnvsService.DSSInternalCodeEnvType dssInternalCodeEnvType) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
        }
        DSSInternalCodeEnvsService.DSSInternalCodeEnv dssInternalCodeEnv = new DSSInternalCodeEnvsService.DSSInternalCodeEnv(dssInternalCodeEnvType, codeEnvVersion);
        this.permissionsService.checkCodeEnvPrivileges(authCtx, CodeEnvModel.EnvLang.PYTHON, dssInternalCodeEnvType.name, Privileges.CodeEnvLevelPrivilegeType.UPDATE);
        return this.dssInternalCodeEnvsService.updateCodeEnv(authCtx, dssInternalCodeEnv);
    }

    @AuditedCall(value={"msgType", "dss-internal-code-env-check", "codeEnvVersion", "${codeEnvVersion}", "predictionType", "${predictionType}", "dssInternalCodeEnvType", "${dssInternalCodeEnvType}"})
    @RequestMapping(value={"/api/code-envs/dss-internal/check"})
    @ResponseBody
    public Optional<CodeEnvModel.CodeEnvListItem> checkDSSInternalCodeEnv(HttpServletRequest req, @RequestParam(required=false) String codeEnvVersion, @RequestParam DSSInternalCodeEnvsService.DSSInternalCodeEnvType dssInternalCodeEnvType) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        Optional<CodeEnvModel.CodeEnvListItem> env = this.dssInternalCodeEnvsService.getCodeEnv_NT(dssInternalCodeEnvType, codeEnvVersion);
        if (env.isPresent()) {
            env = Optional.of(this.dssInternalCodeEnvsService.enrichCodeEnvListItemWithWarning(env.get(), dssInternalCodeEnvType, codeEnvVersion));
        }
        return env;
    }

    @AuditedCall(value={"msgType", "dss-internal-code-env-get-supported-interpreters", "codeEnvVersion", "${codeEnvVersion}", "dssInternalCodeEnvType", "${dssInternalCodeEnvType}"})
    @RequestMapping(value={"/api/code-envs/dss-internal/supported-interpreters"})
    @ResponseBody
    public List<StandardPythonInterpreter> getSupportedInterpreters(HttpServletRequest req, @RequestParam(required=false) String codeEnvVersion, @RequestParam DSSInternalCodeEnvsService.DSSInternalCodeEnvType dssInternalCodeEnvType) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        return DSSInternalCodeEnvsService.getSupportedInterpreters(dssInternalCodeEnvType, codeEnvVersion);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/code-envs/dss-internal/default-available-interpreter"})
    @ResponseBody
    public StandardPythonInterpreter getDefaultAvailableInterpreter(HttpServletRequest req, @RequestParam(required=false) String codeEnvVersion, @RequestParam DSSInternalCodeEnvsService.DSSInternalCodeEnvType dssInternalCodeEnvType) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        List<StandardPythonInterpreter> availablePythonInterpreters = this.availablePythonInterpretersService.getAvailablePythonInterpreters();
        Optional<StandardPythonInterpreter> preferredInstalledInterpreter = DSSInternalCodeEnvsService.getPreferredInstalledInterpreterOrNull(dssInternalCodeEnvType, codeEnvVersion, availablePythonInterpreters);
        if (preferredInstalledInterpreter.isPresent()) {
            return preferredInstalledInterpreter.get();
        }
        List<StandardPythonInterpreter> supportedPythonInterpreters = DSSInternalCodeEnvsService.getSupportedInterpreters(dssInternalCodeEnvType, codeEnvVersion);
        StandardPythonInterpreter chosenInterpreter = StandardPythonInterpreter.getPreferredOrNull(supportedPythonInterpreters);
        logger.infoV("None of the interpreters supported for this internal code env were found on the machine. Using preferred supported interpreter for this internal code env as default: '%s'.", new Object[]{chosenInterpreter});
        return chosenInterpreter;
    }

    @AuditedCall(value={"msgType", "dss-internal-code-env-check-codeenv-use-for-pii"})
    @RequestMapping(value={"/api/code-envs/dss-internal/check-use-for-pii"})
    @ResponseBody
    public boolean checkUsedEnvPII(HttpServletRequest req) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        GeneralSettingsDAO.GeneralSettings settings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        String piiEnvName = DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.PII_DETECTION_CODE_ENV);
        return Objects.equals(piiEnvName, settings.generativeAISettings.getPresidioBasedPIIDetectionCodeEnv());
    }

    @AuditedCall(value={"msgType", "dss-internal-code-env-check-codeenv-use-for-rag"})
    @RequestMapping(value={"/api/code-envs/dss-internal/check-use-for-rag"})
    @ResponseBody
    public boolean checkUsedEnvRAG(HttpServletRequest req) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        GeneralSettingsDAO.GeneralSettings settings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        String ragEnvName = DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.RAG_CODE_ENV);
        return Objects.equals(ragEnvName, settings.generativeAISettings.getDefaultRetrievableKnowledgeCodeEnv());
    }

    @AuditedCall(value={"msgType", "dss-internal-code-env-check-codeenv-use-for-document-extraction"})
    @RequestMapping(value={"/api/code-envs/dss-internal/check-use-for-document-extraction"})
    @ResponseBody
    public boolean checkUsedEnvDocumentExtraction(HttpServletRequest req) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        GeneralSettingsDAO.GeneralSettings settings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        String documentExtractionEnvName = DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.DOCUMENT_EXTRACTION_CODE_ENV);
        return Objects.equals(documentExtractionEnvName, settings.generativeAISettings.embedDocumentsRecipeSettings.getTextExtractionCodeEnv());
    }

    @AuditedCall(value={"msgType", "dss-internal-code-env-check-codeenv-use-for-hf"})
    @RequestMapping(value={"/api/code-envs/dss-internal/check-use-for-hf"})
    @ResponseBody
    public List<String> checkUsedEnvHF(HttpServletRequest req) throws IOException {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        String hfEnvName = DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.HUGGINGFACE_LOCAL_CODE_ENV);
        ArrayList<String> incorrectHFConnections = new ArrayList<String>();
        this.connectionsService.listUnsafe().forEach((s, dssConnection) -> {
            if (dssConnection.getType().equals("HuggingFaceLocal")) {
                HuggingFaceLocalConnection hfConn = (HuggingFaceLocalConnection)dssConnection;
                if (!Objects.equals(hfEnvName, hfConn.params.getCodeEnvName()) && hfConn.isFreelyUsableBy(authCtx)) {
                    incorrectHFConnections.add(hfConn.name);
                }
            }
        });
        return incorrectHFConnections;
    }
}

