/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.autorestart.AutoRestartingLoopThread;
import com.dataiku.dip.dao.ContinuousActivitiesPersistentStateDAO;
import com.dataiku.dip.dataflow.streaming.ContinuousActivitiesManager;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ContinuousActivitiesController
extends DIPInternalControllerBase {
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private UIAuthService uiAuthService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ContinuousActivitiesManager continuousActivitiesManager;
    @Autowired
    private NavigatorService navigatorService;

    @RequestMapping(value={"/api/continuous-activities/list-project-states"})
    public void listProjectStates(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx = null;
        boolean keepFutureIds = false;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIds = true;
            } else {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
        }
        ContinuousActivitiesManager.ContinuousActivitiesCurrentState states = this.continuousActivitiesManager.listProjectStates_autoTxn(projectKey);
        if (!keepFutureIds) {
            states.activities.forEach(ContinuousActivitiesManager.ContinuousActivityCurrentState::stripFutureIds);
        }
        ContinuousActivitiesController.writeJSON((HttpServletResponse)resp, (Object)states);
    }

    @RequestMapping(value={"/api/continuous-activities/get-state"})
    public void getState(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String continuousActivityId) throws Exception {
        AuthCtx authCtx = null;
        boolean keepFutureIds = false;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIds = true;
            } else {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
        }
        ContinuousActivitiesManager.ContinuousActivityCurrentState state = this.continuousActivitiesManager.getStateOrNull(projectKey, continuousActivityId);
        if (state == null) {
            state = new ContinuousActivitiesManager.ContinuousActivityCurrentState();
            state.projectKey = projectKey;
            state.recipeId = continuousActivityId;
            state.desiredState = ContinuousActivitiesPersistentStateDAO.DesiredState.STOPPED;
        }
        if (!keepFutureIds) {
            state.stripFutureIds();
        }
        ContinuousActivitiesController.writeJSON((HttpServletResponse)resp, (Object)state);
    }

    @RequestMapping(value={"/api/continuous-activities/get-states"})
    public void getStates(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx = null;
        boolean keepFutureIds = false;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIds = true;
            } else {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
        }
        ContinuousActivitiesManager.ContinuousActivitiesCurrentState states = this.continuousActivitiesManager.listProjectStates_autoTxn(projectKey);
        if (!keepFutureIds) {
            states.activities.forEach(ContinuousActivitiesManager.ContinuousActivityCurrentState::stripFutureIds);
        }
        ContinuousActivitiesController.writeJSON((HttpServletResponse)resp, (Object)states);
    }

    @RequestMapping(value={"/api/continuous-activities/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String continuousActivityId) throws Exception {
        AuthCtx authCtx = null;
        boolean keepFutureIds = false;
        ContinuousActivityFullInfo ret = new ContinuousActivityFullInfo();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIds = true;
            } else {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            ret.recipe = this.navigatorService.getRecipeFullInfo(projectKey, continuousActivityId);
        }
        ret.state = this.continuousActivitiesManager.getState(projectKey, continuousActivityId);
        if (!keepFutureIds) {
            ret.state.stripFutureIds();
        }
        ContinuousActivitiesController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @RequestMapping(value={"/api/continuous-activities/list-last-runs"})
    public void listLastRuns(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String continuousActivityId, @RequestParam(required=false, defaultValue="100") int limit) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ContinuousActivityRunsList ret = new ContinuousActivityRunsList();
        File runsDir = ApplicationConfigurator.getFile((String[])new String[]{"streaming-logs", projectKey, continuousActivityId, "runs"});
        if (runsDir.isDirectory()) {
            for (File runDir : runsDir.listFiles()) {
                if (!runDir.getName().startsWith("run-")) continue;
                ContinuousActivityRun car = new ContinuousActivityRun();
                car.runId = runDir.getName().replace("run-", "");
                String mostRecentAttempt = "";
                for (File attemptDir : runDir.listFiles()) {
                    if (!attemptDir.getName().startsWith("attempt-") || attemptDir.getName().compareTo(mostRecentAttempt) <= 0) continue;
                    mostRecentAttempt = attemptDir.getName();
                }
                if (StringUtils.isNotBlank((String)mostRecentAttempt)) {
                    File errorFile;
                    File attemptDir = new File(runDir, mostRecentAttempt);
                    File statusFile = new File(attemptDir, "status.json");
                    if (statusFile.exists() && statusFile.isFile()) {
                        car.lastStatus = (String)JSON.parseFile((File)statusFile, String.class);
                    }
                    if ((errorFile = new File(attemptDir, "error.json")).exists() && errorFile.isFile()) {
                        car.lastError = (SerializedError)JSON.parseFile((File)errorFile, SerializedError.class);
                    }
                }
                ret.runs.add(car);
            }
        }
        Collections.sort(ret.runs, new Comparator<ContinuousActivityRun>(){

            @Override
            public int compare(ContinuousActivityRun a, ContinuousActivityRun b) {
                return b.runId.compareTo(a.runId);
            }
        });
        if (limit > 0 && ret.runs.size() > limit) {
            ret.runs = ret.runs.subList(0, limit);
        }
        ContinuousActivitiesController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @RequestMapping(value={"/api/continuous-activities/list-run-last-attempts"})
    public void listRunAttempts(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String continuousActivityId, @RequestParam String runId, @RequestParam(required=false, defaultValue="100") int limit) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ContinuousActivityAttemptsList ret = new ContinuousActivityAttemptsList();
        File runDir = ApplicationConfigurator.getFile((String[])new String[]{"streaming-logs", projectKey, continuousActivityId, "runs", "run-" + runId});
        if (runDir.isDirectory()) {
            for (File attemptDir : runDir.listFiles()) {
                File errorFile;
                if (!attemptDir.getName().startsWith("attempt-")) continue;
                ContinuousActivityAttempt cat = new ContinuousActivityAttempt();
                cat.attemptId = attemptDir.getName().replace("attempt-", "");
                File statusFile = new File(attemptDir, "status.json");
                if (statusFile.exists() && statusFile.isFile()) {
                    cat.status = (String)JSON.parseFile((File)statusFile, String.class);
                }
                if ((errorFile = new File(attemptDir, "error.json")).exists() && errorFile.isFile()) {
                    cat.error = (SerializedError)JSON.parseFile((File)errorFile, SerializedError.class);
                }
                ret.attempts.add(cat);
            }
        }
        Collections.sort(ret.attempts, new Comparator<ContinuousActivityAttempt>(){

            @Override
            public int compare(ContinuousActivityAttempt a, ContinuousActivityAttempt b) {
                return b.attemptId.compareTo(a.attemptId);
            }
        });
        if (limit > 0 && ret.attempts.size() > limit) {
            ret.attempts = ret.attempts.subList(0, limit);
        }
        ContinuousActivitiesController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @RequestMapping(value={"/api/continuous-activities/smart-tail-attempt-log"})
    public void smartTailAttemptLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String continuousActivityId, @RequestParam String runId, @RequestParam String attemptId, @RequestParam(defaultValue="200") int nbLines) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        File attemptLogFile = ApplicationConfigurator.getFile((String[])new String[]{"streaming-logs", projectKey, continuousActivityId, "runs", "run-" + runId, "attempt-" + attemptId, "output.log"});
        if (attemptLogFile.isFile()) {
            String tail = DKUtils.tailFile((File)attemptLogFile, (int)nbLines);
            ContinuousActivitiesController.writeJSON((HttpServletResponse)resp, (Object)FlowJobUtils.getSmartLogTail(tail, null));
        } else {
            resp.setStatus(404);
            resp.getWriter().write("attempt log file not found");
        }
    }

    @RequestMapping(value={"/api/continuous-activities/cat-attempt-log"})
    public void catAttemptLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String continuousActivityId, @RequestParam String runId, @RequestParam String attemptId) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        File attemptLogFile = ApplicationConfigurator.getFile((String[])new String[]{"streaming-logs", projectKey, continuousActivityId, "runs", "run-" + runId, "attempt-" + attemptId, "output.log"});
        if (attemptLogFile.exists()) {
            resp.setContentType("text/plain; charset=UTF-8");
            try (FileInputStream fis = new FileInputStream(attemptLogFile);){
                IOUtils.copy((InputStream)fis, (OutputStream)resp.getOutputStream());
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("attempt log file not found");
        }
    }

    @RequestMapping(value={"/api/continuous-activities/start"})
    public void startContinuouActivity(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeId, @RequestParam String loopParams) throws Exception {
        AutoRestartingLoopThread.AutoRestartingLoopParams lp = StringUtils.isNotBlank((String)loopParams) ? (AutoRestartingLoopThread.AutoRestartingLoopParams)JSON.parse((String)loopParams, AutoRestartingLoopThread.AutoRestartingLoopParams.class) : null;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        ContinuousActivitiesController.writeJSON((HttpServletResponse)resp, this.continuousActivitiesManager.start_NT(authCtx, projectKey, recipeId, lp));
    }

    @RequestMapping(value={"/api/continuous-activities/stop"})
    public void stopContinuouActivity(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeId) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.continuousActivitiesManager.stop_NT(authCtx, projectKey, recipeId);
    }

    @RequestMapping(value={"/api/continuous-activities/get-global-status"})
    public void getCAStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeId) throws Exception {
        AuthCtx authCtx = null;
        boolean keepFutureIds = false;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIds = true;
            } else {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
        }
        ContinuousActivitiesManager.ContinuousActivitiesCurrentState globalState = this.continuousActivitiesManager.getGlobalState();
        if (!keepFutureIds) {
            globalState.activities.forEach(ContinuousActivitiesManager.ContinuousActivityCurrentState::stripFutureIds);
        }
        ContinuousActivitiesController.writeJSON((HttpServletResponse)resp, (Object)globalState);
    }

    public static class ContinuousActivityFullInfo {
        public ContinuousActivitiesManager.ContinuousActivityCurrentState state;
        public NavigatorService.RecipeFullInfo recipe;
    }

    static class ContinuousActivityRunsList {
        List<ContinuousActivityRun> runs = new ArrayList<ContinuousActivityRun>();

        ContinuousActivityRunsList() {
        }
    }

    static class ContinuousActivityRun {
        String runId;
        String lastStatus;
        SerializedError lastError;

        ContinuousActivityRun() {
        }
    }

    static class ContinuousActivityAttemptsList {
        List<ContinuousActivityAttempt> attempts = new ArrayList<ContinuousActivityAttempt>();

        ContinuousActivityAttemptsList() {
        }
    }

    static class ContinuousActivityAttempt {
        String attemptId;
        String status;
        SerializedError error;

        ContinuousActivityAttempt() {
        }
    }
}

